/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.utils.SearchIterator;

public abstract class Rows {
    private static final SearchIterator<ColumnDefinition, ColumnData> EMPTY_SEARCH_ITERATOR = new SearchIterator<ColumnDefinition, ColumnData>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ColumnData next(ColumnDefinition column) {
            return null;
        }
    };
    public static final Row EMPTY_STATIC_ROW = BTreeRow.emptyRow(Clustering.STATIC_CLUSTERING);

    private Rows() {
    }

    public static Row.Builder copy(Row row, Row.Builder builder) {
        builder.newRow(row.clustering());
        builder.addPrimaryKeyLivenessInfo(row.primaryKeyLivenessInfo());
        builder.addRowDeletion(row.deletion());
        for (ColumnData cd : row) {
            if (cd.column().isSimple()) {
                builder.addCell((Cell)cd);
                continue;
            }
            ComplexColumnData complexData = (ComplexColumnData)cd;
            builder.addComplexDeletion(complexData.column(), complexData.complexDeletion());
            for (Cell cell : complexData) {
                builder.addCell(cell);
            }
        }
        return builder;
    }

    public static int collectStats(Row row, PartitionStatisticsCollector collector) {
        assert (!row.isEmpty());
        collector.update(row.primaryKeyLivenessInfo());
        collector.update(row.deletion());
        int columnCount = 0;
        int cellCount = 0;
        for (ColumnData cd : row) {
            if (cd.column().isSimple()) {
                ++columnCount;
                ++cellCount;
                Cells.collectStats((Cell)cd, collector);
                continue;
            }
            ComplexColumnData complexData = (ComplexColumnData)cd;
            collector.update(complexData.complexDeletion());
            if (!complexData.hasCells()) continue;
            ++columnCount;
            for (Cell cell : complexData) {
                ++cellCount;
                Cells.collectStats(cell, collector);
            }
        }
        collector.updateColumnSetPerRow(columnCount);
        return cellCount;
    }

    public static void diff(RowDiffListener diffListener, Row merged, Columns columns, Row ... inputs) {
        Clustering clustering = merged.clustering();
        LivenessInfo mergedInfo = merged.primaryKeyLivenessInfo().isEmpty() ? null : merged.primaryKeyLivenessInfo();
        DeletionTime mergedDeletion = merged.deletion().isLive() ? null : merged.deletion();
        for (int i = 0; i < inputs.length; ++i) {
            DeletionTime inputDeletion;
            Row input = inputs[i];
            Row[] inputInfo = input == null || input.primaryKeyLivenessInfo().isEmpty() ? null : input.primaryKeyLivenessInfo();
            DeletionTime deletionTime = inputDeletion = input == null || input.deletion().isLive() ? null : input.deletion();
            if (mergedInfo != null || inputInfo != null) {
                diffListener.onPrimaryKeyLivenessInfo(i, clustering, mergedInfo, (LivenessInfo)inputInfo);
            }
            if (mergedDeletion == null && inputDeletion == null) continue;
            diffListener.onDeletion(i, clustering, mergedDeletion, inputDeletion);
        }
        SearchIterator<ColumnDefinition, ColumnData> mergedIterator = merged.searchIterator();
        ArrayList<SearchIterator<ColumnDefinition, ColumnData>> inputIterators = new ArrayList<SearchIterator<ColumnDefinition, ColumnData>>(inputs.length);
        for (Row row : inputs) {
            inputIterators.add(row == null ? EMPTY_SEARCH_ITERATOR : row.searchIterator());
        }
        Iterator<ColumnDefinition> simpleColumns = columns.simpleColumns();
        while (simpleColumns.hasNext()) {
            ColumnDefinition column = simpleColumns.next();
            Cell mergedCell = (Cell)mergedIterator.next(column);
            for (int i = 0; i < inputs.length; ++i) {
                Cell inputCell = (Cell)((SearchIterator)inputIterators.get(i)).next(column);
                if (mergedCell == null && inputCell == null) continue;
                diffListener.onCell(i, clustering, mergedCell, inputCell);
            }
        }
        Iterator<ColumnDefinition> complexColumns = columns.complexColumns();
        while (complexColumns.hasNext()) {
            ColumnDefinition column = complexColumns.next();
            ComplexColumnData mergedData = (ComplexColumnData)mergedIterator.next(column);
            for (int i = 0; i < inputs.length; ++i) {
                ComplexColumnData inputData = (ComplexColumnData)((SearchIterator)inputIterators.get(i)).next(column);
                if (mergedData == null) {
                    if (inputData == null) continue;
                    if (!inputData.complexDeletion().isLive()) {
                        diffListener.onComplexDeletion(i, clustering, column, null, inputData.complexDeletion());
                    }
                    for (Cell inputCell : inputData) {
                        diffListener.onCell(i, clustering, null, inputCell);
                    }
                    continue;
                }
                if (inputData == null) {
                    if (!mergedData.complexDeletion().isLive()) {
                        diffListener.onComplexDeletion(i, clustering, column, mergedData.complexDeletion(), null);
                    }
                    for (Cell mergedCell : mergedData) {
                        diffListener.onCell(i, clustering, mergedCell, null);
                    }
                    continue;
                }
                PeekingIterator mergedCells = Iterators.peekingIterator(mergedData.iterator());
                PeekingIterator inputCells = Iterators.peekingIterator(inputData.iterator());
                while (mergedCells.hasNext() && inputCells.hasNext()) {
                    int cmp = column.cellPathComparator().compare(((Cell)mergedCells.peek()).path(), ((Cell)inputCells.peek()).path());
                    if (cmp == 0) {
                        diffListener.onCell(i, clustering, (Cell)mergedCells.next(), (Cell)inputCells.next());
                        continue;
                    }
                    if (cmp < 0) {
                        diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                        continue;
                    }
                    diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                }
                while (mergedCells.hasNext()) {
                    diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                }
                while (inputCells.hasNext()) {
                    diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                }
            }
        }
    }

    public static Row merge(Row row1, Row row2, int nowInSec) {
        Columns mergedColumns = row1.columns().mergeTo(row2.columns());
        Row.Builder builder = BTreeRow.sortedBuilder(mergedColumns);
        Rows.merge(row1, row2, mergedColumns, builder, nowInSec);
        return builder.build();
    }

    public static long merge(Row existing, Row update, Columns mergedColumns, Row.Builder builder, int nowInSec) {
        ColumnDefinition c;
        int i;
        DeletionTime deletion;
        Clustering clustering = existing.clustering();
        builder.newRow(clustering);
        LivenessInfo existingInfo = existing.primaryKeyLivenessInfo();
        LivenessInfo updateInfo = update.primaryKeyLivenessInfo();
        LivenessInfo mergedInfo = existingInfo.supersedes(updateInfo) ? existingInfo : updateInfo;
        long timeDelta = Math.abs(existingInfo.timestamp() - mergedInfo.timestamp());
        DeletionTime deletionTime = deletion = existing.deletion().supersedes(update.deletion()) ? existing.deletion() : update.deletion();
        if (deletion.deletes(mergedInfo)) {
            mergedInfo = LivenessInfo.EMPTY;
        }
        builder.addPrimaryKeyLivenessInfo(mergedInfo);
        builder.addRowDeletion(deletion);
        for (i = 0; i < mergedColumns.simpleColumnCount(); ++i) {
            c = mergedColumns.getSimple(i);
            Cell existingCell = existing.getCell(c);
            Cell updateCell = update.getCell(c);
            timeDelta = Math.min(timeDelta, Cells.reconcile(existingCell, updateCell, deletion, builder, nowInSec));
        }
        for (i = 0; i < mergedColumns.complexColumnCount(); ++i) {
            DeletionTime maxDt;
            c = mergedColumns.getComplex(i);
            ComplexColumnData existingData = existing.getComplexColumnData(c);
            ComplexColumnData updateData = update.getComplexColumnData(c);
            DeletionTime existingDt = existingData == null ? DeletionTime.LIVE : existingData.complexDeletion();
            DeletionTime updateDt = updateData == null ? DeletionTime.LIVE : updateData.complexDeletion();
            DeletionTime deletionTime2 = maxDt = existingDt.supersedes(updateDt) ? existingDt : updateDt;
            if (maxDt.supersedes(deletion)) {
                builder.addComplexDeletion(c, maxDt);
            } else {
                maxDt = deletion;
            }
            Iterator<Cell> existingCells = existingData == null ? null : existingData.iterator();
            Iterator<Cell> updateCells = updateData == null ? null : updateData.iterator();
            timeDelta = Math.min(timeDelta, Cells.reconcileComplex(c, existingCells, updateCells, maxDt, builder, nowInSec));
        }
        return timeDelta;
    }
}

