/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.view.MaterializedView;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore baseCfs;
    private final MaterializedView view;
    private final UUID compactionId;
    private volatile Token prevToken = null;
    private static final Logger logger = LoggerFactory.getLogger(MaterializedViewBuilder.class);
    private volatile boolean isStopped = false;

    public MaterializedViewBuilder(ColumnFamilyStore baseCfs, MaterializedView view) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    /*
     * Exception decompiling
     */
    private void buildKey(DecoratedKey key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void run() {
        Token lastToken;
        Object object;
        Object temp;
        Function<View, Iterable<SSTableReader>> function;
        String ksname = this.baseCfs.metadata.ksName;
        String viewName = this.view.name;
        if (SystemKeyspace.isViewBuilt(ksname, viewName)) {
            return;
        }
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.baseCfs.metadata.ksName);
        final Pair<Integer, Token> buildStatus = SystemKeyspace.getMaterializedViewBuildStatus(ksname, viewName);
        if (buildStatus == null) {
            this.baseCfs.forceBlockingFlush();
            function = View.select(SSTableSet.CANONICAL);
            int generation = Integer.MIN_VALUE;
            temp = this.baseCfs.selectAndReference((Function<View, Iterable<SSTableReader>>)function).refs;
            Throwable throwable = null;
            try {
                object = ((Refs)temp).iterator();
                while (object.hasNext()) {
                    SSTableReader reader = object.next();
                    generation = Math.max(reader.descriptor.generation, generation);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (temp != null) {
                    if (throwable != null) {
                        try {
                            ((Refs)temp).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Refs)temp).close();
                    }
                }
            }
            SystemKeyspace.beginMaterializedViewBuild(ksname, viewName, generation);
            lastToken = null;
        } else {
            function = new Function<View, Iterable<SSTableReader>>(){

                @Nullable
                public Iterable<SSTableReader> apply(View view) {
                    Iterable readers = (Iterable)View.select(SSTableSet.CANONICAL).apply((Object)view);
                    if (readers != null) {
                        return Iterables.filter((Iterable)readers, ssTableReader -> ssTableReader.descriptor.generation <= (Integer)pair.left);
                    }
                    return null;
                }
            };
            lastToken = (Token)buildStatus.right;
        }
        this.prevToken = lastToken;
        try {
            Refs<SSTableReader> sstables = this.baseCfs.selectAndReference((Function<View, Iterable<SSTableReader>>)function).refs;
            temp = null;
            try {
                ReducingKeyIterator iter = new ReducingKeyIterator(sstables);
                object = null;
                try {
                    while (!this.isStopped && iter.hasNext()) {
                        DecoratedKey key = iter.next();
                        Token token = key.getToken();
                        if (lastToken != null && lastToken.compareTo(token) >= 0) continue;
                        for (Range range : ranges) {
                            if (!range.contains(token)) continue;
                            this.buildKey(key);
                            if (this.prevToken != null && this.prevToken.compareTo(token) == 0) continue;
                            SystemKeyspace.updateMaterializedViewBuildStatus(ksname, viewName, key.getToken());
                            this.prevToken = token;
                        }
                        lastToken = null;
                    }
                    SystemKeyspace.finishMaterializedViewBuildStatus(ksname, viewName);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (iter != null) {
                        if (object != null) {
                            try {
                                iter.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            iter.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                temp = throwable;
                throw throwable;
            }
            finally {
                if (sstables != null) {
                    if (temp != null) {
                        try {
                            sstables.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)temp).addSuppressed(throwable);
                        }
                    } else {
                        sstables.close();
                    }
                }
            }
        }
        catch (Exception e) {
            MaterializedViewBuilder builder = new MaterializedViewBuilder(this.baseCfs, this.view);
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitMaterializedViewBuilder(builder), 5L, TimeUnit.MINUTES);
            logger.warn("Materialized View failed to complete, sleeping 5 minutes before restarting", (Throwable)e);
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        long rangesLeft = 0L;
        long rangesTotal = 0L;
        Token lastToken = this.prevToken;
        for (Range<Token> range : StorageService.instance.getLocalRanges(this.baseCfs.keyspace.getName())) {
            ++rangesLeft;
            ++rangesTotal;
            if (lastToken != null && !range.contains(lastToken)) continue;
            rangesLeft = 0L;
        }
        return new CompactionInfo(this.baseCfs.metadata, OperationType.VIEW_BUILD, rangesLeft, rangesTotal, "ranges", this.compactionId);
    }

    @Override
    public void stop() {
        this.isStopped = true;
    }
}

