/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.cassandra.io.util.AbstractDataInput;

public final class ChecksummedDataInput
extends AbstractDataInput {
    private final CRC32 crc;
    private final AbstractDataInput source;
    private int limit;

    private ChecksummedDataInput(AbstractDataInput source) {
        this.source = source;
        this.crc = new CRC32();
        this.limit = Integer.MAX_VALUE;
    }

    public static ChecksummedDataInput wrap(AbstractDataInput source) {
        return new ChecksummedDataInput(source);
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public void resetLimit() {
        this.limit = Integer.MAX_VALUE;
    }

    public void limit(int newLimit) {
        this.limit = newLimit;
    }

    public int bytesRemaining() {
        return this.limit;
    }

    public int getCrc() {
        return (int)this.crc.getValue();
    }

    @Override
    public void seek(long position) throws IOException {
        this.source.seek(position);
    }

    @Override
    public long getPosition() {
        return this.source.getPosition();
    }

    @Override
    public long getPositionLimit() {
        return this.source.getPositionLimit();
    }

    @Override
    public int read() throws IOException {
        int b = this.source.read();
        this.crc.update(b);
        --this.limit;
        return b;
    }

    @Override
    public int read(byte[] buff, int offset, int length) throws IOException {
        if (length > this.limit) {
            throw new IOException("Digest mismatch exception");
        }
        int copied = this.source.read(buff, offset, length);
        this.crc.update(buff, offset, copied);
        this.limit -= copied;
        return copied;
    }
}

