/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;

public final class ReplicationParams {
    public static final String CLASS = "class";
    public final Class<? extends AbstractReplicationStrategy> klass;
    public final ImmutableMap<String, String> options;

    private ReplicationParams(Class<? extends AbstractReplicationStrategy> klass, Map<String, String> options) {
        this.klass = klass;
        this.options = ImmutableMap.copyOf(options);
    }

    static ReplicationParams local() {
        return new ReplicationParams(LocalStrategy.class, (Map<String, String>)ImmutableMap.of());
    }

    static ReplicationParams simple(int replicationFactor) {
        return new ReplicationParams(SimpleStrategy.class, (Map<String, String>)ImmutableMap.of((Object)"replication_factor", (Object)Integer.toString(replicationFactor)));
    }

    public void validate(String name) {
        TokenMetadata tmd = StorageService.instance.getTokenMetadata();
        IEndpointSnitch eps = DatabaseDescriptor.getEndpointSnitch();
        AbstractReplicationStrategy.validateReplicationStrategy(name, this.klass, tmd, eps, this.options);
    }

    public static ReplicationParams fromMap(Map<String, String> map) {
        HashMap<String, String> options = new HashMap<String, String>(map);
        String className = (String)options.remove(CLASS);
        Class<AbstractReplicationStrategy> klass = AbstractReplicationStrategy.getClass(className);
        return new ReplicationParams(klass, options);
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>((Map<String, String>)this.options);
        map.put(CLASS, this.klass.getName());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationParams)) {
            return false;
        }
        ReplicationParams r = (ReplicationParams)o;
        return this.klass.equals(r.klass) && this.options.equals(r.options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.klass, this.options});
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add(CLASS, (Object)this.klass.getName());
        for (Map.Entry entry : this.options.entrySet()) {
            helper.add((String)entry.getKey(), entry.getValue());
        }
        return helper.toString();
    }
}

