/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.utils.AbstractIterator;

public class MultiPartitionPager
implements QueryPager {
    private final SinglePartitionPager[] pagers;
    private final DataLimits limit;
    private final int nowInSec;
    private int remaining;
    private int current;

    public MultiPartitionPager(SinglePartitionReadCommand.Group group, PagingState state) {
        int i;
        this.limit = group.limits();
        this.nowInSec = group.nowInSec();
        if (state != null) {
            for (i = 0; i < group.commands.size() && !group.commands.get(i).partitionKey().getKey().equals(state.partitionKey); ++i) {
            }
        }
        if (i >= group.commands.size()) {
            this.pagers = null;
            return;
        }
        this.pagers = new SinglePartitionPager[group.commands.size() - i];
        this.pagers[0] = group.commands.get(i).getPager(state);
        for (int j = i + 1; j < group.commands.size(); ++j) {
            this.pagers[j - i] = group.commands.get(j).getPager(null);
        }
        this.remaining = state == null ? this.limit.count() : state.remaining;
    }

    @Override
    public PagingState state() {
        if (this.isExhausted()) {
            return null;
        }
        PagingState state = this.pagers[this.current].state();
        return new PagingState(this.pagers[this.current].key(), state == null ? null : state.cellName, this.remaining, Integer.MAX_VALUE);
    }

    @Override
    public boolean isExhausted() {
        if (this.remaining <= 0 || this.pagers == null) {
            return true;
        }
        while (this.current < this.pagers.length) {
            if (!this.pagers[this.current].isExhausted()) {
                return false;
            }
            ++this.current;
        }
        return true;
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        for (int i = this.current; i < this.pagers.length; ++i) {
            if (this.pagers[i] == null) continue;
            return this.pagers[i].startOrderGroup();
        }
        throw new AssertionError((Object)"Shouldn't be called on an exhausted pager");
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState) throws RequestValidationException, RequestExecutionException {
        int toQuery = Math.min(this.remaining, pageSize);
        PagersIterator iter = new PagersIterator(toQuery, consistency, clientState, null);
        CountingPartitionIterator countingIter = new CountingPartitionIterator(iter, this.limit.forPaging(toQuery), this.nowInSec);
        iter.setCounter(countingIter.counter());
        return countingIter;
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadOrderGroup orderGroup) throws RequestValidationException, RequestExecutionException {
        int toQuery = Math.min(this.remaining, pageSize);
        PagersIterator iter = new PagersIterator(toQuery, null, null, orderGroup);
        CountingPartitionIterator countingIter = new CountingPartitionIterator(iter, this.limit.forPaging(toQuery), this.nowInSec);
        iter.setCounter(countingIter.counter());
        return countingIter;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    private class PagersIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final int pageSize;
        private PartitionIterator result;
        private DataLimits.Counter counter;
        private final ConsistencyLevel consistency;
        private final ClientState clientState;
        private final ReadOrderGroup orderGroup;

        public PagersIterator(int pageSize, ConsistencyLevel consistency, ClientState clientState, ReadOrderGroup orderGroup) {
            this.pageSize = pageSize;
            this.consistency = consistency;
            this.clientState = clientState;
            this.orderGroup = orderGroup;
        }

        public void setCounter(DataLimits.Counter counter) {
            this.counter = counter;
        }

        @Override
        protected RowIterator computeNext() {
            while (this.result == null || !this.result.hasNext()) {
                if (MultiPartitionPager.this.isExhausted()) {
                    return (RowIterator)this.endOfData();
                }
                if (this.result != null) {
                    this.result.close();
                }
                int toQuery = this.pageSize - this.counter.counted();
                this.result = this.consistency == null ? MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].fetchPageInternal(toQuery, this.orderGroup) : MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].fetchPage(toQuery, this.consistency, this.clientState);
            }
            return (RowIterator)this.result.next();
        }

        @Override
        public void close() {
            MultiPartitionPager.this.remaining = MultiPartitionPager.this.remaining - this.counter.counted();
            if (this.result != null) {
                this.result.close();
            }
        }
    }
}

