/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.CountingPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.SinglePartitionPager;

public class QueryPagers {
    private QueryPagers() {
    }

    public static int countPaged(CFMetaData metadata, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter, DataLimits limits, ConsistencyLevel consistencyLevel, ClientState state, int pageSize, int nowInSec, boolean isForThrift) throws RequestValidationException, RequestExecutionException {
        SinglePartitionReadCommand<?> command = SinglePartitionReadCommand.create(isForThrift, metadata, nowInSec, columnFilter, RowFilter.NONE, limits, key, filter);
        SinglePartitionPager pager = new SinglePartitionPager(command, null);
        int count = 0;
        while (!pager.isExhausted()) {
            CountingPartitionIterator iter = new CountingPartitionIterator(pager.fetchPage(pageSize, consistencyLevel, state), limits, nowInSec);
            Throwable throwable = null;
            try {
                PartitionIterators.consume(iter);
                count += iter.counter().counted();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iter.close();
            }
        }
        return count;
    }
}

