/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;

public final class Throwables {
    public static <T extends Throwable> T merge(T existingFail, T newFail) {
        if (existingFail == null) {
            return newFail;
        }
        existingFail.addSuppressed(newFail);
        return existingFail;
    }

    public static void maybeFail(Throwable fail) {
        if (Throwables.failIfCanCast(fail, null)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> void maybeFail(Throwable fail, Class<T> checked) throws T {
        if (Throwables.failIfCanCast(fail, checked)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> boolean failIfCanCast(Throwable fail, Class<T> checked) throws T {
        if (fail == null) {
            return false;
        }
        if (fail instanceof Error) {
            throw (Error)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        if (checked != null && checked.isInstance(fail)) {
            throw (Throwable)checked.cast(fail);
        }
        return true;
    }

    @SafeVarargs
    public static <E extends Exception> void perform(DiscreteAction<? extends E> ... actions) throws E {
        Throwables.perform(Arrays.stream(actions));
    }

    public static <E extends Exception> void perform(Stream<DiscreteAction<? extends E>> actions) throws E {
        Throwable fail = null;
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            DiscreteAction action = (DiscreteAction)iter.next();
            try {
                action.perform();
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        if (Throwables.failIfCanCast(fail, null)) {
            throw (Exception)fail;
        }
    }

    @SafeVarargs
    public static void perform(File against, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        Throwables.perform(Arrays.stream(actions).map(action -> () -> {
            try {
                action.perform();
            }
            catch (IOException e) {
                throw opType == FileOpType.WRITE ? new FSWriteError((Throwable)e, against) : new FSReadError((Throwable)e, against);
            }
        }));
    }

    public static interface DiscreteAction<E extends Exception> {
        public void perform() throws E;
    }

    public static enum FileOpType {
        READ,
        WRITE;

    }
}

