/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTriggerStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(DropTriggerStatement.class);
    private final String triggerName;
    private final boolean ifExists;

    public DropTriggerStatement(CFName name, String triggerName, boolean ifExists) {
        super(name);
        this.triggerName = triggerName;
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureIsSuper("Only superusers are allowed to perfrom DROP TRIGGER queries");
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws ConfigurationException, InvalidRequestException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        Triggers triggers = cfm.getTriggers();
        if (!triggers.get(this.triggerName).isPresent()) {
            if (this.ifExists) {
                return false;
            }
            throw new InvalidRequestException(String.format("Trigger %s was not found", this.triggerName));
        }
        logger.info("Dropping trigger with name {}", (Object)this.triggerName);
        cfm.triggers(triggers.without(this.triggerName));
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        return true;
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

