/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.SimpleDateSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SimpleDateType
extends AbstractType<Integer> {
    public static final SimpleDateType instance = new SimpleDateType();

    SimpleDateType() {
        super(AbstractType.ComparisonType.BYTE_ORDER);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        return ByteBufferUtil.bytes(SimpleDateSerializer.dateStringToDays(source));
    }

    public ByteBuffer fromTimeInMillis(long millis) throws MarshalException {
        return ByteBufferUtil.bytes(SimpleDateSerializer.timeInMillisToDay(millis));
    }

    public long toTimeInMillis(ByteBuffer buffer) throws MarshalException {
        return SimpleDateSerializer.dayToTimeInMillis(ByteBufferUtil.toInt(buffer));
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return super.isCompatibleWith(previous);
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || otherType == IntegerType.instance;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a date value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return '\"' + SimpleDateSerializer.instance.toString(SimpleDateSerializer.instance.deserialize(buffer)) + '\"';
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DATE;
    }

    @Override
    public TypeSerializer<Integer> getSerializer() {
        return SimpleDateSerializer.instance;
    }
}

