/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Iterators;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeMaps
implements Iterable<Map.Entry<Range<Token>, List<InetAddress>>> {
    private static final Logger logger = LoggerFactory.getLogger(PendingRangeMaps.class);
    final NavigableMap<Range<Token>, List<InetAddress>> ascendingMap = new TreeMap<Range<Token>, List<InetAddress>>(ascendingComparator);
    static final Comparator<Range<Token>> ascendingComparator = new Comparator<Range<Token>>(){

        @Override
        public int compare(Range<Token> o1, Range<Token> o2) {
            int res = ((Token)o1.right).compareTo(o2.right);
            if (res != 0) {
                return res;
            }
            return ((Token)o2.left).compareTo(o1.left);
        }
    };
    final NavigableMap<Range<Token>, List<InetAddress>> descendingMap = new TreeMap<Range<Token>, List<InetAddress>>(descendingComparator);
    static final Comparator<Range<Token>> descendingComparator = new Comparator<Range<Token>>(){

        @Override
        public int compare(Range<Token> o1, Range<Token> o2) {
            int res = ((Token)o2.left).compareTo(o1.left);
            if (res != 0) {
                return res;
            }
            return ((Token)o2.right).compareTo(o1.right);
        }
    };
    final NavigableMap<Range<Token>, List<InetAddress>> ascendingMapForWrapAround = new TreeMap<Range<Token>, List<InetAddress>>(ascendingComparatorForWrapAround);
    static final Comparator<Range<Token>> ascendingComparatorForWrapAround = new Comparator<Range<Token>>(){

        @Override
        public int compare(Range<Token> o1, Range<Token> o2) {
            int res = ((Token)o1.right).compareTo(o2.right);
            if (res != 0) {
                return res;
            }
            return ((Token)o1.left).compareTo(o2.left);
        }
    };
    final NavigableMap<Range<Token>, List<InetAddress>> descendingMapForWrapAround = new TreeMap<Range<Token>, List<InetAddress>>(descendingComparatorForWrapAround);
    static final Comparator<Range<Token>> descendingComparatorForWrapAround = new Comparator<Range<Token>>(){

        @Override
        public int compare(Range<Token> o1, Range<Token> o2) {
            int res = ((Token)o2.left).compareTo(o1.left);
            if (res != 0) {
                return res;
            }
            return ((Token)o1.right).compareTo(o2.right);
        }
    };

    static final void addToMap(Range<Token> range, InetAddress address, NavigableMap<Range<Token>, List<InetAddress>> ascendingMap, NavigableMap<Range<Token>, List<InetAddress>> descendingMap) {
        ArrayList<InetAddress> addresses = (ArrayList<InetAddress>)ascendingMap.get(range);
        if (addresses == null) {
            addresses = new ArrayList<InetAddress>(1);
            ascendingMap.put(range, addresses);
            descendingMap.put(range, addresses);
        }
        addresses.add(address);
    }

    public void addPendingRange(Range<Token> range, InetAddress address) {
        if (Range.isWrapAround(range.left, range.right)) {
            PendingRangeMaps.addToMap(range, address, this.ascendingMapForWrapAround, this.descendingMapForWrapAround);
        } else {
            PendingRangeMaps.addToMap(range, address, this.ascendingMap, this.descendingMap);
        }
    }

    static final void addIntersections(Set<InetAddress> endpointsToAdd, NavigableMap<Range<Token>, List<InetAddress>> smallerMap, NavigableMap<Range<Token>, List<InetAddress>> biggerMap) {
        for (Range range : smallerMap.keySet()) {
            List addresses = (List)biggerMap.get(range);
            if (addresses == null) continue;
            endpointsToAdd.addAll(addresses);
        }
    }

    public Collection<InetAddress> pendingEndpointsFor(Token token) {
        HashSet<InetAddress> endpoints = new HashSet<InetAddress>();
        Range<Token> searchRange = new Range<Token>(token, token);
        NavigableMap<Range<Token>, List<InetAddress>> ascendingTailMap = this.ascendingMap.tailMap(searchRange, true);
        NavigableMap<Range<Token>, List<InetAddress>> descendingTailMap = this.descendingMap.tailMap(searchRange, false);
        if (ascendingTailMap.size() < descendingTailMap.size()) {
            PendingRangeMaps.addIntersections(endpoints, ascendingTailMap, descendingTailMap);
        } else {
            PendingRangeMaps.addIntersections(endpoints, descendingTailMap, ascendingTailMap);
        }
        ascendingTailMap = this.ascendingMapForWrapAround.tailMap(searchRange, true);
        descendingTailMap = this.descendingMapForWrapAround.tailMap(searchRange, false);
        for (Map.Entry entry : ascendingTailMap.entrySet()) {
            endpoints.addAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : descendingTailMap.entrySet()) {
            endpoints.addAll((Collection)entry.getValue());
        }
        return endpoints;
    }

    public String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this) {
            Range<Token> range = entry.getKey();
            for (InetAddress address : entry.getValue()) {
                sb.append(address).append(':').append(range);
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<Range<Token>, List<InetAddress>>> iterator() {
        return Iterators.concat(this.ascendingMap.entrySet().iterator(), this.ascendingMapForWrapAround.entrySet().iterator());
    }
}

