/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.CLibraryDarwin;
import org.apache.cassandra.utils.CLibraryLinux;
import org.apache.cassandra.utils.CLibraryWindows;
import org.apache.cassandra.utils.CLibraryWrapper;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CLibrary {
    private static final Logger logger = LoggerFactory.getLogger(CLibrary.class);
    private static final OSType osType;
    private static final int MCL_CURRENT;
    private static final int MCL_FUTURE;
    private static final int ENOMEM = 12;
    private static final int F_GETFL = 3;
    private static final int F_SETFL = 4;
    private static final int F_NOCACHE = 48;
    private static final int O_DIRECT = 16384;
    private static final int O_RDONLY = 0;
    private static final int POSIX_FADV_NORMAL = 0;
    private static final int POSIX_FADV_RANDOM = 1;
    private static final int POSIX_FADV_SEQUENTIAL = 2;
    private static final int POSIX_FADV_WILLNEED = 3;
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final int POSIX_FADV_NOREUSE = 5;
    private static final CLibraryWrapper wrappedCLibrary;
    private static boolean jnaLockable;

    private CLibrary() {
    }

    private static OSType getOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            return OSType.MAC;
        }
        if (osName.contains("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.contains("aix")) {
            return OSType.AIX;
        }
        return OSType.LINUX;
    }

    private static int errno(RuntimeException e) {
        assert (e instanceof LastErrorException);
        try {
            return ((LastErrorException)e).getErrorCode();
        }
        catch (NoSuchMethodError x) {
            logger.warn("Obsolete version of JNA present; unable to read errno. Upgrade to JNA 3.2.7 or later");
            return 0;
        }
    }

    public static boolean jnaAvailable() {
        return wrappedCLibrary.jnaAvailable();
    }

    public static boolean jnaMemoryLockable() {
        return jnaLockable;
    }

    public static void tryMlockall() {
        block5: {
            try {
                wrappedCLibrary.callMlockall(MCL_CURRENT);
                jnaLockable = true;
                logger.info("JNA mlockall successful");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (RuntimeException e) {
                if (!(e instanceof LastErrorException)) {
                    throw e;
                }
                if (CLibrary.errno(e) == 12 && osType == OSType.LINUX) {
                    logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out, especially with mmapped I/O enabled. Increase RLIMIT_MEMLOCK or run Cassandra as root.");
                }
                if (osType == OSType.MAC) break block5;
                logger.warn("Unknown mlockall error {}", (Object)CLibrary.errno(e));
            }
        }
    }

    public static void trySkipCache(String path, long offset, long len) {
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(f);){
            CLibrary.trySkipCache(CLibrary.getfd(fis.getChannel()), offset, len, path);
        }
        catch (IOException e) {
            logger.warn("Could not skip cache", (Throwable)e);
        }
    }

    public static void trySkipCache(int fd, long offset, long len, String path) {
        if (len == 0L) {
            CLibrary.trySkipCache(fd, 0L, 0, path);
        }
        while (len > 0L) {
            int sublen = (int)Math.min(Integer.MAX_VALUE, len);
            CLibrary.trySkipCache(fd, offset, sublen, path);
            len -= (long)sublen;
            offset -= (long)sublen;
        }
    }

    public static void trySkipCache(int fd, long offset, int len, String path) {
        if (fd < 0) {
            return;
        }
        try {
            int result;
            if (osType == OSType.LINUX && (result = wrappedCLibrary.callPosixFadvise(fd, offset, len, 4)) != 0) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 10L, TimeUnit.MINUTES, "Failed trySkipCache on file: {} Error: " + wrappedCLibrary.callStrerror(result).getString(0L), path);
            }
        }
        catch (UnsatisfiedLinkError result) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("posix_fadvise(%d, %d) failed, errno (%d).", fd, offset, CLibrary.errno(e)));
        }
    }

    public static int tryFcntl(int fd, int command, int flags) {
        int result = -1;
        try {
            result = wrappedCLibrary.callFcntl(fd, command, flags);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("fcntl(%d, %d, %d) failed, errno (%d).", fd, command, flags, CLibrary.errno(e)));
        }
        return result;
    }

    public static int tryOpenDirectory(String path) {
        int fd = -1;
        try {
            return wrappedCLibrary.callOpen(path, 0);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("open(%s, O_RDONLY) failed, errno (%d).", path, CLibrary.errno(e)));
        }
        return fd;
    }

    public static void trySync(int fd) {
        if (fd == -1) {
            return;
        }
        try {
            wrappedCLibrary.callFsync(fd);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn("fsync({}) failed, errorno ({}) {}", new Object[]{fd, CLibrary.errno(e), e});
        }
    }

    public static void tryCloseFD(int fd) {
        if (fd == -1) {
            return;
        }
        try {
            wrappedCLibrary.callClose(fd);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("close(%d) failed, errno (%d).", fd, CLibrary.errno(e)));
        }
    }

    public static int getfd(FileChannel channel) {
        Field field = FBUtilities.getProtectedField(channel.getClass(), "fd");
        try {
            return CLibrary.getfd((FileDescriptor)field.get(channel));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.warn("Unable to read fd field from FileChannel");
            return -1;
        }
    }

    public static int getfd(FileDescriptor descriptor) {
        Field field = FBUtilities.getProtectedField(descriptor.getClass(), "fd");
        try {
            return field.getInt(descriptor);
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            logger.warn("Unable to read fd field from FileDescriptor");
            return -1;
        }
    }

    public static long getProcessID() {
        try {
            return wrappedCLibrary.callGetpid();
        }
        catch (Exception e) {
            logger.info("Failed to get PID from JNA", (Throwable)e);
            return -1L;
        }
    }

    static {
        jnaLockable = false;
        osType = CLibrary.getOsType();
        switch (osType) {
            case MAC: {
                wrappedCLibrary = new CLibraryDarwin();
                break;
            }
            case WINDOWS: {
                wrappedCLibrary = new CLibraryWindows();
                break;
            }
            default: {
                wrappedCLibrary = new CLibraryLinux();
            }
        }
        if (System.getProperty("os.arch").toLowerCase().contains("ppc")) {
            if (osType == OSType.LINUX) {
                MCL_CURRENT = 8192;
                MCL_FUTURE = 16384;
            } else if (osType == OSType.AIX) {
                MCL_CURRENT = 256;
                MCL_FUTURE = 512;
            } else {
                MCL_CURRENT = 1;
                MCL_FUTURE = 2;
            }
        } else {
            MCL_CURRENT = 1;
            MCL_FUTURE = 2;
        }
    }

    public static enum OSType {
        LINUX,
        MAC,
        WINDOWS,
        AIX,
        OTHER;

    }
}

