/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="tablestats", description="Print statistics on tables")
public class TableStats
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace.table>...]", description="List of tables (or keyspace) names")
    private List<String> tableNames = new ArrayList<String>();
    @Option(name={"-i"}, description="Ignore the list of tables and display the remaining tables")
    private boolean ignore = false;
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KB, MB, GB, TB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        ArrayList<ColumnFamilyStoreMBean> columnFamilies;
        PrintStream out = probe.output().out;
        OptionFilter filter = new OptionFilter(this.ignore, this.tableNames);
        HashMap tableStoreMap = new HashMap();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> tables = probe.getColumnFamilyStoreMBeanProxies();
        while (tables.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = tables.next();
            String keyspaceName = entry.getKey();
            ColumnFamilyStoreMBean tableProxy = entry.getValue();
            if (!tableStoreMap.containsKey(keyspaceName) && filter.isColumnFamilyIncluded(entry.getKey(), tableProxy.getColumnFamilyName())) {
                columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                columnFamilies.add(tableProxy);
                tableStoreMap.put(keyspaceName, columnFamilies);
                continue;
            }
            if (!filter.isColumnFamilyIncluded(entry.getKey(), tableProxy.getColumnFamilyName())) continue;
            ((List)tableStoreMap.get(keyspaceName)).add(tableProxy);
        }
        filter.verifyKeyspaces(probe.getKeyspaces());
        filter.verifyColumnFamilies();
        for (Map.Entry entry : tableStoreMap.entrySet()) {
            String keyspaceName = (String)entry.getKey();
            columnFamilies = (ArrayList<ColumnFamilyStoreMBean>)entry.getValue();
            long keyspaceReadCount = 0L;
            long keyspaceWriteCount = 0L;
            int keyspacePendingFlushes = 0;
            double keyspaceTotalReadTime = 0.0;
            double keyspaceTotalWriteTime = 0.0;
            out.println("Keyspace: " + keyspaceName);
            for (ColumnFamilyStoreMBean table : columnFamilies) {
                String tableName = table.getColumnFamilyName();
                long writeCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getCount();
                long readCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getCount();
                if (readCount > 0L) {
                    keyspaceReadCount += readCount;
                    keyspaceTotalReadTime += (double)((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadTotalLatency")).longValue();
                }
                if (writeCount > 0L) {
                    keyspaceWriteCount += writeCount;
                    keyspaceTotalWriteTime += (double)((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteTotalLatency")).longValue();
                }
                keyspacePendingFlushes = (int)((long)keyspacePendingFlushes + (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "PendingFlushes"));
            }
            double keyspaceReadLatency = keyspaceReadCount > 0L ? keyspaceTotalReadTime / (double)keyspaceReadCount / 1000.0 : Double.NaN;
            double keyspaceWriteLatency = keyspaceWriteCount > 0L ? keyspaceTotalWriteTime / (double)keyspaceWriteCount / 1000.0 : Double.NaN;
            out.println("\tRead Count: " + keyspaceReadCount);
            out.println("\tRead Latency: " + String.format("%s", keyspaceReadLatency) + " ms.");
            out.println("\tWrite Count: " + keyspaceWriteCount);
            out.println("\tWrite Latency: " + String.format("%s", keyspaceWriteLatency) + " ms.");
            out.println("\tPending Flushes: " + keyspacePendingFlushes);
            for (ColumnFamilyStoreMBean table : columnFamilies) {
                Long offHeapSize;
                Long compressionMetadataOffHeapSize;
                Long indexSummaryOffHeapSize;
                Long bloomFilterOffHeapSize;
                Long memtableOffHeapSize;
                String tableName;
                block22: {
                    tableName = table.getColumnFamilyName();
                    if (tableName.contains(".")) {
                        out.println("\t\tTable (index): " + tableName);
                    } else {
                        out.println("\t\tTable: " + tableName);
                    }
                    out.println("\t\tSSTable count: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveSSTableCount"));
                    int[] leveledSStables = table.getSSTableCountPerLevel();
                    if (leveledSStables != null) {
                        out.print("\t\tSSTables in each level: [");
                        for (int level = 0; level < leveledSStables.length; ++level) {
                            int count = leveledSStables[level];
                            out.print(count);
                            long maxCount = 4L;
                            if (level > 0) {
                                maxCount = (long)Math.pow(10.0, level);
                            }
                            if ((long)count > maxCount) {
                                out.print("/" + maxCount);
                            }
                            if (level < leveledSStables.length - 1) {
                                out.print(", ");
                                continue;
                            }
                            out.println("]");
                        }
                    }
                    memtableOffHeapSize = null;
                    bloomFilterOffHeapSize = null;
                    indexSummaryOffHeapSize = null;
                    compressionMetadataOffHeapSize = null;
                    offHeapSize = null;
                    try {
                        memtableOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableOffHeapSize");
                        bloomFilterOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterOffHeapMemoryUsed");
                        indexSummaryOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "IndexSummaryOffHeapMemoryUsed");
                        compressionMetadataOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionMetadataOffHeapMemoryUsed");
                        offHeapSize = memtableOffHeapSize + bloomFilterOffHeapSize + indexSummaryOffHeapSize + compressionMetadataOffHeapSize;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InstanceNotFoundException) break block22;
                        throw e;
                    }
                }
                out.println("\t\tSpace used (live): " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveDiskSpaceUsed"), this.humanReadable));
                out.println("\t\tSpace used (total): " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "TotalDiskSpaceUsed"), this.humanReadable));
                out.println("\t\tSpace used by snapshots (total): " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "SnapshotsSize"), this.humanReadable));
                if (offHeapSize != null) {
                    out.println("\t\tOff heap memory used (total): " + this.format(offHeapSize, this.humanReadable));
                }
                out.println("\t\tSSTable Compression Ratio: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionRatio"));
                Object estimatedPartitionCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "EstimatedPartitionCount");
                if (Long.valueOf(-1L).equals(estimatedPartitionCount)) {
                    estimatedPartitionCount = 0L;
                }
                out.println("\t\tNumber of partitions (estimate): " + estimatedPartitionCount);
                out.println("\t\tMemtable cell count: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableColumnsCount"));
                out.println("\t\tMemtable data size: " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableLiveDataSize"), this.humanReadable));
                if (memtableOffHeapSize != null) {
                    out.println("\t\tMemtable off heap memory used: " + this.format(memtableOffHeapSize, this.humanReadable));
                }
                out.println("\t\tMemtable switch count: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableSwitchCount"));
                out.println("\t\tLocal read count: " + ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getCount());
                double localReadLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getMean() / 1000.0;
                double localRLatency = localReadLatency > 0.0 ? localReadLatency : Double.NaN;
                out.printf("\t\tLocal read latency: %01.3f ms%n", localRLatency);
                out.println("\t\tLocal write count: " + ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getCount());
                double localWriteLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getMean() / 1000.0;
                double localWLatency = localWriteLatency > 0.0 ? localWriteLatency : Double.NaN;
                out.printf("\t\tLocal write latency: %01.3f ms%n", localWLatency);
                out.println("\t\tPending flushes: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "PendingFlushes"));
                out.println("\t\tBloom filter false positives: " + probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterFalsePositives"));
                out.printf("\t\tBloom filter false ratio: %s%n", String.format("%01.5f", probe.getColumnFamilyMetric(keyspaceName, tableName, "RecentBloomFilterFalseRatio")));
                out.println("\t\tBloom filter space used: " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterDiskSpaceUsed"), this.humanReadable));
                if (bloomFilterOffHeapSize != null) {
                    out.println("\t\tBloom filter off heap memory used: " + this.format(bloomFilterOffHeapSize, this.humanReadable));
                }
                if (indexSummaryOffHeapSize != null) {
                    out.println("\t\tIndex summary off heap memory used: " + this.format(indexSummaryOffHeapSize, this.humanReadable));
                }
                if (compressionMetadataOffHeapSize != null) {
                    out.println("\t\tCompression metadata off heap memory used: " + this.format(compressionMetadataOffHeapSize, this.humanReadable));
                }
                out.println("\t\tCompacted partition minimum bytes: " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MinPartitionSize"), this.humanReadable));
                out.println("\t\tCompacted partition maximum bytes: " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxPartitionSize"), this.humanReadable));
                out.println("\t\tCompacted partition mean bytes: " + this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MeanPartitionSize"), this.humanReadable));
                CassandraMetricsRegistry.JmxHistogramMBean histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveScannedHistogram");
                out.println("\t\tAverage live cells per slice (last five minutes): " + histogram.getMean());
                out.println("\t\tMaximum live cells per slice (last five minutes): " + histogram.getMax());
                histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "TombstoneScannedHistogram");
                out.println("\t\tAverage tombstones per slice (last five minutes): " + histogram.getMean());
                out.println("\t\tMaximum tombstones per slice (last five minutes): " + histogram.getMax());
                out.println("");
            }
            out.println("----------------");
        }
    }

    private String format(long bytes, boolean humanReadable) {
        return humanReadable ? FileUtils.stringifyFileSize(bytes) : Long.toString(bytes);
    }

    private static class OptionFilter {
        private Map<String, List<String>> filter = new HashMap<String, List<String>>();
        private Map<String, List<String>> verifier = new HashMap<String, List<String>>();
        private List<String> filterList = new ArrayList<String>();
        private boolean ignoreMode;

        public OptionFilter(boolean ignoreMode, List<String> filterList) {
            this.filterList.addAll(filterList);
            this.ignoreMode = ignoreMode;
            for (String s : filterList) {
                String[] keyValues = s.split("\\.", 2);
                if (!this.filter.containsKey(keyValues[0])) {
                    this.filter.put(keyValues[0], new ArrayList());
                    this.verifier.put(keyValues[0], new ArrayList());
                    if (keyValues.length != 2) continue;
                    this.filter.get(keyValues[0]).add(keyValues[1]);
                    this.verifier.get(keyValues[0]).add(keyValues[1]);
                    continue;
                }
                if (keyValues.length != 2) continue;
                this.filter.get(keyValues[0]).add(keyValues[1]);
                this.verifier.get(keyValues[0]).add(keyValues[1]);
            }
        }

        public boolean isColumnFamilyIncluded(String keyspace, String columnFamily) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            List<String> tables = this.filter.get(keyspace);
            if (tables == null) {
                return this.ignoreMode;
            }
            if (tables.size() == 0) {
                return !this.ignoreMode;
            }
            this.verifier.get(keyspace).remove(columnFamily);
            return this.ignoreMode ^ tables.contains(columnFamily);
        }

        public void verifyKeyspaces(List<String> keyspaces) {
            for (String ks : this.verifier.keySet()) {
                if (keyspaces.contains(ks)) continue;
                throw new IllegalArgumentException("Unknown keyspace: " + ks);
            }
        }

        public void verifyColumnFamilies() {
            for (String ks : this.filter.keySet()) {
                if (this.verifier.get(ks).size() <= 0) continue;
                throw new IllegalArgumentException("Unknown tables: " + this.verifier.get(ks) + " in keyspace: " + ks);
            }
        }
    }
}

