/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.ClusteringColumnRestrictions;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
import org.apache.cassandra.cql3.restrictions.IndexRestrictions;
import org.apache.cassandra.cql3.restrictions.PartitionKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PartitionKeySingleRestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.btree.BTreeSet;

public final class StatementRestrictions {
    public static final String REQUIRES_ALLOW_FILTERING_MESSAGE = "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING";
    private final StatementType type;
    public final CFMetaData cfm;
    private PartitionKeyRestrictions partitionKeyRestrictions;
    private ClusteringColumnRestrictions clusteringColumnsRestrictions;
    private RestrictionSet nonPrimaryKeyRestrictions;
    private Set<ColumnDefinition> notNullColumns;
    private final IndexRestrictions filterRestrictions = new IndexRestrictions();
    private boolean usesSecondaryIndexing;
    private boolean isKeyRange;
    private boolean hasRegularColumnsRestrictions;

    public static StatementRestrictions empty(StatementType type, CFMetaData cfm) {
        return new StatementRestrictions(type, cfm, false);
    }

    private StatementRestrictions(StatementType type, CFMetaData cfm, boolean allowFiltering) {
        this.type = type;
        this.cfm = cfm;
        this.partitionKeyRestrictions = new PartitionKeySingleRestrictionSet(cfm.getKeyValidatorAsClusteringComparator());
        this.clusteringColumnsRestrictions = new ClusteringColumnRestrictions(cfm, allowFiltering);
        this.nonPrimaryKeyRestrictions = new RestrictionSet();
        this.notNullColumns = new HashSet<ColumnDefinition>();
    }

    public StatementRestrictions(StatementType type, CFMetaData cfm, WhereClause whereClause, VariableSpecifications boundNames, boolean selectsOnlyStaticColumns, boolean selectsComplexColumn, boolean allowFiltering, boolean forView) {
        this(type, cfm, allowFiltering);
        SecondaryIndexManager secondaryIndexManager = null;
        if (type.allowUseOfSecondaryIndices()) {
            ColumnFamilyStore cfs = Keyspace.open(cfm.ksName).getColumnFamilyStore(cfm.cfName);
            secondaryIndexManager = cfs.indexManager;
        }
        for (Relation relation : whereClause.relations) {
            if (relation.operator() == Operator.IS_NOT) {
                if (!forView) {
                    throw new InvalidRequestException("Unsupported restriction: " + relation);
                }
                for (ColumnDefinition def : relation.toRestriction(cfm, boundNames).getColumnDefs()) {
                    this.notNullColumns.add(def);
                }
                continue;
            }
            if (relation.isLIKE()) {
                Restriction restriction = relation.toRestriction(cfm, boundNames);
                if (!type.allowUseOfSecondaryIndices() || !restriction.hasSupportingIndex(secondaryIndexManager)) {
                    throw new InvalidRequestException(String.format("LIKE restriction is only supported on properly indexed columns. %s is not valid.", relation.toString()));
                }
                this.addRestriction(restriction);
                continue;
            }
            this.addRestriction(relation.toRestriction(cfm, boundNames));
        }
        this.hasRegularColumnsRestrictions = this.nonPrimaryKeyRestrictions.hasRestrictionFor(ColumnDefinition.Kind.REGULAR);
        boolean hasQueriableClusteringColumnIndex = false;
        boolean hasQueriableIndex = false;
        if (type.allowUseOfSecondaryIndices()) {
            if (whereClause.containsCustomExpressions()) {
                this.processCustomIndexExpressions(whereClause.expressions, boundNames, secondaryIndexManager);
            }
            hasQueriableClusteringColumnIndex = this.clusteringColumnsRestrictions.hasSupportingIndex(secondaryIndexManager);
            hasQueriableIndex = !this.filterRestrictions.getCustomIndexExpressions().isEmpty() || hasQueriableClusteringColumnIndex || this.partitionKeyRestrictions.hasSupportingIndex(secondaryIndexManager) || this.nonPrimaryKeyRestrictions.hasSupportingIndex(secondaryIndexManager);
        }
        this.processPartitionKeyRestrictions(hasQueriableIndex, allowFiltering, forView);
        if (this.usesSecondaryIndexing || this.partitionKeyRestrictions.needFiltering(cfm)) {
            this.filterRestrictions.add(this.partitionKeyRestrictions);
        }
        if (selectsOnlyStaticColumns && this.hasClusteringColumnsRestrictions()) {
            if (type.isDelete() || type.isUpdate()) {
                throw RequestValidations.invalidRequest("Invalid restrictions on clustering columns since the %s statement modifies only static columns", new Object[]{type});
            }
            if (type.isSelect()) {
                throw RequestValidations.invalidRequest("Cannot restrict clustering columns when selecting only static columns", new Object[0]);
            }
        }
        this.processClusteringColumnsRestrictions(hasQueriableIndex, selectsOnlyStaticColumns, selectsComplexColumn, forView, allowFiltering);
        if (this.isKeyRange && hasQueriableClusteringColumnIndex) {
            this.usesSecondaryIndexing = true;
        }
        if (this.usesSecondaryIndexing || this.clusteringColumnsRestrictions.needFiltering()) {
            this.filterRestrictions.add(this.clusteringColumnsRestrictions);
        }
        if (!this.nonPrimaryKeyRestrictions.isEmpty()) {
            if (!type.allowNonPrimaryKeyInWhereClause()) {
                Collection<ColumnIdentifier> nonPrimaryKeyColumns = ColumnDefinition.toIdentifiers(this.nonPrimaryKeyRestrictions.getColumnDefs());
                throw RequestValidations.invalidRequest("Non PRIMARY KEY columns found in where clause: %s ", Joiner.on((String)", ").join(nonPrimaryKeyColumns));
            }
            if (hasQueriableIndex) {
                this.usesSecondaryIndexing = true;
            } else if (!allowFiltering) {
                throw RequestValidations.invalidRequest(REQUIRES_ALLOW_FILTERING_MESSAGE, new Object[0]);
            }
            this.filterRestrictions.add(this.nonPrimaryKeyRestrictions);
        }
        if (this.usesSecondaryIndexing) {
            this.validateSecondaryIndexSelections(selectsOnlyStaticColumns);
        }
    }

    private void addRestriction(Restriction restriction) {
        ColumnDefinition def = restriction.getFirstColumn();
        if (def.isPartitionKey()) {
            this.partitionKeyRestrictions = this.partitionKeyRestrictions.mergeWith(restriction);
        } else if (def.isClusteringColumn()) {
            this.clusteringColumnsRestrictions = this.clusteringColumnsRestrictions.mergeWith(restriction);
        } else {
            this.nonPrimaryKeyRestrictions = this.nonPrimaryKeyRestrictions.addRestriction((SingleRestriction)restriction);
        }
    }

    public void addFunctionsTo(List<Function> functions) {
        this.partitionKeyRestrictions.addFunctionsTo(functions);
        this.clusteringColumnsRestrictions.addFunctionsTo(functions);
        this.nonPrimaryKeyRestrictions.addFunctionsTo(functions);
    }

    public IndexRestrictions getIndexRestrictions() {
        return this.filterRestrictions;
    }

    public Set<ColumnDefinition> nonPKRestrictedColumns(boolean includeNotNullRestrictions) {
        HashSet<ColumnDefinition> columns = new HashSet<ColumnDefinition>();
        for (Restrictions r : this.filterRestrictions.getRestrictions()) {
            for (ColumnDefinition def : r.getColumnDefs()) {
                if (def.isPrimaryKeyColumn()) continue;
                columns.add(def);
            }
        }
        if (includeNotNullRestrictions) {
            for (ColumnDefinition def : this.notNullColumns) {
                if (def.isPrimaryKeyColumn()) continue;
                columns.add(def);
            }
        }
        return columns;
    }

    public Set<ColumnDefinition> notNullColumns() {
        return this.notNullColumns;
    }

    public boolean isRestricted(ColumnDefinition column) {
        if (this.notNullColumns.contains(column)) {
            return true;
        }
        return this.getRestrictions(column.kind).getColumnDefs().contains(column);
    }

    public boolean keyIsInRelation() {
        return this.partitionKeyRestrictions.hasIN();
    }

    public boolean isKeyRange() {
        return this.isKeyRange;
    }

    public boolean isColumnRestrictedByEq(ColumnDefinition columnDef) {
        Set<Restriction> restrictions = this.getRestrictions(columnDef.kind).getRestrictions(columnDef);
        return restrictions.stream().filter(SingleRestriction.class::isInstance).anyMatch(p -> ((SingleRestriction)p).isEQ());
    }

    private Restrictions getRestrictions(ColumnDefinition.Kind kind) {
        switch (kind) {
            case PARTITION_KEY: {
                return this.partitionKeyRestrictions;
            }
            case CLUSTERING: {
                return this.clusteringColumnsRestrictions;
            }
        }
        return this.nonPrimaryKeyRestrictions;
    }

    public boolean usesSecondaryIndexing() {
        return this.usesSecondaryIndexing;
    }

    private void processPartitionKeyRestrictions(boolean hasQueriableIndex, boolean allowFiltering, boolean forView) {
        if (!this.type.allowPartitionKeyRanges()) {
            RequestValidations.checkFalse(this.partitionKeyRestrictions.isOnToken(), "The token function cannot be used in WHERE clauses for %s statements", new Object[]{this.type});
            if (this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.cfm)) {
                throw RequestValidations.invalidRequest("Some partition key parts are missing: %s", Joiner.on((String)", ").join(this.getPartitionKeyUnrestrictedComponents()));
            }
            RequestValidations.checkFalse(this.partitionKeyRestrictions.hasSlice(), "Only EQ and IN relation are supported on the partition key (unless you use the token() function) for %s statements", new Object[]{this.type});
        } else {
            if (this.partitionKeyRestrictions.isOnToken()) {
                this.isKeyRange = true;
            }
            if (this.partitionKeyRestrictions.isEmpty() && this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.cfm)) {
                this.isKeyRange = true;
                this.usesSecondaryIndexing = hasQueriableIndex;
            }
            if (this.partitionKeyRestrictions.needFiltering(this.cfm)) {
                if (!(allowFiltering || forView || hasQueriableIndex)) {
                    throw new InvalidRequestException(REQUIRES_ALLOW_FILTERING_MESSAGE);
                }
                if (this.partitionKeyRestrictions.hasIN()) {
                    throw new InvalidRequestException("IN restrictions are not supported when the query involves filtering");
                }
                this.isKeyRange = true;
                this.usesSecondaryIndexing = hasQueriableIndex;
            }
        }
    }

    public boolean hasPartitionKeyRestrictions() {
        return !this.partitionKeyRestrictions.isEmpty();
    }

    public boolean hasNonPrimaryKeyRestrictions() {
        return !this.nonPrimaryKeyRestrictions.isEmpty();
    }

    private Collection<ColumnIdentifier> getPartitionKeyUnrestrictedComponents() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>(this.cfm.partitionKeyColumns());
        list.removeAll(this.partitionKeyRestrictions.getColumnDefs());
        return ColumnDefinition.toIdentifiers(list);
    }

    public boolean isPartitionKeyRestrictionsOnToken() {
        return this.partitionKeyRestrictions.isOnToken();
    }

    public boolean clusteringKeyRestrictionsHasIN() {
        return this.clusteringColumnsRestrictions.hasIN();
    }

    private void processClusteringColumnsRestrictions(boolean hasQueriableIndex, boolean selectsOnlyStaticColumns, boolean selectsComplexColumn, boolean forView, boolean allowFiltering) {
        RequestValidations.checkFalse(!this.type.allowClusteringColumnSlices() && this.clusteringColumnsRestrictions.hasSlice(), "Slice restrictions are not supported on the clustering columns in %s statements", new Object[]{this.type});
        if (!this.type.allowClusteringColumnSlices() && (!this.cfm.isCompactTable() || this.cfm.isCompactTable() && !this.hasClusteringColumnsRestrictions())) {
            if (!selectsOnlyStaticColumns && this.hasUnrestrictedClusteringColumns()) {
                throw RequestValidations.invalidRequest("Some clustering keys are missing: %s", Joiner.on((String)", ").join(this.getUnrestrictedClusteringColumns()));
            }
        } else {
            RequestValidations.checkFalse(this.clusteringColumnsRestrictions.hasIN() && selectsComplexColumn, "Cannot restrict clustering columns by IN relations when a collection is selected by the query");
            RequestValidations.checkFalse(this.clusteringColumnsRestrictions.hasContains() && !hasQueriableIndex && !allowFiltering, "Clustering columns can only be restricted with CONTAINS with a secondary index or filtering");
            if (this.hasClusteringColumnsRestrictions() && this.clusteringColumnsRestrictions.needFiltering()) {
                if (hasQueriableIndex || forView) {
                    this.usesSecondaryIndexing = true;
                } else if (!allowFiltering) {
                    List<ColumnDefinition> clusteringColumns = this.cfm.clusteringColumns();
                    LinkedList<ColumnDefinition> restrictedColumns = new LinkedList<ColumnDefinition>(this.clusteringColumnsRestrictions.getColumnDefs());
                    int m = restrictedColumns.size();
                    for (int i = 0; i < m; ++i) {
                        ColumnDefinition restrictedColumn;
                        ColumnDefinition clusteringColumn = clusteringColumns.get(i);
                        if (clusteringColumn.equals(restrictedColumn = (ColumnDefinition)restrictedColumns.get(i))) continue;
                        throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted as preceding column \"%s\" is not restricted", restrictedColumn.name, clusteringColumn.name);
                    }
                }
            }
        }
    }

    private Collection<ColumnIdentifier> getUnrestrictedClusteringColumns() {
        ArrayList<ColumnDefinition> missingClusteringColumns = new ArrayList<ColumnDefinition>(this.cfm.clusteringColumns());
        missingClusteringColumns.removeAll(new LinkedList<ColumnDefinition>(this.clusteringColumnsRestrictions.getColumnDefs()));
        return ColumnDefinition.toIdentifiers(missingClusteringColumns);
    }

    private boolean hasUnrestrictedClusteringColumns() {
        return this.cfm.clusteringColumns().size() != this.clusteringColumnsRestrictions.size();
    }

    private void processCustomIndexExpressions(List<CustomIndexExpression> expressions, VariableSpecifications boundNames, SecondaryIndexManager indexManager) {
        if (!MessagingService.instance().areAllNodesAtLeast30()) {
            throw new InvalidRequestException("Please upgrade all nodes to at least 3.0 before using custom index expressions");
        }
        if (expressions.size() > 1) {
            throw new InvalidRequestException("Multiple custom index expressions in a single query are not supported");
        }
        CustomIndexExpression expression = expressions.get(0);
        CFName cfName = expression.targetIndex.getCfName();
        if (cfName.hasKeyspace() && !expression.targetIndex.getKeyspace().equals(this.cfm.ksName)) {
            throw IndexRestrictions.invalidIndex(expression.targetIndex, this.cfm);
        }
        if (cfName.getColumnFamily() != null && !cfName.getColumnFamily().equals(this.cfm.cfName)) {
            throw IndexRestrictions.invalidIndex(expression.targetIndex, this.cfm);
        }
        if (!this.cfm.getIndexes().has(expression.targetIndex.getIdx())) {
            throw IndexRestrictions.indexNotFound(expression.targetIndex, this.cfm);
        }
        Index index = indexManager.getIndex(this.cfm.getIndexes().get(expression.targetIndex.getIdx()).get());
        if (!index.getIndexMetadata().isCustom()) {
            throw IndexRestrictions.nonCustomIndexInExpression(expression.targetIndex);
        }
        AbstractType<?> expressionType = index.customExpressionValueType();
        if (expressionType == null) {
            throw IndexRestrictions.customExpressionNotSupported(expression.targetIndex);
        }
        expression.prepareValue(this.cfm, expressionType, boundNames);
        this.filterRestrictions.add(expression);
    }

    public RowFilter getRowFilter(SecondaryIndexManager indexManager, QueryOptions options) {
        if (this.filterRestrictions.isEmpty()) {
            return RowFilter.NONE;
        }
        RowFilter filter = RowFilter.create();
        for (Restrictions restrictions : this.filterRestrictions.getRestrictions()) {
            restrictions.addRowFilterTo(filter, indexManager, options);
        }
        for (CustomIndexExpression expression : this.filterRestrictions.getCustomIndexExpressions()) {
            expression.addToRowFilter(filter, this.cfm, options);
        }
        return filter;
    }

    public List<ByteBuffer> getPartitionKeys(QueryOptions options) {
        return this.partitionKeyRestrictions.values(options);
    }

    private ByteBuffer getPartitionKeyBound(Bound b, QueryOptions options) {
        return this.partitionKeyRestrictions.bounds(b, options).get(0);
    }

    public AbstractBounds<PartitionPosition> getPartitionKeyBounds(QueryOptions options) {
        IPartitioner p = this.cfm.partitioner;
        if (this.partitionKeyRestrictions.isOnToken()) {
            return this.getPartitionKeyBoundsForTokenRestrictions(p, options);
        }
        return this.getPartitionKeyBounds(p, options);
    }

    private AbstractBounds<PartitionPosition> getPartitionKeyBounds(IPartitioner p, QueryOptions options) {
        PartitionPosition finishKey;
        if (this.partitionKeyRestrictions.needFiltering(this.cfm)) {
            return new Range<PartitionPosition>(p.getMinimumToken().minKeyBound(), p.getMinimumToken().maxKeyBound());
        }
        ByteBuffer startKeyBytes = this.getPartitionKeyBound(Bound.START, options);
        ByteBuffer finishKeyBytes = this.getPartitionKeyBound(Bound.END, options);
        PartitionPosition startKey = PartitionPosition.ForKey.get(startKeyBytes, p);
        if (startKey.compareTo(finishKey = PartitionPosition.ForKey.get(finishKeyBytes, p)) > 0 && !finishKey.isMinimum()) {
            return null;
        }
        if (this.partitionKeyRestrictions.isInclusive(Bound.START)) {
            return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Bounds<PartitionPosition>(startKey, finishKey) : new IncludingExcludingBounds<PartitionPosition>(startKey, finishKey);
        }
        return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Range<PartitionPosition>(startKey, finishKey) : new ExcludingBounds<PartitionPosition>(startKey, finishKey);
    }

    private AbstractBounds<PartitionPosition> getPartitionKeyBoundsForTokenRestrictions(IPartitioner p, QueryOptions options) {
        Token startToken = this.getTokenBound(Bound.START, options, p);
        Token endToken = this.getTokenBound(Bound.END, options, p);
        boolean includeStart = this.partitionKeyRestrictions.isInclusive(Bound.START);
        boolean includeEnd = this.partitionKeyRestrictions.isInclusive(Bound.END);
        int cmp = startToken.compareTo(endToken);
        if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
            return null;
        }
        Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
        Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
        return new Range<PartitionPosition>(start, end);
    }

    private Token getTokenBound(Bound b, QueryOptions options, IPartitioner p) {
        if (!this.partitionKeyRestrictions.hasBound(b)) {
            return p.getMinimumToken();
        }
        ByteBuffer value = this.partitionKeyRestrictions.bounds(b, options).get(0);
        RequestValidations.checkNotNull(value, "Invalid null token value", new Object[0]);
        return p.getTokenFactory().fromByteArray(value);
    }

    public boolean hasClusteringColumnsRestrictions() {
        return !this.clusteringColumnsRestrictions.isEmpty();
    }

    public NavigableSet<Clustering> getClusteringColumns(QueryOptions options) {
        if (this.cfm.isStaticCompactTable()) {
            return BTreeSet.empty(this.cfm.comparator);
        }
        return this.clusteringColumnsRestrictions.valuesAsClustering(options);
    }

    public NavigableSet<ClusteringBound> getClusteringColumnsBounds(Bound b, QueryOptions options) {
        return this.clusteringColumnsRestrictions.boundsAsClustering(b, options);
    }

    public boolean isColumnRange() {
        int numberOfClusteringColumns = this.cfm.isStaticCompactTable() ? 0 : this.cfm.clusteringColumns().size();
        return this.clusteringColumnsRestrictions.size() < numberOfClusteringColumns || !this.clusteringColumnsRestrictions.hasOnlyEqualityRestrictions();
    }

    public boolean needFiltering() {
        int numberOfRestrictions = this.filterRestrictions.getCustomIndexExpressions().size();
        for (Restrictions restrictions : this.filterRestrictions.getRestrictions()) {
            numberOfRestrictions += restrictions.size();
        }
        return numberOfRestrictions > 1 || numberOfRestrictions == 0 && !this.clusteringColumnsRestrictions.isEmpty() || numberOfRestrictions != 0 && this.nonPrimaryKeyRestrictions.hasMultipleContains();
    }

    private void validateSecondaryIndexSelections(boolean selectsOnlyStaticColumns) {
        RequestValidations.checkFalse(this.keyIsInRelation(), "Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
        RequestValidations.checkFalse(selectsOnlyStaticColumns, "Queries using 2ndary indexes don't support selecting only static columns");
    }

    public boolean hasAllPKColumnsRestrictedByEqualities() {
        return !this.isPartitionKeyRestrictionsOnToken() && !this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.cfm) && this.partitionKeyRestrictions.hasOnlyEqualityRestrictions() && !this.hasUnrestrictedClusteringColumns() && this.clusteringColumnsRestrictions.hasOnlyEqualityRestrictions();
    }

    public boolean hasRegularColumnsRestrictions() {
        return this.hasRegularColumnsRestrictions;
    }
}

