/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.Conditions;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(int boundTerms, CFMetaData cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        super(StatementType.DELETE, boundTerms, cfm, operations, restrictions, conditions, attrs);
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Clustering clustering, UpdateParameters params) throws InvalidRequestException {
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        if (regularDeletions.isEmpty() && staticDeletions.isEmpty()) {
            if (clustering.size() == 0) {
                update.addPartitionDeletion(params.deletionTime());
            } else if (clustering.size() == this.cfm.clusteringColumns().size()) {
                params.newRow(clustering);
                params.addRowDeletion();
                update.add(params.buildRow());
            } else {
                update.add(params.makeRangeTombstone(this.cfm.comparator, clustering));
            }
        } else {
            if (!regularDeletions.isEmpty()) {
                RequestValidations.checkFalse(clustering.size() == 0 && this.cfm.clusteringColumns().size() != 0, "Range deletions are not supported for specific columns");
                params.newRow(clustering);
                for (Operation op : regularDeletions) {
                    op.execute(update.partitionKey(), params);
                }
                update.add(params.buildRow());
            }
            if (!staticDeletions.isEmpty()) {
                params.newRow(Clustering.STATIC_CLUSTERING);
                for (Operation op : staticDeletions) {
                    op.execute(update.partitionKey(), params);
                }
                update.add(params.buildRow());
            }
        }
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Slice slice, UpdateParameters params) {
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        RequestValidations.checkTrue(regularDeletions.isEmpty() && staticDeletions.isEmpty(), "Range deletions are not supported for specific columns");
        update.add(params.makeRangeTombstone(slice));
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final WhereClause whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, WhereClause whereClause, List<Pair<ColumnDefinition.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, StatementType.DELETE, attrs, conditions, false, ifExists);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Conditions conditions, Attributes attrs) {
            Operations operations = new Operations(this.type);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnDefinition def = Parsed.getColumnDefinition(cfm, deletion.affectedColumn());
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", def.name);
                Operation op = deletion.prepare(cfm.ksName, def, cfm);
                op.collectMarkerSpecification(boundNames);
                operations.add(op);
            }
            StatementRestrictions restrictions = this.newRestrictions(cfm, boundNames, operations, this.whereClause, conditions);
            DeleteStatement stmt = new DeleteStatement(boundNames.size(), cfm, operations, restrictions, conditions, attrs);
            if (stmt.hasConditions() && !restrictions.hasAllPKColumnsRestrictedByEqualities()) {
                RequestValidations.checkFalse(operations.appliesToRegularColumns(), "DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to delete non static columns");
                RequestValidations.checkFalse(conditions.appliesToRegularColumns(), "DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to use IF condition on non static columns");
            }
            return stmt;
        }
    }
}

