/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.AbstractClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;

public class ClusteringIndexNamesFilter
extends AbstractClusteringIndexFilter {
    static final ClusteringIndexFilter.InternalDeserializer deserializer = new NamesDeserializer();
    private final NavigableSet<Clustering> clusterings;
    private final NavigableSet<Clustering> clusteringsInQueryOrder;

    public ClusteringIndexNamesFilter(NavigableSet<Clustering> clusterings, boolean reversed) {
        super(reversed);
        assert (!clusterings.contains(Clustering.STATIC_CLUSTERING));
        this.clusterings = clusterings;
        this.clusteringsInQueryOrder = reversed ? clusterings.descendingSet() : clusterings;
    }

    public NavigableSet<Clustering> requestedRows() {
        return this.clusterings;
    }

    @Override
    public boolean selectsAllPartition() {
        return false;
    }

    @Override
    public boolean selects(Clustering clustering) {
        return this.clusterings.contains(clustering);
    }

    @Override
    public ClusteringIndexNamesFilter forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive) {
        NavigableSet<Clustering> newClusterings = this.reversed ? this.clusterings.headSet(lastReturned, inclusive) : this.clusterings.tailSet(lastReturned, inclusive);
        return new ClusteringIndexNamesFilter(newClusterings, this.reversed);
    }

    @Override
    public boolean isFullyCoveredBy(CachedPartition partition) {
        if (partition.isEmpty()) {
            return false;
        }
        return this.clusterings.comparator().compare(this.clusterings.last(), partition.lastRow().clustering()) <= 0;
    }

    @Override
    public boolean isHeadFilter() {
        return false;
    }

    @Override
    public UnfilteredRowIterator filterNotIndexed(final ColumnFilter columnFilter, final UnfilteredRowIterator iterator) {
        class FilterNotIndexed
        extends Transformation {
            FilterNotIndexed() {
            }

            @Override
            public Row applyToStatic(Row row) {
                return columnFilter.fetchedColumns().statics.isEmpty() ? null : row.filter(columnFilter, iterator.metadata());
            }

            @Override
            public Row applyToRow(Row row) {
                return ClusteringIndexNamesFilter.this.clusterings.contains(row.clustering()) ? row.filter(columnFilter, iterator.metadata()) : null;
            }
        }
        return Transformation.apply(iterator, new FilterNotIndexed());
    }

    @Override
    public Slices getSlices(CFMetaData metadata) {
        Slices.Builder builder = new Slices.Builder(metadata.comparator, this.clusteringsInQueryOrder.size());
        for (Clustering clustering : this.clusteringsInQueryOrder) {
            builder.add(Slice.make(clustering));
        }
        return builder.build();
    }

    @Override
    public UnfilteredRowIterator getUnfilteredRowIterator(ColumnFilter columnFilter, Partition partition) {
        final Iterator<Clustering> clusteringIter = this.clusteringsInQueryOrder.iterator();
        final SearchIterator<Clustering, Row> searcher = partition.searchIterator(columnFilter, this.reversed);
        return new AbstractUnfilteredRowIterator(partition.metadata(), partition.partitionKey(), partition.partitionLevelDeletion(), columnFilter.fetchedColumns(), searcher.next(Clustering.STATIC_CLUSTERING), this.reversed, partition.stats()){

            @Override
            protected Unfiltered computeNext() {
                while (clusteringIter.hasNext()) {
                    Row row = (Row)searcher.next(clusteringIter.next());
                    if (row == null) continue;
                    return row;
                }
                return (Unfiltered)this.endOfData();
            }
        };
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        ClusteringComparator comparator = sstable.metadata.comparator;
        List<ByteBuffer> minClusteringValues = sstable.getSSTableMetadata().minClusteringValues;
        List<ByteBuffer> maxClusteringValues = sstable.getSSTableMetadata().maxClusteringValues;
        for (Clustering clustering : this.clusterings) {
            if (!Slice.make(clustering).intersects(comparator, minClusteringValues, maxClusteringValues)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(CFMetaData metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("names(");
        int i = 0;
        for (Clustering clustering : this.clusterings) {
            sb.append(i++ == 0 ? "" : ", ").append(clustering.toString(metadata));
        }
        if (this.reversed) {
            sb.append(", reversed");
        }
        return sb.append(')').toString();
    }

    @Override
    public String toCQLString(CFMetaData metadata) {
        if (metadata.clusteringColumns().isEmpty() || this.clusterings.size() <= 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(ColumnDefinition.toCQLString(metadata.clusteringColumns())).append(')');
        sb.append(this.clusterings.size() == 1 ? " = " : " IN (");
        int i = 0;
        for (Clustering clustering : this.clusterings) {
            sb.append(i++ == 0 ? "" : ", ").append("(").append(clustering.toCQLString(metadata)).append(")");
        }
        sb.append(this.clusterings.size() == 1 ? "" : ")");
        this.appendOrderByToCQLString(metadata, sb);
        return sb.toString();
    }

    @Override
    public ClusteringIndexFilter.Kind kind() {
        return ClusteringIndexFilter.Kind.NAMES;
    }

    @Override
    protected void serializeInternal(DataOutputPlus out, int version) throws IOException {
        ClusteringComparator comparator = (ClusteringComparator)this.clusterings.comparator();
        out.writeUnsignedVInt(this.clusterings.size());
        for (Clustering clustering : this.clusterings) {
            Clustering.serializer.serialize(clustering, out, version, comparator.subtypes());
        }
    }

    @Override
    protected long serializedSizeInternal(int version) {
        ClusteringComparator comparator = (ClusteringComparator)this.clusterings.comparator();
        long size = TypeSizes.sizeofUnsignedVInt(this.clusterings.size());
        for (Clustering clustering : this.clusterings) {
            size += Clustering.serializer.serializedSize(clustering, version, comparator.subtypes());
        }
        return size;
    }

    private static class NamesDeserializer
    implements ClusteringIndexFilter.InternalDeserializer {
        private NamesDeserializer() {
        }

        @Override
        public ClusteringIndexFilter deserialize(DataInputPlus in, int version, CFMetaData metadata, boolean reversed) throws IOException {
            ClusteringComparator comparator = metadata.comparator;
            BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(comparator);
            int size = (int)in.readUnsignedVInt();
            for (int i = 0; i < size; ++i) {
                clusterings.add(Clustering.serializer.deserialize(in, version, comparator.subtypes()));
            }
            return new ClusteringIndexNamesFilter(clusterings.build(), reversed);
        }
    }
}

