/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.ImmutableMap;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import org.apache.cassandra.auth.jmx.AuthenticationProxy;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.RMIServerSocketFactoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.rmi.registry.RegistryImpl;

public class JMXServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(JMXServerUtils.class);

    public static JMXConnectorServer createJMXServer(int port, boolean local) throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        InetAddress serverAddress = null;
        if (local) {
            serverAddress = InetAddress.getLoopbackAddress();
            System.setProperty("java.rmi.server.hostname", serverAddress.getHostAddress());
        }
        env.putAll(JMXServerUtils.configureJmxSocketFactories(serverAddress, local));
        JmxRegistry registry = new JmxRegistry(port, (RMIClientSocketFactory)env.get("jmx.remote.rmi.client.socket.factory"), (RMIServerSocketFactory)env.get("jmx.remote.rmi.server.socket.factory"), "jmxrmi");
        env.putAll(JMXServerUtils.configureJmxAuthentication());
        MBeanServerForwarder authzProxy = JMXServerUtils.configureJmxAuthorization(env);
        env.put("jmx.remote.x.daemon", "true");
        int rmiPort = Integer.getInteger("com.sun.management.jmxremote.rmi.port", 0);
        RMIJRMPServerImpl server = new RMIJRMPServerImpl(rmiPort, (RMIClientSocketFactory)env.get("jmx.remote.rmi.client.socket.factory"), (RMIServerSocketFactory)env.get("jmx.remote.rmi.server.socket.factory"), env);
        JMXServiceURL serviceURL = new JMXServiceURL("rmi", null, rmiPort);
        RMIConnectorServer jmxServer = new RMIConnectorServer(serviceURL, env, server, ManagementFactory.getPlatformMBeanServer());
        if (authzProxy != null) {
            jmxServer.setMBeanServerForwarder(authzProxy);
        }
        jmxServer.start();
        registry.setRemoteServerStub(server.toStub());
        JMXServerUtils.logJmxServiceUrl(serverAddress, port);
        return jmxServer;
    }

    private static Map<String, Object> configureJmxAuthentication() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (!Boolean.getBoolean("com.sun.management.jmxremote.authenticate")) {
            return env;
        }
        String configEntry = System.getProperty("cassandra.jmx.remote.login.config");
        if (configEntry != null) {
            env.put("jmx.remote.authenticator", new AuthenticationProxy(configEntry));
        } else {
            String passwordFile = System.getProperty("com.sun.management.jmxremote.password.file");
            if (passwordFile != null) {
                env.put("jmx.remote.x.password.file", passwordFile);
            }
            env.put("jmx.remote.authenticator", new JMXPluggableAuthenticatorWrapper(env));
        }
        return env;
    }

    private static MBeanServerForwarder configureJmxAuthorization(Map<String, Object> env) {
        String authzProxyClass = System.getProperty("cassandra.jmx.authorizer");
        if (authzProxyClass != null) {
            InvocationHandler handler = (InvocationHandler)FBUtilities.construct(authzProxyClass, "JMX authz proxy");
            Class[] interfaces = new Class[]{MBeanServerForwarder.class};
            Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, handler);
            return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
        }
        String accessFile = System.getProperty("com.sun.management.jmxremote.access.file");
        if (accessFile != null) {
            env.put("jmx.remote.x.access.file", accessFile);
        }
        return null;
    }

    private static Map<String, Object> configureJmxSocketFactories(InetAddress serverAddress, boolean localOnly) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (Boolean.getBoolean("com.sun.management.jmxremote.ssl")) {
            boolean requireClientAuth = Boolean.getBoolean("com.sun.management.jmxremote.ssl.need.client.auth");
            String[] protocols = null;
            String protocolList = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
            if (protocolList != null) {
                System.setProperty("javax.rmi.ssl.client.enabledProtocols", protocolList);
                protocols = StringUtils.split((String)protocolList, (char)',');
            }
            String[] ciphers = null;
            String cipherList = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
            if (cipherList != null) {
                System.setProperty("javax.rmi.ssl.client.enabledCipherSuites", cipherList);
                ciphers = StringUtils.split((String)cipherList, (char)',');
            }
            SslRMIClientSocketFactory clientFactory = new SslRMIClientSocketFactory();
            SslRMIServerSocketFactory serverFactory = new SslRMIServerSocketFactory(ciphers, protocols, requireClientAuth);
            env.put("jmx.remote.rmi.server.socket.factory", serverFactory);
            env.put("jmx.remote.rmi.client.socket.factory", clientFactory);
            env.put("com.sun.jndi.rmi.factory.socket", clientFactory);
            JMXServerUtils.logJmxSslConfig(serverFactory);
        } else if (localOnly) {
            env.put("jmx.remote.rmi.server.socket.factory", new RMIServerSocketFactoryImpl(serverAddress));
        }
        return env;
    }

    private static void logJmxServiceUrl(InetAddress serverAddress, int port) {
        String urlTemplate = "service:jmx:rmi://%1$s/jndi/rmi://%1$s:%2$d/jmxrmi";
        String hostName = serverAddress == null ? (FBUtilities.getBroadcastAddress() instanceof Inet6Address ? "[::]" : "0.0.0.0") : (serverAddress instanceof Inet6Address ? '[' + serverAddress.getHostAddress() + ']' : serverAddress.getHostAddress());
        String url = String.format(urlTemplate, hostName, port);
        logger.info("Configured JMX server at: {}", (Object)url);
    }

    private static void logJmxSslConfig(SslRMIServerSocketFactory serverFactory) {
        logger.debug("JMX SSL configuration. { protocols: [{}], cipher_suites: [{}], require_client_auth: {} }", new Object[]{serverFactory.getEnabledProtocols() == null ? "'JVM defaults'" : Arrays.stream(serverFactory.getEnabledProtocols()).collect(Collectors.joining("','", "'", "'")), serverFactory.getEnabledCipherSuites() == null ? "'JVM defaults'" : Arrays.stream(serverFactory.getEnabledCipherSuites()).collect(Collectors.joining("','", "'", "'")), serverFactory.getNeedClientAuth()});
    }

    private static class JmxRegistry
    extends RegistryImpl {
        private final String lookupName;
        private Remote remoteServerStub;

        JmxRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, String lookupName) throws RemoteException {
            super(port, csf, ssf);
            this.lookupName = lookupName;
        }

        @Override
        public Remote lookup(String s) throws RemoteException, NotBoundException {
            return this.lookupName.equals(s) ? this.remoteServerStub : null;
        }

        @Override
        public void bind(String s, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        }

        @Override
        public void unbind(String s) throws RemoteException, NotBoundException, AccessException {
        }

        @Override
        public void rebind(String s, Remote remote) throws RemoteException, AccessException {
        }

        @Override
        public String[] list() throws RemoteException {
            return new String[]{this.lookupName};
        }

        public void setRemoteServerStub(Remote remoteServerStub) {
            this.remoteServerStub = remoteServerStub;
        }
    }

    private static class JMXPluggableAuthenticatorWrapper
    implements JMXAuthenticator {
        final Map<?, ?> env;

        private JMXPluggableAuthenticatorWrapper(Map<?, ?> env) {
            this.env = ImmutableMap.copyOf(env);
        }

        @Override
        public Subject authenticate(Object credentials) {
            JMXPluggableAuthenticator authenticator = new JMXPluggableAuthenticator(this.env);
            return authenticator.authenticate(credentials);
        }
    }
}

