/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.KeyspaceAttributes;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.FBUtilities;

public final class AlterKeyspaceStatement
extends AlterSchemaStatement {
    private static final boolean allow_alter_rf_during_range_movement = Boolean.getBoolean("cassandra.allow_alter_rf_during_range_movement");
    private static final boolean allow_unsafe_transient_changes = Boolean.getBoolean("cassandra.allow_unsafe_transient_changes");
    private final HashSet<String> clientWarnings = new HashSet();
    private final KeyspaceAttributes attrs;

    public AlterKeyspaceStatement(String keyspaceName, KeyspaceAttributes attrs) {
        super(keyspaceName);
        this.attrs = attrs;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        if (ClientWarn.instance.get() == null) {
            ClientWarn.instance.captureWarnings();
        }
        int previousNumWarnings = ClientWarn.instance.numWarnings();
        this.attrs.validate();
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw AlterKeyspaceStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        KeyspaceMetadata newKeyspace = keyspace.withSwapped(this.attrs.asAlteredKeyspaceParams(keyspace.params));
        if (newKeyspace.params.replication.klass.equals(LocalStrategy.class)) {
            throw AlterKeyspaceStatement.ire("Unable to use given strategy class: LocalStrategy is reserved for internal use.", new Object[0]);
        }
        newKeyspace.params.validate(this.keyspaceName);
        this.validateNoRangeMovements();
        this.validateTransientReplication(keyspace.createReplicationStrategy(), newKeyspace.createReplicationStrategy());
        Keyspaces res = schema.withAddedOrUpdated(newKeyspace);
        int newNumWarnings = ClientWarn.instance.numWarnings();
        if (newNumWarnings > previousNumWarnings) {
            this.clientWarnings.addAll(ClientWarn.instance.getWarnings().subList(previousNumWarnings, newNumWarnings));
        }
        return res;
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, this.keyspaceName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureKeyspacePermission(this.keyspaceName, Permission.ALTER);
    }

    @Override
    Set<String> clientWarnings(Keyspaces.KeyspacesDiff diff) {
        if (diff.isEmpty()) {
            return this.clientWarnings;
        }
        KeyspaceMetadata.KeyspaceDiff keyspaceDiff = (KeyspaceMetadata.KeyspaceDiff)diff.altered.get(0);
        AbstractReplicationStrategy before = keyspaceDiff.before.createReplicationStrategy();
        AbstractReplicationStrategy after = keyspaceDiff.after.createReplicationStrategy();
        if (before.getReplicationFactor().fullReplicas < after.getReplicationFactor().fullReplicas) {
            this.clientWarnings.add("When increasing replication factor you need to run a full (-full) repair to distribute the data.");
        }
        return this.clientWarnings;
    }

    private void validateNoRangeMovements() {
        if (allow_alter_rf_during_range_movement) {
            return;
        }
        Stream<InetAddressAndPort> unreachableNotAdministrativelyInactive = Gossiper.instance.getUnreachableMembers().stream().filter(endpoint -> !FBUtilities.getBroadcastAddressAndPort().equals(endpoint) && !Gossiper.instance.isAdministrativelyInactiveState((InetAddressAndPort)endpoint));
        Stream<InetAddressAndPort> endpoints = Stream.concat(Gossiper.instance.getLiveMembers().stream(), unreachableNotAdministrativelyInactive);
        List notNormalEndpoints = endpoints.filter(endpoint -> !FBUtilities.getBroadcastAddressAndPort().equals(endpoint) && !Gossiper.instance.getEndpointStateForEndpoint((InetAddressAndPort)endpoint).isNormalState()).collect(Collectors.toList());
        if (!notNormalEndpoints.isEmpty()) {
            throw new ConfigurationException("Cannot alter RF while some endpoints are not in normal state (no range movements): " + notNormalEndpoints);
        }
    }

    private void validateTransientReplication(AbstractReplicationStrategy oldStrategy, AbstractReplicationStrategy newStrategy) {
        boolean numReplicasChanged;
        if (allow_unsafe_transient_changes) {
            return;
        }
        ReplicationFactor oldRF = oldStrategy.getReplicationFactor();
        ReplicationFactor newRF = newStrategy.getReplicationFactor();
        int oldTrans = oldRF.transientReplicas();
        int oldFull = oldRF.fullReplicas;
        int newTrans = newRF.transientReplicas();
        int newFull = newRF.fullReplicas;
        if (newTrans > 0) {
            if (DatabaseDescriptor.getNumTokens() > 1) {
                throw new ConfigurationException(String.format("Transient replication is not supported with vnodes yet", new Object[0]));
            }
            Keyspace ks = Keyspace.open(this.keyspaceName);
            for (ColumnFamilyStore cfs : ks.getColumnFamilyStores()) {
                if (cfs.viewManager.hasViews()) {
                    throw new ConfigurationException("Cannot use transient replication on keyspaces using materialized views");
                }
                if (!cfs.indexManager.hasIndexes()) continue;
                throw new ConfigurationException("Cannot use transient replication on keyspaces using secondary indexes");
            }
        }
        if (oldFull > newFull && oldTrans > 0) {
            throw new ConfigurationException("Can't add full replicas if there are any transient replicas. You must first remove all transient replicas, then change the # of full replicas, then add back the transient replicas");
        }
        boolean bl = numReplicasChanged = oldTrans + oldFull != newTrans + newFull;
        if (numReplicasChanged && newTrans > oldTrans && newTrans != oldTrans + 1) {
            throw new ConfigurationException("Can only safely increase number of transients one at a time with incremental repair run in between each time");
        }
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_KEYSPACE, this.keyspaceName);
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getSimpleName(), this.keyspaceName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final String keyspaceName;
        private final KeyspaceAttributes attrs;

        public Raw(String keyspaceName, KeyspaceAttributes attrs) {
            this.keyspaceName = keyspaceName;
            this.attrs = attrs;
        }

        @Override
        public AlterKeyspaceStatement prepare(ClientState state) {
            return new AlterKeyspaceStatement(this.keyspaceName, this.attrs);
        }
    }
}

