/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.consistent.ConsistentSession;
import org.apache.cassandra.repair.consistent.CoordinatorSession;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.FinalizePromise;
import org.apache.cassandra.repair.messages.PrepareConsistentResponse;
import org.apache.cassandra.service.ActiveRepairService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorSessions {
    private final Map<UUID, CoordinatorSession> sessions = new HashMap<UUID, CoordinatorSession>();
    private static final Logger logger = LoggerFactory.getLogger(CoordinatorSessions.class);

    protected CoordinatorSession buildSession(CoordinatorSession.Builder builder) {
        return new CoordinatorSession(builder);
    }

    public synchronized CoordinatorSession registerSession(UUID sessionId, Set<InetAddressAndPort> participants, boolean isForced) {
        ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(sessionId);
        Preconditions.checkArgument((!this.sessions.containsKey(sessionId) ? 1 : 0) != 0, (String)"A coordinator already exists for session %s", (Object)sessionId);
        Preconditions.checkArgument((!isForced || prs.repairedAt == 0L ? 1 : 0) != 0, (Object)"cannot promote data for forced incremental repairs");
        CoordinatorSession.Builder builder = CoordinatorSession.builder();
        builder.withState(ConsistentSession.State.PREPARING);
        builder.withSessionID(sessionId);
        builder.withCoordinator(prs.coordinator);
        builder.withTableIds(prs.getTableIds());
        builder.withRepairedAt(prs.repairedAt);
        builder.withRanges(prs.getRanges());
        builder.withParticipants(participants);
        builder.withListener(this::onSessionStateUpdate);
        CoordinatorSession session = this.buildSession(builder);
        this.sessions.put(session.sessionID, session);
        return session;
    }

    public synchronized CoordinatorSession getSession(UUID sessionId) {
        return this.sessions.get(sessionId);
    }

    public synchronized void onSessionStateUpdate(CoordinatorSession session) {
        if (session.isCompleted()) {
            logger.info("Removing completed session {} with state {}", (Object)session.sessionID, (Object)session.getState());
            this.sessions.remove(session.sessionID);
        }
    }

    public void handlePrepareResponse(PrepareConsistentResponse msg) {
        CoordinatorSession session = this.getSession(msg.parentSession);
        if (session != null) {
            session.handlePrepareResponse(msg.participant, msg.success);
        }
    }

    public void handleFinalizePromiseMessage(FinalizePromise msg) {
        CoordinatorSession session = this.getSession(msg.sessionID);
        if (session != null) {
            session.handleFinalizePromise(msg.participant, msg.promised);
        }
    }

    public void handleFailSessionMessage(FailSession msg) {
        CoordinatorSession session = this.getSession(msg.sessionID);
        if (session != null) {
            session.fail();
        }
    }
}

