/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.guardrails.GuardrailsConfig;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.disk.usage.DiskUsageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuardrailsOptions
implements GuardrailsConfig {
    private static final Logger logger = LoggerFactory.getLogger(GuardrailsOptions.class);
    private final Config config;

    public GuardrailsOptions(Config config) {
        this.config = config;
        GuardrailsOptions.validateMaxIntThreshold(config.keyspaces_warn_threshold, config.keyspaces_fail_threshold, "keyspaces");
        GuardrailsOptions.validateMaxIntThreshold(config.tables_warn_threshold, config.tables_fail_threshold, "tables");
        GuardrailsOptions.validateMaxIntThreshold(config.columns_per_table_warn_threshold, config.columns_per_table_fail_threshold, "columns_per_table");
        GuardrailsOptions.validateMaxIntThreshold(config.secondary_indexes_per_table_warn_threshold, config.secondary_indexes_per_table_fail_threshold, "secondary_indexes_per_table");
        GuardrailsOptions.validateMaxIntThreshold(config.materialized_views_per_table_warn_threshold, config.materialized_views_per_table_fail_threshold, "materialized_views_per_table");
        config.table_properties_warned = GuardrailsOptions.validateTableProperties(config.table_properties_warned, "table_properties_warned");
        config.table_properties_ignored = GuardrailsOptions.validateTableProperties(config.table_properties_ignored, "table_properties_ignored");
        config.table_properties_disallowed = GuardrailsOptions.validateTableProperties(config.table_properties_disallowed, "table_properties_disallowed");
        GuardrailsOptions.validateMaxIntThreshold(config.page_size_warn_threshold, config.page_size_fail_threshold, "page_size");
        GuardrailsOptions.validateMaxIntThreshold(config.partition_keys_in_select_warn_threshold, config.partition_keys_in_select_fail_threshold, "partition_keys_in_select");
        GuardrailsOptions.validateMaxIntThreshold(config.in_select_cartesian_product_warn_threshold, config.in_select_cartesian_product_fail_threshold, "in_select_cartesian_product");
        config.read_consistency_levels_warned = GuardrailsOptions.validateConsistencyLevels(config.read_consistency_levels_warned, "read_consistency_levels_warned");
        config.read_consistency_levels_disallowed = GuardrailsOptions.validateConsistencyLevels(config.read_consistency_levels_disallowed, "read_consistency_levels_disallowed");
        config.write_consistency_levels_warned = GuardrailsOptions.validateConsistencyLevels(config.write_consistency_levels_warned, "write_consistency_levels_warned");
        config.write_consistency_levels_disallowed = GuardrailsOptions.validateConsistencyLevels(config.write_consistency_levels_disallowed, "write_consistency_levels_disallowed");
        GuardrailsOptions.validateSizeThreshold(config.collection_size_warn_threshold, config.collection_size_fail_threshold, false, "collection_size");
        GuardrailsOptions.validateMaxIntThreshold(config.items_per_collection_warn_threshold, config.items_per_collection_fail_threshold, "items_per_collection");
        GuardrailsOptions.validateMaxIntThreshold(config.fields_per_udt_warn_threshold, config.fields_per_udt_fail_threshold, "fields_per_udt");
        GuardrailsOptions.validatePercentageThreshold(config.data_disk_usage_percentage_warn_threshold, config.data_disk_usage_percentage_fail_threshold, "data_disk_usage_percentage");
        GuardrailsOptions.validateDataDiskUsageMaxDiskSize(config.data_disk_usage_max_disk_size);
        GuardrailsOptions.validateMinRFThreshold(config.minimum_replication_factor_warn_threshold, config.minimum_replication_factor_fail_threshold, "minimum_replication_factor");
    }

    @Override
    public int getKeyspacesWarnThreshold() {
        return this.config.keyspaces_warn_threshold;
    }

    @Override
    public int getKeyspacesFailThreshold() {
        return this.config.keyspaces_fail_threshold;
    }

    public void setKeyspacesThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "keyspaces");
        GuardrailsOptions.updatePropertyWithLogging("keyspaces_warn_threshold", warn, () -> this.config.keyspaces_warn_threshold, x -> {
            this.config.keyspaces_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("keyspaces_fail_threshold", fail, () -> this.config.keyspaces_fail_threshold, x -> {
            this.config.keyspaces_fail_threshold = x;
        });
    }

    @Override
    public int getTablesWarnThreshold() {
        return this.config.tables_warn_threshold;
    }

    @Override
    public int getTablesFailThreshold() {
        return this.config.tables_fail_threshold;
    }

    public void setTablesThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "tables");
        GuardrailsOptions.updatePropertyWithLogging("tables_warn_threshold", warn, () -> this.config.tables_warn_threshold, x -> {
            this.config.tables_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("tables_fail_threshold", fail, () -> this.config.tables_fail_threshold, x -> {
            this.config.tables_fail_threshold = x;
        });
    }

    @Override
    public int getColumnsPerTableWarnThreshold() {
        return this.config.columns_per_table_warn_threshold;
    }

    @Override
    public int getColumnsPerTableFailThreshold() {
        return this.config.columns_per_table_fail_threshold;
    }

    public void setColumnsPerTableThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "columns_per_table");
        GuardrailsOptions.updatePropertyWithLogging("columns_per_table_warn_threshold", warn, () -> this.config.columns_per_table_warn_threshold, x -> {
            this.config.columns_per_table_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("columns_per_table_fail_threshold", fail, () -> this.config.columns_per_table_fail_threshold, x -> {
            this.config.columns_per_table_fail_threshold = x;
        });
    }

    @Override
    public int getSecondaryIndexesPerTableWarnThreshold() {
        return this.config.secondary_indexes_per_table_warn_threshold;
    }

    @Override
    public int getSecondaryIndexesPerTableFailThreshold() {
        return this.config.secondary_indexes_per_table_fail_threshold;
    }

    public void setSecondaryIndexesPerTableThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "secondary_indexes_per_table");
        GuardrailsOptions.updatePropertyWithLogging("secondary_indexes_per_table_warn_threshold", warn, () -> this.config.secondary_indexes_per_table_warn_threshold, x -> {
            this.config.secondary_indexes_per_table_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("secondary_indexes_per_table_fail_threshold", fail, () -> this.config.secondary_indexes_per_table_fail_threshold, x -> {
            this.config.secondary_indexes_per_table_fail_threshold = x;
        });
    }

    @Override
    public int getMaterializedViewsPerTableWarnThreshold() {
        return this.config.materialized_views_per_table_warn_threshold;
    }

    @Override
    public int getPartitionKeysInSelectWarnThreshold() {
        return this.config.partition_keys_in_select_warn_threshold;
    }

    @Override
    public int getPartitionKeysInSelectFailThreshold() {
        return this.config.partition_keys_in_select_fail_threshold;
    }

    public void setPartitionKeysInSelectThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "partition_keys_in_select");
        GuardrailsOptions.updatePropertyWithLogging("partition_keys_in_select_warn_threshold", warn, () -> this.config.partition_keys_in_select_warn_threshold, x -> {
            this.config.partition_keys_in_select_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("partition_keys_in_select_fail_threshold", fail, () -> this.config.partition_keys_in_select_fail_threshold, x -> {
            this.config.partition_keys_in_select_fail_threshold = x;
        });
    }

    @Override
    public int getMaterializedViewsPerTableFailThreshold() {
        return this.config.materialized_views_per_table_fail_threshold;
    }

    public void setMaterializedViewsPerTableThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "materialized_views_per_table");
        GuardrailsOptions.updatePropertyWithLogging("materialized_views_per_table_warn_threshold", warn, () -> this.config.materialized_views_per_table_warn_threshold, x -> {
            this.config.materialized_views_per_table_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("materialized_views_per_table_fail_threshold", fail, () -> this.config.materialized_views_per_table_fail_threshold, x -> {
            this.config.materialized_views_per_table_fail_threshold = x;
        });
    }

    @Override
    public int getPageSizeWarnThreshold() {
        return this.config.page_size_warn_threshold;
    }

    @Override
    public int getPageSizeFailThreshold() {
        return this.config.page_size_fail_threshold;
    }

    public void setPageSizeThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "page_size");
        GuardrailsOptions.updatePropertyWithLogging("page_size_warn_threshold", warn, () -> this.config.page_size_warn_threshold, x -> {
            this.config.page_size_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("page_size_fail_threshold", fail, () -> this.config.page_size_fail_threshold, x -> {
            this.config.page_size_fail_threshold = x;
        });
    }

    @Override
    public Set<String> getTablePropertiesWarned() {
        return this.config.table_properties_warned;
    }

    public void setTablePropertiesWarned(Set<String> properties) {
        GuardrailsOptions.updatePropertyWithLogging("table_properties_warned", GuardrailsOptions.validateTableProperties(properties, "table_properties_warned"), () -> this.config.table_properties_warned, x -> {
            this.config.table_properties_warned = x;
        });
    }

    @Override
    public Set<String> getTablePropertiesIgnored() {
        return this.config.table_properties_ignored;
    }

    public void setTablePropertiesIgnored(Set<String> properties) {
        GuardrailsOptions.updatePropertyWithLogging("table_properties_ignored", GuardrailsOptions.validateTableProperties(properties, "table_properties_ignored"), () -> this.config.table_properties_ignored, x -> {
            this.config.table_properties_ignored = x;
        });
    }

    @Override
    public Set<String> getTablePropertiesDisallowed() {
        return this.config.table_properties_disallowed;
    }

    public void setTablePropertiesDisallowed(Set<String> properties) {
        GuardrailsOptions.updatePropertyWithLogging("table_properties_disallowed", GuardrailsOptions.validateTableProperties(properties, "table_properties_disallowed"), () -> this.config.table_properties_disallowed, x -> {
            this.config.table_properties_disallowed = x;
        });
    }

    @Override
    public boolean getUserTimestampsEnabled() {
        return this.config.user_timestamps_enabled;
    }

    public void setUserTimestampsEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("user_timestamps_enabled", enabled, () -> this.config.user_timestamps_enabled, x -> {
            this.config.user_timestamps_enabled = x;
        });
    }

    @Override
    public boolean getGroupByEnabled() {
        return this.config.group_by_enabled;
    }

    public void setGroupByEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("group_by_enabled", enabled, () -> this.config.group_by_enabled, x -> {
            this.config.group_by_enabled = x;
        });
    }

    @Override
    public boolean getDropTruncateTableEnabled() {
        return this.config.drop_truncate_table_enabled;
    }

    public void setDropTruncateTableEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("drop_truncate_table_enabled", enabled, () -> this.config.drop_truncate_table_enabled, x -> {
            this.config.drop_truncate_table_enabled = x;
        });
    }

    @Override
    public boolean getSecondaryIndexesEnabled() {
        return this.config.secondary_indexes_enabled;
    }

    public void setSecondaryIndexesEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("secondary_indexes_enabled", enabled, () -> this.config.secondary_indexes_enabled, x -> {
            this.config.secondary_indexes_enabled = x;
        });
    }

    @Override
    public boolean getUncompressedTablesEnabled() {
        return this.config.uncompressed_tables_enabled;
    }

    public void setUncompressedTablesEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("uncompressed_tables_enabled", enabled, () -> this.config.uncompressed_tables_enabled, x -> {
            this.config.uncompressed_tables_enabled = x;
        });
    }

    @Override
    public boolean getCompactTablesEnabled() {
        return this.config.compact_tables_enabled;
    }

    public void setCompactTablesEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("compact_tables_enabled", enabled, () -> this.config.compact_tables_enabled, x -> {
            this.config.compact_tables_enabled = x;
        });
    }

    @Override
    public boolean getReadBeforeWriteListOperationsEnabled() {
        return this.config.read_before_write_list_operations_enabled;
    }

    public void setReadBeforeWriteListOperationsEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("read_before_write_list_operations_enabled", enabled, () -> this.config.read_before_write_list_operations_enabled, x -> {
            this.config.read_before_write_list_operations_enabled = x;
        });
    }

    @Override
    public boolean getAllowFilteringEnabled() {
        return this.config.allow_filtering_enabled;
    }

    public void setAllowFilteringEnabled(boolean enabled) {
        GuardrailsOptions.updatePropertyWithLogging("allow_filtering_enabled", enabled, () -> this.config.allow_filtering_enabled, x -> {
            this.config.allow_filtering_enabled = x;
        });
    }

    @Override
    public int getInSelectCartesianProductWarnThreshold() {
        return this.config.in_select_cartesian_product_warn_threshold;
    }

    @Override
    public int getInSelectCartesianProductFailThreshold() {
        return this.config.in_select_cartesian_product_fail_threshold;
    }

    public void setInSelectCartesianProductThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "in_select_cartesian_product");
        GuardrailsOptions.updatePropertyWithLogging("in_select_cartesian_product_warn_threshold", warn, () -> this.config.in_select_cartesian_product_warn_threshold, x -> {
            this.config.in_select_cartesian_product_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("in_select_cartesian_product_fail_threshold", fail, () -> this.config.in_select_cartesian_product_fail_threshold, x -> {
            this.config.in_select_cartesian_product_fail_threshold = x;
        });
    }

    @Override
    public Set<ConsistencyLevel> getReadConsistencyLevelsWarned() {
        return this.config.read_consistency_levels_warned;
    }

    public void setReadConsistencyLevelsWarned(Set<ConsistencyLevel> consistencyLevels) {
        GuardrailsOptions.updatePropertyWithLogging("read_consistency_levels_warned", GuardrailsOptions.validateConsistencyLevels(consistencyLevels, "read_consistency_levels_warned"), () -> this.config.read_consistency_levels_warned, x -> {
            this.config.read_consistency_levels_warned = x;
        });
    }

    @Override
    public Set<ConsistencyLevel> getReadConsistencyLevelsDisallowed() {
        return this.config.read_consistency_levels_disallowed;
    }

    public void setReadConsistencyLevelsDisallowed(Set<ConsistencyLevel> consistencyLevels) {
        GuardrailsOptions.updatePropertyWithLogging("read_consistency_levels_disallowed", GuardrailsOptions.validateConsistencyLevels(consistencyLevels, "read_consistency_levels_disallowed"), () -> this.config.read_consistency_levels_disallowed, x -> {
            this.config.read_consistency_levels_disallowed = x;
        });
    }

    @Override
    public Set<ConsistencyLevel> getWriteConsistencyLevelsWarned() {
        return this.config.write_consistency_levels_warned;
    }

    public void setWriteConsistencyLevelsWarned(Set<ConsistencyLevel> consistencyLevels) {
        GuardrailsOptions.updatePropertyWithLogging("write_consistency_levels_warned", GuardrailsOptions.validateConsistencyLevels(consistencyLevels, "write_consistency_levels_warned"), () -> this.config.write_consistency_levels_warned, x -> {
            this.config.write_consistency_levels_warned = x;
        });
    }

    @Override
    public Set<ConsistencyLevel> getWriteConsistencyLevelsDisallowed() {
        return this.config.write_consistency_levels_disallowed;
    }

    public void setWriteConsistencyLevelsDisallowed(Set<ConsistencyLevel> consistencyLevels) {
        GuardrailsOptions.updatePropertyWithLogging("write_consistency_levels_disallowed", GuardrailsOptions.validateConsistencyLevels(consistencyLevels, "write_consistency_levels_disallowed"), () -> this.config.write_consistency_levels_disallowed, x -> {
            this.config.write_consistency_levels_disallowed = x;
        });
    }

    @Override
    @Nullable
    public DataStorageSpec.LongBytesBound getCollectionSizeWarnThreshold() {
        return this.config.collection_size_warn_threshold;
    }

    @Override
    @Nullable
    public DataStorageSpec.LongBytesBound getCollectionSizeFailThreshold() {
        return this.config.collection_size_fail_threshold;
    }

    public void setCollectionSizeThreshold(@Nullable DataStorageSpec.LongBytesBound warn, @Nullable DataStorageSpec.LongBytesBound fail) {
        GuardrailsOptions.validateSizeThreshold(warn, fail, false, "collection_size");
        GuardrailsOptions.updatePropertyWithLogging("collection_size_warn_threshold", warn, () -> this.config.collection_size_warn_threshold, x -> {
            this.config.collection_size_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("collection_size_fail_threshold", fail, () -> this.config.collection_size_fail_threshold, x -> {
            this.config.collection_size_fail_threshold = x;
        });
    }

    @Override
    public int getItemsPerCollectionWarnThreshold() {
        return this.config.items_per_collection_warn_threshold;
    }

    @Override
    public int getItemsPerCollectionFailThreshold() {
        return this.config.items_per_collection_fail_threshold;
    }

    public void setItemsPerCollectionThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "items_per_collection");
        GuardrailsOptions.updatePropertyWithLogging("items_per_collection_warn_threshold", warn, () -> this.config.items_per_collection_warn_threshold, x -> {
            this.config.items_per_collection_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("items_per_collection_fail_threshold", fail, () -> this.config.items_per_collection_fail_threshold, x -> {
            this.config.items_per_collection_fail_threshold = x;
        });
    }

    @Override
    public int getFieldsPerUDTWarnThreshold() {
        return this.config.fields_per_udt_warn_threshold;
    }

    @Override
    public int getFieldsPerUDTFailThreshold() {
        return this.config.fields_per_udt_fail_threshold;
    }

    public void setFieldsPerUDTThreshold(int warn, int fail) {
        GuardrailsOptions.validateMaxIntThreshold(warn, fail, "fields_per_udt");
        GuardrailsOptions.updatePropertyWithLogging("fields_per_udt_warn_threshold", warn, () -> this.config.fields_per_udt_warn_threshold, x -> {
            this.config.fields_per_udt_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("fields_per_udt_fail_threshold", fail, () -> this.config.fields_per_udt_fail_threshold, x -> {
            this.config.fields_per_udt_fail_threshold = x;
        });
    }

    @Override
    public int getDataDiskUsagePercentageWarnThreshold() {
        return this.config.data_disk_usage_percentage_warn_threshold;
    }

    @Override
    public int getDataDiskUsagePercentageFailThreshold() {
        return this.config.data_disk_usage_percentage_fail_threshold;
    }

    public void setDataDiskUsagePercentageThreshold(int warn, int fail) {
        GuardrailsOptions.validatePercentageThreshold(warn, fail, "data_disk_usage_percentage");
        GuardrailsOptions.updatePropertyWithLogging("data_disk_usage_percentage_warn_threshold", warn, () -> this.config.data_disk_usage_percentage_warn_threshold, x -> {
            this.config.data_disk_usage_percentage_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("data_disk_usage_percentage_fail_threshold", fail, () -> this.config.data_disk_usage_percentage_fail_threshold, x -> {
            this.config.data_disk_usage_percentage_fail_threshold = x;
        });
    }

    @Override
    public DataStorageSpec.LongBytesBound getDataDiskUsageMaxDiskSize() {
        return this.config.data_disk_usage_max_disk_size;
    }

    public void setDataDiskUsageMaxDiskSize(@Nullable DataStorageSpec.LongBytesBound diskSize) {
        GuardrailsOptions.validateDataDiskUsageMaxDiskSize(diskSize);
        GuardrailsOptions.updatePropertyWithLogging("data_disk_usage_max_disk_size", diskSize, () -> this.config.data_disk_usage_max_disk_size, x -> {
            this.config.data_disk_usage_max_disk_size = x;
        });
    }

    @Override
    public int getMinimumReplicationFactorWarnThreshold() {
        return this.config.minimum_replication_factor_warn_threshold;
    }

    @Override
    public int getMinimumReplicationFactorFailThreshold() {
        return this.config.minimum_replication_factor_fail_threshold;
    }

    public void setMinimumReplicationFactorThreshold(int warn, int fail) {
        GuardrailsOptions.validateMinRFThreshold(warn, fail, "minimum_replication_factor");
        GuardrailsOptions.updatePropertyWithLogging("minimum_replication_factor_warn_threshold", warn, () -> this.config.minimum_replication_factor_warn_threshold, x -> {
            this.config.minimum_replication_factor_warn_threshold = x;
        });
        GuardrailsOptions.updatePropertyWithLogging("minimum_replication_factor_fail_threshold", fail, () -> this.config.minimum_replication_factor_fail_threshold, x -> {
            this.config.minimum_replication_factor_fail_threshold = x;
        });
    }

    private static <T> void updatePropertyWithLogging(String propertyName, T newValue, Supplier<T> getter, Consumer<T> setter) {
        T oldValue = getter.get();
        if (newValue == null || !newValue.equals(oldValue)) {
            setter.accept(newValue);
            logger.info("Updated {} from {} to {}", new Object[]{propertyName, oldValue, newValue});
        }
    }

    private static void validatePositiveNumeric(long value, long maxValue, String name) {
        if (value == -1L) {
            return;
        }
        if (value > maxValue) {
            throw new IllegalArgumentException(String.format("Invalid value %d for %s: maximum allowed value is %d", value, name, maxValue));
        }
        if (value == 0L) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: 0 is not allowed; if attempting to disable use -1", name));
        }
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid value %d for %s: negative values are not allowed, outside of -1 which disables the guardrail", value, name));
        }
    }

    private static void validatePercentage(long value, String name) {
        GuardrailsOptions.validatePositiveNumeric(value, 100L, name);
    }

    private static void validatePercentageThreshold(int warn, int fail, String name) {
        GuardrailsOptions.validatePercentage(warn, name + "_warn_threshold");
        GuardrailsOptions.validatePercentage(fail, name + "_fail_threshold");
        GuardrailsOptions.validateWarnLowerThanFail(warn, fail, name);
    }

    private static void validateMaxIntThreshold(int warn, int fail, String name) {
        GuardrailsOptions.validatePositiveNumeric(warn, Integer.MAX_VALUE, name + "_warn_threshold");
        GuardrailsOptions.validatePositiveNumeric(fail, Integer.MAX_VALUE, name + "_fail_threshold");
        GuardrailsOptions.validateWarnLowerThanFail(warn, fail, name);
    }

    private static void validateMinIntThreshold(int warn, int fail, String name) {
        GuardrailsOptions.validatePositiveNumeric(warn, Integer.MAX_VALUE, name + "_warn_threshold");
        GuardrailsOptions.validatePositiveNumeric(fail, Integer.MAX_VALUE, name + "_fail_threshold");
        GuardrailsOptions.validateWarnGreaterThanFail(warn, fail, name);
    }

    private static void validateMinRFThreshold(int warn, int fail, String name) {
        GuardrailsOptions.validateMinIntThreshold(warn, fail, name);
        GuardrailsOptions.validateMinRFVersusDefaultRF(fail, name);
    }

    private static void validateWarnLowerThanFail(long warn, long fail, String name) {
        if (warn == -1L || fail == -1L) {
            return;
        }
        if (fail < warn) {
            throw new IllegalArgumentException(String.format("The warn threshold %d for %s_warn_threshold should be lower than the fail threshold %d", warn, name, fail));
        }
    }

    private static void validateWarnGreaterThanFail(long warn, long fail, String name) {
        if (warn == -1L || fail == -1L) {
            return;
        }
        if (fail > warn) {
            throw new IllegalArgumentException(String.format("The warn threshold %d for %s_warn_threshold should be greater than the fail threshold %d", warn, name, fail));
        }
    }

    private static void validateMinRFVersusDefaultRF(int fail, String name) throws IllegalArgumentException {
        if (fail > DatabaseDescriptor.getDefaultKeyspaceRF()) {
            throw new IllegalArgumentException(String.format("%s_fail_threshold to be set (%d) cannot be greater than default_keyspace_rf (%d)", name, fail, DatabaseDescriptor.getDefaultKeyspaceRF()));
        }
    }

    private static void validateSize(DataStorageSpec.LongBytesBound size, boolean allowZero, String name) {
        if (size == null) {
            return;
        }
        if (!allowZero && size.toBytes() == 0L) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: 0 is not allowed; if attempting to disable use an empty value", name));
        }
    }

    private static void validateSizeThreshold(DataStorageSpec.LongBytesBound warn, DataStorageSpec.LongBytesBound fail, boolean allowZero, String name) {
        GuardrailsOptions.validateSize(warn, allowZero, name + "_warn_threshold");
        GuardrailsOptions.validateSize(fail, allowZero, name + "_fail_threshold");
        GuardrailsOptions.validateWarnLowerThanFail(warn, fail, name);
    }

    private static void validateWarnLowerThanFail(DataStorageSpec.LongBytesBound warn, DataStorageSpec.LongBytesBound fail, String name) {
        if (warn == null || fail == null) {
            return;
        }
        if (fail.toBytes() < warn.toBytes()) {
            throw new IllegalArgumentException(String.format("The warn threshold %s for %s_warn_threshold should be lower than the fail threshold %s", warn, name, fail));
        }
    }

    private static Set<String> validateTableProperties(Set<String> properties, String name) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: null is not allowed", name));
        }
        Set<String> lowerCaseProperties = properties.stream().map(String::toLowerCase).collect(Collectors.toSet());
        Sets.SetView diff = Sets.difference(lowerCaseProperties, TableAttributes.allKeywords());
        if (!diff.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: '%s' do not parse as valid table properties", name, diff));
        }
        return lowerCaseProperties;
    }

    private static Set<ConsistencyLevel> validateConsistencyLevels(Set<ConsistencyLevel> consistencyLevels, String name) {
        if (consistencyLevels == null) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: null is not allowed", name));
        }
        return consistencyLevels.isEmpty() ? Collections.emptySet() : Sets.immutableEnumSet(consistencyLevels);
    }

    private static void validateDataDiskUsageMaxDiskSize(DataStorageSpec.LongBytesBound maxDiskSize) {
        if (maxDiskSize == null) {
            return;
        }
        GuardrailsOptions.validateSize(maxDiskSize, false, "data_disk_usage_max_disk_size");
        long diskSize = DiskUsageMonitor.totalDiskSpace();
        if (diskSize < maxDiskSize.toBytes()) {
            throw new IllegalArgumentException(String.format("Invalid value for data_disk_usage_max_disk_size: %s specified, but only %s are actually available on disk", maxDiskSize, FileUtils.stringifyFileSize(diskSize)));
        }
    }
}

