/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Roles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AuthCacheService {
    private static final Logger logger = LoggerFactory.getLogger(AuthCacheService.class);
    public static final AuthCacheService instance = new AuthCacheService();
    private final Set<AuthCache<?, ?>> caches = new HashSet();
    private static final AtomicBoolean cachesRegistered = new AtomicBoolean(false);

    public synchronized void register(AuthCache<?, ?> cache) {
        Preconditions.checkNotNull(cache);
        this.caches.add(cache);
    }

    public synchronized void unregister(AuthCache<?, ?> cache) {
        Preconditions.checkNotNull(cache);
        this.caches.remove(cache);
    }

    public synchronized void warmCaches() {
        logger.info("Initiating bulk load of {} auth cache(s)", (Object)this.caches.size());
        for (AuthCache<?, ?> cache : this.caches) {
            cache.warm();
        }
    }

    @VisibleForTesting
    public static void initializeAndRegisterCaches() {
        if (!cachesRegistered.getAndSet(true)) {
            AuthenticatedUser.init();
            Roles.init();
        }
    }
}

