/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosPrepare;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.tracing.Tracing;

public class PaxosCommitAndPrepare {
    public static final RequestSerializer requestSerializer = new RequestSerializer();
    public static final RequestHandler requestHandler = new RequestHandler();

    static PaxosPrepare commitAndPrepare(Commit.Agreed commit, Paxos.Participants participants, SinglePartitionReadCommand readCommand, boolean isWrite, boolean acceptEarlyReadSuccess) {
        Ballot ballot = Paxos.newBallot(commit.ballot, participants.consistencyForConsensus);
        Request request = new Request(commit, ballot, participants.electorate, readCommand, isWrite);
        PaxosPrepare prepare = new PaxosPrepare(participants, request, acceptEarlyReadSuccess, null);
        Tracing.trace("Committing {}; Preparing {}", (Object)commit.ballot, (Object)ballot);
        Message<Request> message = Message.out(Verb.PAXOS2_COMMIT_AND_PREPARE_REQ, request);
        PaxosPrepare.start(prepare, participants, message, (x$0, x$1) -> RequestHandler.execute(x$0, x$1));
        return prepare;
    }

    public static class RequestHandler
    implements IVerbHandler<Request> {
        @Override
        public void doVerb(Message<Request> message) {
            PaxosPrepare.Response response = RequestHandler.execute((Request)message.payload, message.from());
            if (response == null) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
            } else {
                MessagingService.instance().respond(response, message);
            }
        }

        private static PaxosPrepare.Response execute(Request request, InetAddressAndPort from) {
            Commit.Agreed commit = request.commit;
            if (!Paxos.isInRangeAndShouldProcess(from, commit.update.partitionKey(), commit.update.metadata(), request.read != null)) {
                return null;
            }
            try (PaxosState state = PaxosState.get(commit);){
                state.commit(commit);
                PaxosPrepare.Response response = PaxosPrepare.RequestHandler.execute(request, state);
                return response;
            }
        }
    }

    public static class RequestSerializer
    extends PaxosPrepare.AbstractRequestSerializer<Request, Commit.Agreed> {
        @Override
        Request construct(Commit.Agreed param, Ballot ballot, Paxos.Electorate electorate, SinglePartitionReadCommand read, boolean isWrite) {
            return new Request(param, ballot, electorate, read, isWrite);
        }

        @Override
        Request construct(Commit.Agreed param, Ballot ballot, Paxos.Electorate electorate, DecoratedKey partitionKey, TableMetadata table, boolean isWrite) {
            return new Request(param, ballot, electorate, partitionKey, table, isWrite);
        }

        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            Commit.Agreed.serializer.serialize(request.commit, out, version);
            super.serialize(request, out, version);
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            Commit.Agreed committed = (Commit.Agreed)Commit.Agreed.serializer.deserialize(in, version);
            return (Request)this.deserialize(committed, in, version);
        }

        @Override
        public long serializedSize(Request request, int version) {
            return Commit.Agreed.serializer.serializedSize(request.commit, version) + super.serializedSize(request, version);
        }
    }

    private static class Request
    extends PaxosPrepare.AbstractRequest<Request> {
        final Commit.Agreed commit;

        Request(Commit.Agreed commit, Ballot ballot, Paxos.Electorate electorate, SinglePartitionReadCommand read, boolean isWrite) {
            super(ballot, electorate, read, isWrite);
            this.commit = commit;
        }

        private Request(Commit.Agreed commit, Ballot ballot, Paxos.Electorate electorate, DecoratedKey partitionKey, TableMetadata table, boolean isWrite) {
            super(ballot, electorate, partitionKey, table, isWrite);
            this.commit = commit;
        }

        @Override
        Request withoutRead() {
            return new Request(this.commit, this.ballot, this.electorate, this.partitionKey, this.table, this.isForWrite);
        }

        @Override
        public String toString() {
            return this.commit.toString("CommitAndPrepare(") + ", " + Ballot.toString(this.ballot) + ')';
        }
    }
}

