/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION})
public class ParameterizedClass {
    public static final String CLASS_NAME = "class_name";
    public static final String PARAMETERS = "parameters";
    public String class_name;
    public Map<String, String> parameters;

    public ParameterizedClass() {
    }

    public ParameterizedClass(String class_name) {
        this.class_name = class_name;
        this.parameters = Collections.emptyMap();
    }

    public ParameterizedClass(String class_name, Map<String, String> parameters) {
        this.class_name = class_name;
        this.parameters = parameters;
    }

    public ParameterizedClass(Map<String, ?> p) {
        this((String)p.get(CLASS_NAME), p.containsKey(PARAMETERS) ? (Map)((List)p.get(PARAMETERS)).get(0) : null);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K newInstance(ParameterizedClass parameterizedClass, List<String> searchPackages) {
        Exception last = null;
        if (searchPackages == null || searchPackages.isEmpty()) {
            searchPackages = Collections.singletonList("");
        }
        for (String string : searchPackages) {
            try {
                void var4_4;
                if (!string.isEmpty() && !string.endsWith(".")) {
                    String string2 = string + ".";
                }
                String name = (String)var4_4 + parameterizedClass.class_name;
                Class<?> providerClass = Class.forName(name);
                try {
                    Constructor<?> constructor = providerClass.getConstructor(Map.class);
                    Object instance = constructor.newInstance(parameterizedClass.parameters);
                    return (K)instance;
                }
                catch (Exception constructor) {
                    if (parameterizedClass.parameters != null && !parameterizedClass.parameters.isEmpty()) continue;
                    Constructor<?> constructor2 = providerClass.getConstructor(new Class[0]);
                    Object instance = constructor2.newInstance(new Object[0]);
                    return (K)instance;
                }
            }
            catch (Exception e) {
                last = e;
            }
        }
        throw new ConfigurationException("Unable to create parameterized class " + parameterizedClass.class_name, last);
    }

    public boolean equals(Object that) {
        return that instanceof ParameterizedClass && this.equals((ParameterizedClass)that);
    }

    public boolean equals(ParameterizedClass that) {
        return Objects.equal((Object)this.class_name, (Object)that.class_name) && Objects.equal(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.class_name, this.parameters});
    }

    public String toString() {
        return this.class_name + (this.parameters == null ? "" : this.parameters.toString());
    }
}

