/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.cassandra.utils.memory.HeapCloner;

public abstract class DecoratedKey
implements PartitionPosition,
IFilter.FilterKey {
    public static final Comparator<DecoratedKey> comparator = DecoratedKey::compareTo;
    private final Token token;

    public DecoratedKey(Token token) {
        assert (token != null);
        this.token = token;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DecoratedKey)) {
            return false;
        }
        DecoratedKey other = (DecoratedKey)obj;
        return ByteBufferUtil.compareUnsigned(this.getKey(), other.getKey()) == 0;
    }

    @Override
    public int compareTo(PartitionPosition pos) {
        if (this == pos) {
            return 0;
        }
        if (!(pos instanceof DecoratedKey)) {
            return -pos.compareTo(this);
        }
        DecoratedKey otherKey = (DecoratedKey)pos;
        int cmp = this.getToken().compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(this.getKey(), otherKey.getKey()) : cmp;
    }

    public static int compareTo(IPartitioner partitioner, ByteBuffer key, PartitionPosition position) {
        if (!(position instanceof DecoratedKey)) {
            return -position.compareTo(partitioner.decorateKey(key));
        }
        DecoratedKey otherKey = (DecoratedKey)position;
        int cmp = partitioner.getToken(key).compareTo(otherKey.getToken());
        return cmp == 0 ? ByteBufferUtil.compareUnsigned(key, otherKey.getKey()) : cmp;
    }

    @Override
    public ByteSource asComparableBytes(ByteComparable.Version version) {
        return ByteSource.withTerminatorMaybeLegacy(version, -1, this.token.asComparableBytes(version), this.keyComparableBytes(version));
    }

    @Override
    public ByteComparable asComparableBound(boolean before) {
        return version -> {
            assert (version != ByteComparable.Version.LEGACY) : "Decorated key bounds are not supported by the legacy encoding.";
            return ByteSource.withTerminator(before ? 32 : 96, this.token.asComparableBytes(version), this.keyComparableBytes(version));
        };
    }

    protected ByteSource keyComparableBytes(ByteComparable.Version version) {
        return ByteSource.of(this.getKey(), version);
    }

    @Override
    public IPartitioner getPartitioner() {
        return this.getToken().getPartitioner();
    }

    @Override
    public Token.KeyBound minValue() {
        return this.getPartitioner().getMinimumToken().minKeyBound();
    }

    @Override
    public boolean isMinimum() {
        return false;
    }

    @Override
    public PartitionPosition.Kind kind() {
        return PartitionPosition.Kind.ROW_KEY;
    }

    public String toString() {
        String keystring = this.getKey() == null ? "null" : ByteBufferUtil.bytesToHex(this.getKey());
        return "DecoratedKey(" + this.getToken() + ", " + keystring + ")";
    }

    public String toCQLString(TableMetadata metadata) {
        ImmutableList<ColumnMetadata> columns = metadata.partitionKeyColumns();
        if (columns.size() == 1) {
            return DecoratedKey.toCQLString((ColumnMetadata)columns.get(0), this.getKey());
        }
        ByteBuffer[] values = ((CompositeType)metadata.partitionKeyType).split(this.getKey());
        StringJoiner joiner = new StringJoiner(" AND ");
        for (int i = 0; i < columns.size(); ++i) {
            joiner.add(DecoratedKey.toCQLString((ColumnMetadata)columns.get(i), values[i]));
        }
        return joiner.toString();
    }

    private static String toCQLString(ColumnMetadata metadata, ByteBuffer key) {
        return String.format("%s = %s", metadata.name.toCQLString(), metadata.type.toCQLString(key));
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public abstract ByteBuffer getKey();

    public abstract int getKeyLength();

    public DecoratedKey retainable() {
        return ByteBufferUtil.canMinimize(this.getKey()) ? new BufferDecoratedKey(this.getToken(), HeapCloner.instance.clone(this.getKey())) : this;
    }

    @Override
    public void filterHash(long[] dest) {
        ByteBuffer key = this.getKey();
        MurmurHash.hash3_x64_128(key, key.position(), key.remaining(), 0L, dest);
    }

    static <T extends DecoratedKey> T fromByteComparable(ByteComparable byteComparable, ByteComparable.Version version, IPartitioner partitioner, BiFunction<Token, byte[], T> decoratedKeyFactory) {
        ByteSource.Peekable peekable = ByteSource.peekable(byteComparable.asComparableBytes(version));
        Token token = partitioner.getTokenFactory().fromComparableBytes(ByteSourceInverse.nextComponentSource(peekable), version);
        byte[] keyBytes = ByteSourceInverse.getUnescapedBytes(ByteSourceInverse.nextComponentSource(peekable));
        int terminator = peekable.next();
        assert (terminator == 56) : "Decorated key encoding must end in terminator.";
        return (T)((DecoratedKey)decoratedKeyFactory.apply(token, keyBytes));
    }

    public static byte[] keyFromByteSource(ByteSource.Peekable peekableByteSource, ByteComparable.Version version, IPartitioner partitioner) {
        assert (version != ByteComparable.Version.LEGACY);
        partitioner.getTokenFactory().fromComparableBytes(ByteSourceInverse.nextComponentSource(peekableByteSource), version);
        byte[] keyBytes = ByteSourceInverse.getUnescapedBytes(ByteSourceInverse.nextComponentSource(peekableByteSource));
        int terminator = peekableByteSource.next();
        assert (terminator == 56) : "Decorated key encoding must end in terminator.";
        return keyBytes;
    }
}

