/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.commons.lang3.mutable.Mutable;

public abstract class NumberType<T extends Number>
extends AbstractType<T> {
    protected NumberType(AbstractType.ComparisonType comparisonType) {
        super(comparisonType);
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public abstract ByteBuffer add(Number var1, Number var2);

    public abstract ByteBuffer substract(Number var1, Number var2);

    public abstract ByteBuffer multiply(Number var1, Number var2);

    public abstract ByteBuffer divide(Number var1, Number var2);

    public abstract ByteBuffer mod(Number var1, Number var2);

    public abstract ByteBuffer negate(Number var1);

    public abstract ByteBuffer abs(Number var1);

    public abstract ByteBuffer exp(Number var1);

    public abstract ByteBuffer log(Number var1);

    public abstract ByteBuffer log10(Number var1);

    public abstract ByteBuffer round(Number var1);

    protected static abstract class NumberArgumentDeserializer<M extends Mutable<Number>>
    implements ArgumentDeserializer {
        protected final M wrapper;

        public NumberArgumentDeserializer(M wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Object deserialize(ProtocolVersion protocolVersion, ByteBuffer buffer) {
            if (buffer == null || !buffer.hasRemaining()) {
                return null;
            }
            this.setMutableValue(this.wrapper, buffer);
            return this.wrapper;
        }

        protected abstract void setMutableValue(M var1, ByteBuffer var2);
    }
}

