/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexStatusManager {
    private static final Logger logger = LoggerFactory.getLogger(IndexStatusManager.class);
    public static final IndexStatusManager instance = new IndexStatusManager();
    private final ExecutorPlus statusPropagationExecutor = ExecutorFactory.Global.executorFactory().withJmxInternal().sequential("StatusPropagationExecutor");
    public final Map<InetAddressAndPort, Map<String, Index.Status>> peerIndexStatus = new HashMap<InetAddressAndPort, Map<String, Index.Status>>();

    private IndexStatusManager() {
    }

    public <E extends Endpoints<E>> E filterForQuery(E liveEndpoints, Keyspace keyspace, Index.QueryPlan indexQueryPlan, ConsistencyLevel level) {
        int required;
        int filtered;
        Endpoints queryableEndpoints = (Endpoints)liveEndpoints.filter(replica -> {
            for (Index index : indexQueryPlan.getIndexes()) {
                Index.Status status;
                if (index.isQueryable(status = this.getIndexStatus(replica.endpoint(), keyspace.getName(), index.getIndexMetadata().name))) continue;
                return false;
            }
            return true;
        });
        int initial = liveEndpoints.size();
        if (initial != (filtered = queryableEndpoints.size()) && (required = level.blockFor(keyspace.getReplicationStrategy())) <= initial && required > filtered) {
            HashMap<InetAddressAndPort, RequestFailureReason> failureReasons = new HashMap<InetAddressAndPort, RequestFailureReason>();
            ((AbstractReplicaCollection)liveEndpoints.without(queryableEndpoints.endpoints())).forEach((Consumer<? super Replica>)((Consumer<Replica>)replica -> failureReasons.put(replica.endpoint(), RequestFailureReason.INDEX_NOT_AVAILABLE)));
            throw new ReadFailureException(level, filtered, required, false, failureReasons);
        }
        return (E)queryableEndpoints;
    }

    public synchronized void receivePeerIndexStatus(InetAddressAndPort endpoint, VersionedValue versionedValue) {
        try {
            if (versionedValue == null) {
                return;
            }
            if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
                return;
            }
            Map peerStatus = JsonUtils.fromJsonMap(versionedValue.value);
            HashMap<String, Index.Status> indexStatus = new HashMap<String, Index.Status>();
            for (Map.Entry e : peerStatus.entrySet()) {
                String keyspaceIndex = e.getKey();
                Index.Status status = Index.Status.valueOf((String)e.getValue());
                indexStatus.put(keyspaceIndex, status);
            }
            Map oldStatus = this.peerIndexStatus.put(endpoint, indexStatus);
            Map<String, Index.Status> updated = this.updatedIndexStatuses(oldStatus, indexStatus);
            Set<String> removed = this.removedIndexStatuses(oldStatus, indexStatus);
            if (!updated.isEmpty() || !removed.isEmpty()) {
                logger.debug("Received index status for peer {}:\n    Updated: {}\n    Removed: {}", new Object[]{endpoint, updated, removed});
            }
        }
        catch (IllegalArgumentException | MarshalException e) {
            logger.warn("Unable to parse index status: {}", (Object)e.getMessage());
        }
    }

    public synchronized void propagateLocalIndexStatus(String keyspace, String index, Index.Status status) {
        try {
            Map states = this.peerIndexStatus.computeIfAbsent(FBUtilities.getBroadcastAddressAndPort(), k -> new HashMap());
            String keyspaceIndex = this.identifier(keyspace, index);
            if (status == Index.Status.DROPPED) {
                states.remove(keyspaceIndex);
            } else {
                states.put(keyspaceIndex, status);
            }
            if (Gossiper.instance.isEnabled()) {
                String newStatus = JsonUtils.JSON_OBJECT_MAPPER.writeValueAsString((Object)states);
                this.statusPropagationExecutor.submit(() -> {
                    VersionedValue value = StorageService.instance.valueFactory.indexStatus(newStatus);
                    Gossiper.instance.addLocalApplicationState(ApplicationState.INDEX_STATUS, value);
                });
            }
        }
        catch (Throwable e) {
            logger.warn("Unable to propagate index status: {}", (Object)e.getMessage());
        }
    }

    @VisibleForTesting
    public synchronized Index.Status getIndexStatus(InetAddressAndPort peer, String keyspace, String index) {
        return this.peerIndexStatus.getOrDefault(peer, Collections.emptyMap()).getOrDefault(this.identifier(keyspace, index), Index.Status.UNKNOWN);
    }

    @Nonnull
    private Set<String> removedIndexStatuses(@Nullable Map<String, Index.Status> oldStatus, @Nonnull Map<String, Index.Status> newStatus) {
        if (oldStatus == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(oldStatus.keySet());
        result.removeAll(newStatus.keySet());
        return result;
    }

    @Nonnull
    private Map<String, Index.Status> updatedIndexStatuses(@Nullable Map<String, Index.Status> oldStatus, @Nonnull Map<String, Index.Status> newStatus) {
        HashMap<String, Index.Status> delta = new HashMap<String, Index.Status>();
        for (Map.Entry<String, Index.Status> e : newStatus.entrySet()) {
            if (oldStatus != null && e.getValue() == oldStatus.get(e.getKey())) continue;
            delta.put(e.getKey(), e.getValue());
        }
        return delta;
    }

    private String identifier(String keyspace, String index) {
        return keyspace + "." + index;
    }
}

