/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final char separatorChar = '/';
    public static final String separator = "/";

    public static File getResourceAsFile(String fileName) throws IOException {
        URL u = FileUtils.class.getResource(fileName);
        if (u == null) {
            throw new FileNotFoundException(String.format("Unable to find file on path %s", fileName));
        }
        return new File(u.getPath());
    }

    public static String getResourceAsString(String fileName) throws IOException {
        return Files.toString((File)FileUtils.getResourceAsFile(fileName), (Charset)Charsets.UTF_8);
    }
}

