/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.map;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class CaseInsensitiveMap<VALUE>
implements Map<String, VALUE> {
    private final Map<String, VALUE> underlyingMap;

    public static <VALUE> CaseInsensitiveMap<VALUE> newConcurrentMap() {
        return new CaseInsensitiveMap<VALUE>(Maps.newConcurrentMap());
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newHashMap() {
        return new CaseInsensitiveMap<VALUE>(Maps.newHashMap());
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newHashMapWithExpectedSize(int expectedSize) {
        return new CaseInsensitiveMap<VALUE>(Maps.newHashMapWithExpectedSize((int)expectedSize));
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newImmutableMap(Map<? extends String, ? extends VALUE> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, VALUE> entry : map.entrySet()) {
            builder.put((Object)entry.getKey().toLowerCase(), entry.getValue());
        }
        return new CaseInsensitiveMap<VALUE>(builder.build());
    }

    private CaseInsensitiveMap(Map<String, VALUE> underlyingMap) {
        this.underlyingMap = underlyingMap;
    }

    @Override
    public int size() {
        return this.underlyingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.underlyingMap.containsKey(((String)key).toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlyingMap.containsValue(value);
    }

    @Override
    public VALUE get(Object key) {
        return key instanceof String ? (VALUE)this.underlyingMap.get(((String)key).toLowerCase()) : null;
    }

    @Override
    public VALUE put(String key, VALUE value) {
        return this.underlyingMap.put(key.toLowerCase(), value);
    }

    @Override
    public VALUE remove(Object key) {
        return key instanceof String ? (VALUE)this.underlyingMap.remove(((String)key).toLowerCase()) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends VALUE> map) {
        for (Map.Entry<String, VALUE> entry : map.entrySet()) {
            this.underlyingMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.underlyingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.underlyingMap.keySet();
    }

    @Override
    public Collection<VALUE> values() {
        return this.underlyingMap.values();
    }

    @Override
    public Set<Map.Entry<String, VALUE>> entrySet() {
        return this.underlyingMap.entrySet();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.underlyingMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaseInsensitiveMap)) {
            return false;
        }
        CaseInsensitiveMap that = (CaseInsensitiveMap)o;
        return Objects.equals(this.underlyingMap, that.underlyingMap);
    }
}

