/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.drill.common.concurrent.CheckedFuture;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.ForwardingListenableFuture;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.ListenableFuture;

public abstract class AbstractCheckedFuture<T, E extends Exception>
extends ForwardingListenableFuture.SimpleForwardingListenableFuture<T>
implements CheckedFuture<T, E> {
    protected AbstractCheckedFuture(ListenableFuture<T> delegate) {
        super(delegate);
    }

    protected abstract E mapException(Exception var1);

    @Override
    public T checkedGet() throws E {
        try {
            return (T)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException(e);
        }
        catch (CancellationException | ExecutionException e) {
            throw this.mapException(e);
        }
    }

    @Override
    public T checkedGet(long timeout, TimeUnit unit) throws TimeoutException, E {
        try {
            return (T)this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException(e);
        }
        catch (CancellationException | ExecutionException e) {
            throw this.mapException(e);
        }
    }
}

