/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import java.nio.CharBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class Typifier {
    private static final Locale defaultLocale = new Locale("en");
    private static final HashSet<DateTimeFormatter> formats = new HashSet<DateTimeFormatter>(Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", defaultLocale), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SS", defaultLocale), DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm:ss a", defaultLocale), DateTimeFormatter.ofPattern("M/d/yy H:mm", defaultLocale), DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss", defaultLocale)));
    private static final HashSet<DateTimeFormatter> dateFormats = new HashSet<DateTimeFormatter>(Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd", defaultLocale), DateTimeFormatter.ofPattern("MM/dd/yyyy", defaultLocale), DateTimeFormatter.ofPattern("M/d/yy", defaultLocale), DateTimeFormatter.ofPattern("dd/MM/yyyy", defaultLocale), DateTimeFormatter.ofPattern("yyyy/MM/dd", defaultLocale), DateTimeFormatter.ofPattern("M d, yyyy", defaultLocale)));
    private static final char[] StringCharacters = new char[]{' ', ':', 'n', 'a', 't', 'r', 'o', 'C', 'i', 'P', 'D', 's', 'c', 'S', 'u', 'A', 'm', '=', 'O', '\\', 'd', 'p', 'T', 'M', 'g', 'I', 'b', 'U', 'h', 'H'};
    private static final String[] falseAliases = new String[]{"false", "False", "FALSE"};
    private static final String[] trueAliases = new String[]{"true", "True", "TRUE"};
    private static final char[] MathCharacters = new char[]{'+', '-', '/', '*', '='};

    public static Map.Entry<Class, String> typify(String data) {
        return Typifier.typify(data, false, true, true, true);
    }

    public static Map.Entry<Class, String> typify(String data, boolean bool01, boolean commonTypes, boolean postfixFL, boolean parseDates) {
        if (data == null || data.length() == 0) {
            return new AbstractMap.SimpleEntry<Class<Object>, Object>(Object.class, null);
        }
        String s = data.trim();
        int slen = s.length();
        if (slen == 0) {
            return new AbstractMap.SimpleEntry<Class, String>(String.class, data);
        }
        if (!commonTypes) {
            if (Typifier.contains(falseAliases, s)) {
                return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "false");
            }
            if (Typifier.contains(trueAliases, s)) {
                return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "true");
            }
        }
        if (!Typifier.containsAny((CharSequence)s, StringCharacters)) {
            boolean lastCharF;
            block32: {
                boolean lastCharL;
                char lastChar;
                if (bool01) {
                    if (s.equals("0")) {
                        return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "false");
                    }
                    if (s.equals("1")) {
                        return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "true");
                    }
                }
                lastCharF = (lastChar = s.charAt(slen - 1)) == 'f' || lastChar == 'F';
                boolean bl = lastCharL = lastChar == 'l' || lastChar == 'L';
                if (!commonTypes) {
                    try {
                        byte b = Byte.parseByte(s);
                        return new AbstractMap.SimpleEntry<Class, String>(Byte.class, Byte.toString(b));
                    }
                    catch (NumberFormatException b) {
                        try {
                            short h = Short.parseShort(s);
                            return new AbstractMap.SimpleEntry<Class, String>(Short.class, Short.toString(h));
                        }
                        catch (NumberFormatException h) {
                            try {
                                int i = Integer.parseInt(s);
                                return new AbstractMap.SimpleEntry<Class, String>(Integer.class, Integer.toString(i));
                            }
                            catch (NumberFormatException i) {
                                String s_L_trimmed = s;
                                if (postfixFL && slen > 1 && lastCharL) {
                                    s_L_trimmed = s.substring(0, slen - 1);
                                }
                                try {
                                    long l = Long.parseLong(s_L_trimmed);
                                    return new AbstractMap.SimpleEntry<Class, String>(Long.class, Long.toString(l));
                                }
                                catch (NumberFormatException l) {
                                    if (!postfixFL && lastCharF) break block32;
                                    try {
                                        float f = Float.parseFloat(s);
                                        if (!Float.isInfinite(f)) {
                                            return new AbstractMap.SimpleEntry<Class, String>(Float.class, Float.toString(f));
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (postfixFL || !lastCharF) {
                try {
                    double d = Double.parseDouble(s);
                    if (!Double.isInfinite(d)) {
                        return new AbstractMap.SimpleEntry<Class, String>(Double.class, Double.toString(d));
                    }
                    return new AbstractMap.SimpleEntry<Class, String>(String.class, s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (commonTypes) {
            if (Typifier.contains(falseAliases, s)) {
                return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "false");
            }
            if (Typifier.contains(trueAliases, s)) {
                return new AbstractMap.SimpleEntry<Class, String>(Boolean.class, "true");
            }
        }
        if (!commonTypes && slen == 1) {
            return new AbstractMap.SimpleEntry<Class, String>(Character.class, s);
        }
        if (parseDates && Typifier.stringAsDateTime(s) != null) {
            return new AbstractMap.SimpleEntry<Class, String>(LocalDateTime.class, s);
        }
        if (parseDates && Typifier.stringAsDate(s) != null) {
            return new AbstractMap.SimpleEntry<Class, String>(LocalDate.class, s);
        }
        return new AbstractMap.SimpleEntry<Class, String>(String.class, data);
    }

    private static LocalDateTime stringAsDateTime(String date) {
        for (DateTimeFormatter format : formats) {
            try {
                return LocalDateTime.parse(date, format);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    private static LocalDate stringAsDate(String date) {
        for (DateTimeFormatter format : dateFormats) {
            try {
                return LocalDate.parse(date, format);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static boolean containsAny(CharSequence target, CharSequence source) {
        if (target == null || target.length() == 0 || source == null || source.length() == 0) {
            return false;
        }
        for (int aa = 0; aa < target.length(); ++aa) {
            for (int bb = 0; bb < source.length(); ++bb) {
                if (source.charAt(bb) != target.charAt(aa)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence target, char[] source) {
        return Typifier.containsAny(target, CharBuffer.wrap(source));
    }

    public static <T> boolean contains(T[] target, T source) {
        if (source == null) {
            return false;
        }
        for (T t : target) {
            if (t == null || !t.equals(source)) continue;
            return true;
        }
        return false;
    }
}

