/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.types;

import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;

public enum BooleanType {
    TRUE(1, new String[]{"true", "1", "t", "y", "yes", "on"}),
    FALSE(0, new String[]{"false", "0", "f", "n", "no", "off"});

    private final int numericValue;
    private final String[] literals;
    private static final Map<String, BooleanType> allLiterals;

    private BooleanType(int numericValue, String[] literals) {
        this.numericValue = numericValue;
        this.literals = literals;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public String[] getLiterals() {
        return this.literals;
    }

    public static BooleanType get(String literal) {
        String value = literal.trim();
        BooleanType booleanType = allLiterals.get(value);
        if (booleanType == null) {
            throw new IllegalArgumentException("Invalid value for boolean: " + literal);
        }
        return booleanType;
    }

    public static boolean fromString(String value) {
        String lower = value.toLowerCase();
        for (int i = 0; i < BooleanType.TRUE.literals.length; ++i) {
            if (!BooleanType.TRUE.literals[i].equals(lower)) continue;
            return true;
        }
        return false;
    }

    static {
        allLiterals = CaseInsensitiveMap.newHashMap();
        for (BooleanType booleanType : BooleanType.values()) {
            for (String literal : booleanType.getLiterals()) {
                allLiterals.put(literal, booleanType);
            }
        }
    }
}

