/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.DrillConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillMetrics {
    static final Logger logger = LoggerFactory.getLogger(DrillMetrics.class);
    public static final String METRICS_JMX_OUTPUT_ENABLED = "drill.metrics.jmx.enabled";
    public static final String METRICS_LOG_OUTPUT_ENABLED = "drill.metrics.log.enabled";
    public static final String METRICS_LOG_OUTPUT_INTERVAL = "drill.metrics.log.interval";
    static final DrillConfig config = DrillConfig.create();

    private DrillMetrics() {
    }

    private static void registerAll(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                DrillMetrics.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public static MetricRegistry getInstance() {
        return RegistryHolder.REGISTRY;
    }

    public static void resetMetrics() {
        RegistryHolder.REGISTRY.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return true;
            }
        });
        RegistryHolder.registerSysStats();
    }

    private static class RegistryHolder {
        public static final MetricRegistry REGISTRY = new MetricRegistry();
        private static final Slf4jReporter LOG_REPORTER;

        private RegistryHolder() {
        }

        private static void registerSysStats() {
            REGISTRY.registerAll((MetricSet)new GarbageCollectorMetricSet());
            REGISTRY.registerAll((MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            REGISTRY.registerAll((MetricSet)new MemoryUsageGaugeSet());
            REGISTRY.registerAll((MetricSet)new ThreadStatesGaugeSet());
        }

        private static JmxReporter getJmxReporter() {
            if (config.getBoolean(DrillMetrics.METRICS_JMX_OUTPUT_ENABLED)) {
                JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)DrillMetrics.getInstance()).build();
                reporter.start();
                return reporter;
            }
            return null;
        }

        private static Slf4jReporter getLogReporter() {
            if (config.getBoolean(DrillMetrics.METRICS_LOG_OUTPUT_ENABLED)) {
                Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)DrillMetrics.getInstance()).outputTo(logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start((long)config.getInt(DrillMetrics.METRICS_LOG_OUTPUT_INTERVAL), TimeUnit.SECONDS);
                return reporter;
            }
            return null;
        }

        static {
            RegistryHolder.registerSysStats();
            LOG_REPORTER = RegistryHolder.getLogReporter();
        }
    }
}

