/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: User.proto

package org.apache.drill.exec.proto;

public final class UserProtos {
  private UserProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code exec.user.RpcType}
   *
   * <pre>
   *&#47;/// UserToBit RPC ///////
   * </pre>
   */
  public enum RpcType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>HANDSHAKE = 0;</code>
     */
    HANDSHAKE(0, 0),
    /**
     * <code>ACK = 1;</code>
     */
    ACK(1, 1),
    /**
     * <code>GOODBYE = 2;</code>
     */
    GOODBYE(2, 2),
    /**
     * <code>RUN_QUERY = 3;</code>
     *
     * <pre>
     * user to bit
     * </pre>
     */
    RUN_QUERY(3, 3),
    /**
     * <code>CANCEL_QUERY = 4;</code>
     *
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     */
    CANCEL_QUERY(4, 4),
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    REQUEST_RESULTS(5, 5),
    /**
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     *
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     */
    RESUME_PAUSED_QUERY(6, 11),
    /**
     * <code>QUERY_DATA = 6;</code>
     *
     * <pre>
     * bit to user
     * </pre>
     */
    QUERY_DATA(7, 6),
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    QUERY_HANDLE(8, 7),
    /**
     * <code>REQ_META_FUNCTIONS = 8;</code>
     */
    REQ_META_FUNCTIONS(9, 8),
    /**
     * <code>RESP_FUNCTION_LIST = 9;</code>
     */
    RESP_FUNCTION_LIST(10, 9),
    /**
     * <code>QUERY_RESULT = 10;</code>
     *
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     */
    QUERY_RESULT(11, 10),
    ;

    /**
     * <code>HANDSHAKE = 0;</code>
     */
    public static final int HANDSHAKE_VALUE = 0;
    /**
     * <code>ACK = 1;</code>
     */
    public static final int ACK_VALUE = 1;
    /**
     * <code>GOODBYE = 2;</code>
     */
    public static final int GOODBYE_VALUE = 2;
    /**
     * <code>RUN_QUERY = 3;</code>
     *
     * <pre>
     * user to bit
     * </pre>
     */
    public static final int RUN_QUERY_VALUE = 3;
    /**
     * <code>CANCEL_QUERY = 4;</code>
     *
     * <pre>
     * user is sending a query cancellation request to the drillbit
     * </pre>
     */
    public static final int CANCEL_QUERY_VALUE = 4;
    /**
     * <code>REQUEST_RESULTS = 5;</code>
     */
    public static final int REQUEST_RESULTS_VALUE = 5;
    /**
     * <code>RESUME_PAUSED_QUERY = 11;</code>
     *
     * <pre>
     * user is sending a query resume request to the drillbit
     * </pre>
     */
    public static final int RESUME_PAUSED_QUERY_VALUE = 11;
    /**
     * <code>QUERY_DATA = 6;</code>
     *
     * <pre>
     * bit to user
     * </pre>
     */
    public static final int QUERY_DATA_VALUE = 6;
    /**
     * <code>QUERY_HANDLE = 7;</code>
     */
    public static final int QUERY_HANDLE_VALUE = 7;
    /**
     * <code>REQ_META_FUNCTIONS = 8;</code>
     */
    public static final int REQ_META_FUNCTIONS_VALUE = 8;
    /**
     * <code>RESP_FUNCTION_LIST = 9;</code>
     */
    public static final int RESP_FUNCTION_LIST_VALUE = 9;
    /**
     * <code>QUERY_RESULT = 10;</code>
     *
     * <pre>
     * drillbit is reporting a query status change, most likely a terminal message, to the user
     * </pre>
     */
    public static final int QUERY_RESULT_VALUE = 10;


    public final int getNumber() { return value; }

    public static RpcType valueOf(int value) {
      switch (value) {
        case 0: return HANDSHAKE;
        case 1: return ACK;
        case 2: return GOODBYE;
        case 3: return RUN_QUERY;
        case 4: return CANCEL_QUERY;
        case 5: return REQUEST_RESULTS;
        case 11: return RESUME_PAUSED_QUERY;
        case 6: return QUERY_DATA;
        case 7: return QUERY_HANDLE;
        case 8: return REQ_META_FUNCTIONS;
        case 9: return RESP_FUNCTION_LIST;
        case 10: return QUERY_RESULT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<RpcType>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RpcType>() {
            public RpcType findValueByNumber(int number) {
              return RpcType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final RpcType[] VALUES = values();

    public static RpcType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private RpcType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.RpcType)
  }

  /**
   * Protobuf enum {@code exec.user.QueryResultsMode}
   */
  public enum QueryResultsMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>STREAM_FULL = 1;</code>
     *
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     */
    STREAM_FULL(0, 1),
    ;

    /**
     * <code>STREAM_FULL = 1;</code>
     *
     * <pre>
     * Server will inform the client regularly on the status of the query. Once the query is completed, service will inform the client as each query chunk is made available.
     * </pre>
     */
    public static final int STREAM_FULL_VALUE = 1;


    public final int getNumber() { return value; }

    public static QueryResultsMode valueOf(int value) {
      switch (value) {
        case 1: return STREAM_FULL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QueryResultsMode>() {
            public QueryResultsMode findValueByNumber(int number) {
              return QueryResultsMode.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(1);
    }

    private static final QueryResultsMode[] VALUES = values();

    public static QueryResultsMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private QueryResultsMode(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.QueryResultsMode)
  }

  /**
   * Protobuf enum {@code exec.user.HandshakeStatus}
   */
  public enum HandshakeStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SUCCESS = 1;</code>
     *
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     */
    SUCCESS(0, 1),
    /**
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     *
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     */
    RPC_VERSION_MISMATCH(1, 2),
    /**
     * <code>AUTH_FAILED = 3;</code>
     *
     * <pre>
     * User authentication failed
     * </pre>
     */
    AUTH_FAILED(2, 3),
    /**
     * <code>UNKNOWN_FAILURE = 4;</code>
     *
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     */
    UNKNOWN_FAILURE(3, 4),
    ;

    /**
     * <code>SUCCESS = 1;</code>
     *
     * <pre>
     * Handshake is successful (including authentication if any)
     * </pre>
     */
    public static final int SUCCESS_VALUE = 1;
    /**
     * <code>RPC_VERSION_MISMATCH = 2;</code>
     *
     * <pre>
     * Client and Server RPC versions are different
     * </pre>
     */
    public static final int RPC_VERSION_MISMATCH_VALUE = 2;
    /**
     * <code>AUTH_FAILED = 3;</code>
     *
     * <pre>
     * User authentication failed
     * </pre>
     */
    public static final int AUTH_FAILED_VALUE = 3;
    /**
     * <code>UNKNOWN_FAILURE = 4;</code>
     *
     * <pre>
     * Unknown failure, refer to the error message for more details
     * </pre>
     */
    public static final int UNKNOWN_FAILURE_VALUE = 4;


    public final int getNumber() { return value; }

    public static HandshakeStatus valueOf(int value) {
      switch (value) {
        case 1: return SUCCESS;
        case 2: return RPC_VERSION_MISMATCH;
        case 3: return AUTH_FAILED;
        case 4: return UNKNOWN_FAILURE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HandshakeStatus>() {
            public HandshakeStatus findValueByNumber(int number) {
              return HandshakeStatus.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.getDescriptor().getEnumTypes().get(2);
    }

    private static final HandshakeStatus[] VALUES = values();

    public static HandshakeStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private HandshakeStatus(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:exec.user.HandshakeStatus)
  }

  public interface PropertyOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string key = 1;
    /**
     * <code>required string key = 1;</code>
     */
    boolean hasKey();
    /**
     * <code>required string key = 1;</code>
     */
    java.lang.String getKey();
    /**
     * <code>required string key = 1;</code>
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    // required string value = 2;
    /**
     * <code>required string value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>required string value = 2;</code>
     */
    java.lang.String getValue();
    /**
     * <code>required string value = 2;</code>
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code exec.user.Property}
   */
  public static final class Property extends
      com.google.protobuf.GeneratedMessage
      implements PropertyOrBuilder {
    // Use Property.newBuilder() to construct.
    private Property(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Property(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Property defaultInstance;
    public static Property getDefaultInstance() {
      return defaultInstance;
    }

    public Property getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Property(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              key_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              value_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
    }

    public static com.google.protobuf.Parser<Property> PARSER =
        new com.google.protobuf.AbstractParser<Property>() {
      public Property parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Property(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Property> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string key = 1;
    public static final int KEY_FIELD_NUMBER = 1;
    private java.lang.Object key_;
    /**
     * <code>required string key = 1;</code>
     */
    public boolean hasKey() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string key = 1;</code>
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          key_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string key = 1;</code>
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required string value = 2;
    public static final int VALUE_FIELD_NUMBER = 2;
    private java.lang.Object value_;
    /**
     * <code>required string value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required string value = 2;</code>
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string value = 2;</code>
     */
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      key_ = "";
      value_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasKey()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasValue()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getValueBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getKeyBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getValueBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.Property parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.Property prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.Property}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.Property.class, org.apache.drill.exec.proto.UserProtos.Property.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.Property.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        key_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_Property_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.Property getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.Property build() {
        org.apache.drill.exec.proto.UserProtos.Property result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.Property buildPartial() {
        org.apache.drill.exec.proto.UserProtos.Property result = new org.apache.drill.exec.proto.UserProtos.Property(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.key_ = key_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.value_ = value_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.Property) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.Property)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.Property other) {
        if (other == org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance()) return this;
        if (other.hasKey()) {
          bitField0_ |= 0x00000001;
          key_ = other.key_;
          onChanged();
        }
        if (other.hasValue()) {
          bitField0_ |= 0x00000002;
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasKey()) {
          
          return false;
        }
        if (!hasValue()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.Property parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.Property) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string key = 1;
      private java.lang.Object key_ = "";
      /**
       * <code>required string key = 1;</code>
       */
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string key = 1;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder clearKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <code>required string key = 1;</code>
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        key_ = value;
        onChanged();
        return this;
      }

      // required string value = 2;
      private java.lang.Object value_ = "";
      /**
       * <code>required string value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>required string value = 2;</code>
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        value_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.Property)
    }

    static {
      defaultInstance = new Property(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.Property)
  }

  public interface UserPropertiesOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // repeated .exec.user.Property properties = 1;
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<org.apache.drill.exec.proto.UserProtos.Property> 
        getPropertiesList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.Property getProperties(int index);
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    int getPropertiesCount();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList();
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code exec.user.UserProperties}
   */
  public static final class UserProperties extends
      com.google.protobuf.GeneratedMessage
      implements UserPropertiesOrBuilder {
    // Use UserProperties.newBuilder() to construct.
    private UserProperties(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private UserProperties(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final UserProperties defaultInstance;
    public static UserProperties getDefaultInstance() {
      return defaultInstance;
    }

    public UserProperties getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private UserProperties(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                properties_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.Property>();
                mutable_bitField0_ |= 0x00000001;
              }
              properties_.add(input.readMessage(org.apache.drill.exec.proto.UserProtos.Property.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          properties_ = java.util.Collections.unmodifiableList(properties_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
    }

    public static com.google.protobuf.Parser<UserProperties> PARSER =
        new com.google.protobuf.AbstractParser<UserProperties>() {
      public UserProperties parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UserProperties(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<UserProperties> getParserForType() {
      return PARSER;
    }

    // repeated .exec.user.Property properties = 1;
    public static final int PROPERTIES_FIELD_NUMBER = 1;
    private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_;
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
        getPropertiesOrBuilderList() {
      return properties_;
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public int getPropertiesCount() {
      return properties_.size();
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
      return properties_.get(index);
    }
    /**
     * <code>repeated .exec.user.Property properties = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
        int index) {
      return properties_.get(index);
    }

    private void initFields() {
      properties_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      for (int i = 0; i < getPropertiesCount(); i++) {
        if (!getProperties(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < properties_.size(); i++) {
        output.writeMessage(1, properties_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < properties_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, properties_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserProperties prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserProperties}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserProperties.class, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getPropertiesFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserProperties_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties build() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.UserProperties buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserProperties result = new org.apache.drill.exec.proto.UserProtos.UserProperties(this);
        int from_bitField0_ = bitField0_;
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            properties_ = java.util.Collections.unmodifiableList(properties_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserProperties) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserProperties)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserProperties other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) return this;
        if (propertiesBuilder_ == null) {
          if (!other.properties_.isEmpty()) {
            if (properties_.isEmpty()) {
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePropertiesIsMutable();
              properties_.addAll(other.properties_);
            }
            onChanged();
          }
        } else {
          if (!other.properties_.isEmpty()) {
            if (propertiesBuilder_.isEmpty()) {
              propertiesBuilder_.dispose();
              propertiesBuilder_ = null;
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000001);
              propertiesBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getPropertiesFieldBuilder() : null;
            } else {
              propertiesBuilder_.addAllMessages(other.properties_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getPropertiesCount(); i++) {
          if (!getProperties(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.UserProperties parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.UserProperties) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // repeated .exec.user.Property properties = 1;
      private java.util.List<org.apache.drill.exec.proto.UserProtos.Property> properties_ =
        java.util.Collections.emptyList();
      private void ensurePropertiesIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          properties_ = new java.util.ArrayList<org.apache.drill.exec.proto.UserProtos.Property>(properties_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> propertiesBuilder_;

      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property> getPropertiesList() {
        if (propertiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(properties_);
        } else {
          return propertiesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public int getPropertiesCount() {
        if (propertiesBuilder_ == null) {
          return properties_.size();
        } else {
          return propertiesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property getProperties(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.set(index, value);
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder setProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.set(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(index, value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addProperties(
          int index, org.apache.drill.exec.proto.UserProtos.Property.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder addAllProperties(
          java.lang.Iterable<? extends org.apache.drill.exec.proto.UserProtos.Property> values) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          super.addAll(values, properties_);
          onChanged();
        } else {
          propertiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public Builder removeProperties(int index) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.remove(index);
          onChanged();
        } else {
          propertiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder getPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder getPropertiesOrBuilder(
          int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);  } else {
          return propertiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<? extends org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
           getPropertiesOrBuilderList() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(properties_);
        }
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder() {
        return getPropertiesFieldBuilder().addBuilder(
            org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.Property.Builder addPropertiesBuilder(
          int index) {
        return getPropertiesFieldBuilder().addBuilder(
            index, org.apache.drill.exec.proto.UserProtos.Property.getDefaultInstance());
      }
      /**
       * <code>repeated .exec.user.Property properties = 1;</code>
       */
      public java.util.List<org.apache.drill.exec.proto.UserProtos.Property.Builder> 
           getPropertiesBuilderList() {
        return getPropertiesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.Property, org.apache.drill.exec.proto.UserProtos.Property.Builder, org.apache.drill.exec.proto.UserProtos.PropertyOrBuilder>(
                  properties_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.UserProperties)
    }

    static {
      defaultInstance = new UserProperties(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserProperties)
  }

  public interface UserToBitHandshakeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.shared.RpcChannel channel = 1 [default = USER];
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    boolean hasChannel();
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel();

    // optional bool support_listening = 2;
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    boolean hasSupportListening();
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    boolean getSupportListening();

    // optional int32 rpc_version = 3;
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    int getRpcVersion();

    // optional .exec.shared.UserCredentials credentials = 4;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    boolean hasCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials();
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder();

    // optional .exec.user.UserProperties properties = 5;
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    boolean hasProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    org.apache.drill.exec.proto.UserProtos.UserProperties getProperties();
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder();

    // optional bool support_complex_types = 6 [default = false];
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    boolean hasSupportComplexTypes();
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    boolean getSupportComplexTypes();

    // optional bool support_timeout = 7 [default = false];
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    boolean hasSupportTimeout();
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    boolean getSupportTimeout();
  }
  /**
   * Protobuf type {@code exec.user.UserToBitHandshake}
   */
  public static final class UserToBitHandshake extends
      com.google.protobuf.GeneratedMessage
      implements UserToBitHandshakeOrBuilder {
    // Use UserToBitHandshake.newBuilder() to construct.
    private UserToBitHandshake(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private UserToBitHandshake(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final UserToBitHandshake defaultInstance;
    public static UserToBitHandshake getDefaultInstance() {
      return defaultInstance;
    }

    public UserToBitHandshake getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private UserToBitHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.RpcChannel value = org.apache.drill.exec.proto.UserBitShared.RpcChannel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                channel_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              supportListening_ = input.readBool();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 34: {
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = credentials_.toBuilder();
              }
              credentials_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.UserCredentials.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(credentials_);
                credentials_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 42: {
              org.apache.drill.exec.proto.UserProtos.UserProperties.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) == 0x00000010)) {
                subBuilder = properties_.toBuilder();
              }
              properties_ = input.readMessage(org.apache.drill.exec.proto.UserProtos.UserProperties.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(properties_);
                properties_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              supportComplexTypes_ = input.readBool();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              supportTimeout_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
    }

    public static com.google.protobuf.Parser<UserToBitHandshake> PARSER =
        new com.google.protobuf.AbstractParser<UserToBitHandshake>() {
      public UserToBitHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UserToBitHandshake(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<UserToBitHandshake> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.shared.RpcChannel channel = 1 [default = USER];
    public static final int CHANNEL_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_;
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    public boolean hasChannel() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
      return channel_;
    }

    // optional bool support_listening = 2;
    public static final int SUPPORT_LISTENING_FIELD_NUMBER = 2;
    private boolean supportListening_;
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    public boolean hasSupportListening() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bool support_listening = 2;</code>
     */
    public boolean getSupportListening() {
      return supportListening_;
    }

    // optional int32 rpc_version = 3;
    public static final int RPC_VERSION_FIELD_NUMBER = 3;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional int32 rpc_version = 3;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    // optional .exec.shared.UserCredentials credentials = 4;
    public static final int CREDENTIALS_FIELD_NUMBER = 4;
    private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_;
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public boolean hasCredentials() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
      return credentials_;
    }
    /**
     * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
      return credentials_;
    }

    // optional .exec.user.UserProperties properties = 5;
    public static final int PROPERTIES_FIELD_NUMBER = 5;
    private org.apache.drill.exec.proto.UserProtos.UserProperties properties_;
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public boolean hasProperties() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
      return properties_;
    }
    /**
     * <code>optional .exec.user.UserProperties properties = 5;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
      return properties_;
    }

    // optional bool support_complex_types = 6 [default = false];
    public static final int SUPPORT_COMPLEX_TYPES_FIELD_NUMBER = 6;
    private boolean supportComplexTypes_;
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    public boolean hasSupportComplexTypes() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bool support_complex_types = 6 [default = false];</code>
     */
    public boolean getSupportComplexTypes() {
      return supportComplexTypes_;
    }

    // optional bool support_timeout = 7 [default = false];
    public static final int SUPPORT_TIMEOUT_FIELD_NUMBER = 7;
    private boolean supportTimeout_;
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    public boolean hasSupportTimeout() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bool support_timeout = 7 [default = false];</code>
     */
    public boolean getSupportTimeout() {
      return supportTimeout_;
    }

    private void initFields() {
      channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
      supportListening_ = false;
      rpcVersion_ = 0;
      credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      supportComplexTypes_ = false;
      supportTimeout_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (hasProperties()) {
        if (!getProperties().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBool(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, credentials_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeMessage(5, properties_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBool(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, supportTimeout_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, channel_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, supportListening_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, rpcVersion_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, credentials_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, properties_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, supportComplexTypes_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, supportTimeout_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.UserToBitHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.UserToBitHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.class, org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCredentialsFieldBuilder();
          getPropertiesFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
        bitField0_ = (bitField0_ & ~0x00000001);
        supportListening_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (propertiesBuilder_ == null) {
          properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        supportComplexTypes_ = false;
        bitField0_ = (bitField0_ & ~0x00000020);
        supportTimeout_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_UserToBitHandshake_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake build() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.UserToBitHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake result = new org.apache.drill.exec.proto.UserProtos.UserToBitHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.channel_ = channel_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.supportListening_ = supportListening_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (credentialsBuilder_ == null) {
          result.credentials_ = credentials_;
        } else {
          result.credentials_ = credentialsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        if (propertiesBuilder_ == null) {
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.supportComplexTypes_ = supportComplexTypes_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.supportTimeout_ = supportTimeout_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.UserToBitHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.UserToBitHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.UserToBitHandshake.getDefaultInstance()) return this;
        if (other.hasChannel()) {
          setChannel(other.getChannel());
        }
        if (other.hasSupportListening()) {
          setSupportListening(other.getSupportListening());
        }
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasCredentials()) {
          mergeCredentials(other.getCredentials());
        }
        if (other.hasProperties()) {
          mergeProperties(other.getProperties());
        }
        if (other.hasSupportComplexTypes()) {
          setSupportComplexTypes(other.getSupportComplexTypes());
        }
        if (other.hasSupportTimeout()) {
          setSupportTimeout(other.getSupportTimeout());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (hasProperties()) {
          if (!getProperties().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.UserToBitHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.UserToBitHandshake) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.shared.RpcChannel channel = 1 [default = USER];
      private org.apache.drill.exec.proto.UserBitShared.RpcChannel channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public boolean hasChannel() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.RpcChannel getChannel() {
        return channel_;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public Builder setChannel(org.apache.drill.exec.proto.UserBitShared.RpcChannel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.RpcChannel channel = 1 [default = USER];</code>
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = org.apache.drill.exec.proto.UserBitShared.RpcChannel.USER;
        onChanged();
        return this;
      }

      // optional bool support_listening = 2;
      private boolean supportListening_ ;
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public boolean hasSupportListening() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public boolean getSupportListening() {
        return supportListening_;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public Builder setSupportListening(boolean value) {
        bitField0_ |= 0x00000002;
        supportListening_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_listening = 2;</code>
       */
      public Builder clearSupportListening() {
        bitField0_ = (bitField0_ & ~0x00000002);
        supportListening_ = false;
        onChanged();
        return this;
      }

      // optional int32 rpc_version = 3;
      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000004;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 3;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      // optional .exec.shared.UserCredentials credentials = 4;
      private org.apache.drill.exec.proto.UserBitShared.UserCredentials credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> credentialsBuilder_;
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public boolean hasCredentials() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials getCredentials() {
        if (credentialsBuilder_ == null) {
          return credentials_;
        } else {
          return credentialsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          credentials_ = value;
          onChanged();
        } else {
          credentialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder setCredentials(
          org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder builderForValue) {
        if (credentialsBuilder_ == null) {
          credentials_ = builderForValue.build();
          onChanged();
        } else {
          credentialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder mergeCredentials(org.apache.drill.exec.proto.UserBitShared.UserCredentials value) {
        if (credentialsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008) &&
              credentials_ != org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance()) {
            credentials_ =
              org.apache.drill.exec.proto.UserBitShared.UserCredentials.newBuilder(credentials_).mergeFrom(value).buildPartial();
          } else {
            credentials_ = value;
          }
          onChanged();
        } else {
          credentialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public Builder clearCredentials() {
        if (credentialsBuilder_ == null) {
          credentials_ = org.apache.drill.exec.proto.UserBitShared.UserCredentials.getDefaultInstance();
          onChanged();
        } else {
          credentialsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder getCredentialsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCredentialsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder getCredentialsOrBuilder() {
        if (credentialsBuilder_ != null) {
          return credentialsBuilder_.getMessageOrBuilder();
        } else {
          return credentials_;
        }
      }
      /**
       * <code>optional .exec.shared.UserCredentials credentials = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder> 
          getCredentialsFieldBuilder() {
        if (credentialsBuilder_ == null) {
          credentialsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.UserCredentials, org.apache.drill.exec.proto.UserBitShared.UserCredentials.Builder, org.apache.drill.exec.proto.UserBitShared.UserCredentialsOrBuilder>(
                  credentials_,
                  getParentForChildren(),
                  isClean());
          credentials_ = null;
        }
        return credentialsBuilder_;
      }

      // optional .exec.user.UserProperties properties = 5;
      private org.apache.drill.exec.proto.UserProtos.UserProperties properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> propertiesBuilder_;
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public boolean hasProperties() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties getProperties() {
        if (propertiesBuilder_ == null) {
          return properties_;
        } else {
          return propertiesBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          properties_ = value;
          onChanged();
        } else {
          propertiesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder setProperties(
          org.apache.drill.exec.proto.UserProtos.UserProperties.Builder builderForValue) {
        if (propertiesBuilder_ == null) {
          properties_ = builderForValue.build();
          onChanged();
        } else {
          propertiesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder mergeProperties(org.apache.drill.exec.proto.UserProtos.UserProperties value) {
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010) &&
              properties_ != org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance()) {
            properties_ =
              org.apache.drill.exec.proto.UserProtos.UserProperties.newBuilder(properties_).mergeFrom(value).buildPartial();
          } else {
            properties_ = value;
          }
          onChanged();
        } else {
          propertiesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = org.apache.drill.exec.proto.UserProtos.UserProperties.getDefaultInstance();
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserProperties.Builder getPropertiesBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getPropertiesFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder getPropertiesOrBuilder() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilder();
        } else {
          return properties_;
        }
      }
      /**
       * <code>optional .exec.user.UserProperties properties = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder> 
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserProtos.UserProperties, org.apache.drill.exec.proto.UserProtos.UserProperties.Builder, org.apache.drill.exec.proto.UserProtos.UserPropertiesOrBuilder>(
                  properties_,
                  getParentForChildren(),
                  isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      // optional bool support_complex_types = 6 [default = false];
      private boolean supportComplexTypes_ ;
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public boolean hasSupportComplexTypes() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public boolean getSupportComplexTypes() {
        return supportComplexTypes_;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public Builder setSupportComplexTypes(boolean value) {
        bitField0_ |= 0x00000020;
        supportComplexTypes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_complex_types = 6 [default = false];</code>
       */
      public Builder clearSupportComplexTypes() {
        bitField0_ = (bitField0_ & ~0x00000020);
        supportComplexTypes_ = false;
        onChanged();
        return this;
      }

      // optional bool support_timeout = 7 [default = false];
      private boolean supportTimeout_ ;
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public boolean hasSupportTimeout() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public boolean getSupportTimeout() {
        return supportTimeout_;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public Builder setSupportTimeout(boolean value) {
        bitField0_ |= 0x00000040;
        supportTimeout_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool support_timeout = 7 [default = false];</code>
       */
      public Builder clearSupportTimeout() {
        bitField0_ = (bitField0_ & ~0x00000040);
        supportTimeout_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.UserToBitHandshake)
    }

    static {
      defaultInstance = new UserToBitHandshake(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.UserToBitHandshake)
  }

  public interface RequestResultsOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.shared.QueryId query_id = 1;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    boolean hasQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId();
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder();

    // optional int32 maximum_responses = 2;
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    boolean hasMaximumResponses();
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    int getMaximumResponses();
  }
  /**
   * Protobuf type {@code exec.user.RequestResults}
   */
  public static final class RequestResults extends
      com.google.protobuf.GeneratedMessage
      implements RequestResultsOrBuilder {
    // Use RequestResults.newBuilder() to construct.
    private RequestResults(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private RequestResults(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final RequestResults defaultInstance;
    public static RequestResults getDefaultInstance() {
      return defaultInstance;
    }

    public RequestResults getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private RequestResults(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.drill.exec.proto.UserBitShared.QueryId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = queryId_.toBuilder();
              }
              queryId_ = input.readMessage(org.apache.drill.exec.proto.UserBitShared.QueryId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryId_);
                queryId_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              maximumResponses_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
    }

    public static com.google.protobuf.Parser<RequestResults> PARSER =
        new com.google.protobuf.AbstractParser<RequestResults>() {
      public RequestResults parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RequestResults(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<RequestResults> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.shared.QueryId query_id = 1;
    public static final int QUERY_ID_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_;
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public boolean hasQueryId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
      return queryId_;
    }
    /**
     * <code>optional .exec.shared.QueryId query_id = 1;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
      return queryId_;
    }

    // optional int32 maximum_responses = 2;
    public static final int MAXIMUM_RESPONSES_FIELD_NUMBER = 2;
    private int maximumResponses_;
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    public boolean hasMaximumResponses() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional int32 maximum_responses = 2;</code>
     */
    public int getMaximumResponses() {
      return maximumResponses_;
    }

    private void initFields() {
      queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      maximumResponses_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, queryId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, maximumResponses_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, queryId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, maximumResponses_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RequestResults parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RequestResults prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RequestResults}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.RequestResultsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RequestResults.class, org.apache.drill.exec.proto.UserProtos.RequestResults.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RequestResults.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getQueryIdFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        maximumResponses_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RequestResults_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults build() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.RequestResults buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RequestResults result = new org.apache.drill.exec.proto.UserProtos.RequestResults(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (queryIdBuilder_ == null) {
          result.queryId_ = queryId_;
        } else {
          result.queryId_ = queryIdBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.maximumResponses_ = maximumResponses_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RequestResults) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RequestResults)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RequestResults other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RequestResults.getDefaultInstance()) return this;
        if (other.hasQueryId()) {
          mergeQueryId(other.getQueryId());
        }
        if (other.hasMaximumResponses()) {
          setMaximumResponses(other.getMaximumResponses());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.RequestResults parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.RequestResults) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.shared.QueryId query_id = 1;
      private org.apache.drill.exec.proto.UserBitShared.QueryId queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> queryIdBuilder_;
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public boolean hasQueryId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId getQueryId() {
        if (queryIdBuilder_ == null) {
          return queryId_;
        } else {
          return queryIdBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryId_ = value;
          onChanged();
        } else {
          queryIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder setQueryId(
          org.apache.drill.exec.proto.UserBitShared.QueryId.Builder builderForValue) {
        if (queryIdBuilder_ == null) {
          queryId_ = builderForValue.build();
          onChanged();
        } else {
          queryIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder mergeQueryId(org.apache.drill.exec.proto.UserBitShared.QueryId value) {
        if (queryIdBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              queryId_ != org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance()) {
            queryId_ =
              org.apache.drill.exec.proto.UserBitShared.QueryId.newBuilder(queryId_).mergeFrom(value).buildPartial();
          } else {
            queryId_ = value;
          }
          onChanged();
        } else {
          queryIdBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public Builder clearQueryId() {
        if (queryIdBuilder_ == null) {
          queryId_ = org.apache.drill.exec.proto.UserBitShared.QueryId.getDefaultInstance();
          onChanged();
        } else {
          queryIdBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryId.Builder getQueryIdBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getQueryIdFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder getQueryIdOrBuilder() {
        if (queryIdBuilder_ != null) {
          return queryIdBuilder_.getMessageOrBuilder();
        } else {
          return queryId_;
        }
      }
      /**
       * <code>optional .exec.shared.QueryId query_id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder> 
          getQueryIdFieldBuilder() {
        if (queryIdBuilder_ == null) {
          queryIdBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.drill.exec.proto.UserBitShared.QueryId, org.apache.drill.exec.proto.UserBitShared.QueryId.Builder, org.apache.drill.exec.proto.UserBitShared.QueryIdOrBuilder>(
                  queryId_,
                  getParentForChildren(),
                  isClean());
          queryId_ = null;
        }
        return queryIdBuilder_;
      }

      // optional int32 maximum_responses = 2;
      private int maximumResponses_ ;
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public boolean hasMaximumResponses() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public int getMaximumResponses() {
        return maximumResponses_;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public Builder setMaximumResponses(int value) {
        bitField0_ |= 0x00000002;
        maximumResponses_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 maximum_responses = 2;</code>
       */
      public Builder clearMaximumResponses() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maximumResponses_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.RequestResults)
    }

    static {
      defaultInstance = new RequestResults(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.RequestResults)
  }

  public interface RunQueryOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional .exec.user.QueryResultsMode results_mode = 1;
    /**
     * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
     */
    boolean hasResultsMode();
    /**
     * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
     */
    org.apache.drill.exec.proto.UserProtos.QueryResultsMode getResultsMode();

    // optional .exec.shared.QueryType type = 2;
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    boolean hasType();
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    org.apache.drill.exec.proto.UserBitShared.QueryType getType();

    // optional string plan = 3;
    /**
     * <code>optional string plan = 3;</code>
     */
    boolean hasPlan();
    /**
     * <code>optional string plan = 3;</code>
     */
    java.lang.String getPlan();
    /**
     * <code>optional string plan = 3;</code>
     */
    com.google.protobuf.ByteString
        getPlanBytes();
  }
  /**
   * Protobuf type {@code exec.user.RunQuery}
   */
  public static final class RunQuery extends
      com.google.protobuf.GeneratedMessage
      implements RunQueryOrBuilder {
    // Use RunQuery.newBuilder() to construct.
    private RunQuery(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private RunQuery(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final RunQuery defaultInstance;
    public static RunQuery getDefaultInstance() {
      return defaultInstance;
    }

    public RunQuery getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private RunQuery(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.QueryResultsMode value = org.apache.drill.exec.proto.UserProtos.QueryResultsMode.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                resultsMode_ = value;
              }
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserBitShared.QueryType value = org.apache.drill.exec.proto.UserBitShared.QueryType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                type_ = value;
              }
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              plan_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RunQuery_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RunQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.RunQuery.class, org.apache.drill.exec.proto.UserProtos.RunQuery.Builder.class);
    }

    public static com.google.protobuf.Parser<RunQuery> PARSER =
        new com.google.protobuf.AbstractParser<RunQuery>() {
      public RunQuery parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new RunQuery(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<RunQuery> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional .exec.user.QueryResultsMode results_mode = 1;
    public static final int RESULTS_MODE_FIELD_NUMBER = 1;
    private org.apache.drill.exec.proto.UserProtos.QueryResultsMode resultsMode_;
    /**
     * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
     */
    public boolean hasResultsMode() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.QueryResultsMode getResultsMode() {
      return resultsMode_;
    }

    // optional .exec.shared.QueryType type = 2;
    public static final int TYPE_FIELD_NUMBER = 2;
    private org.apache.drill.exec.proto.UserBitShared.QueryType type_;
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.shared.QueryType type = 2;</code>
     */
    public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
      return type_;
    }

    // optional string plan = 3;
    public static final int PLAN_FIELD_NUMBER = 3;
    private java.lang.Object plan_;
    /**
     * <code>optional string plan = 3;</code>
     */
    public boolean hasPlan() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string plan = 3;</code>
     */
    public java.lang.String getPlan() {
      java.lang.Object ref = plan_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          plan_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string plan = 3;</code>
     */
    public com.google.protobuf.ByteString
        getPlanBytes() {
      java.lang.Object ref = plan_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        plan_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      resultsMode_ = org.apache.drill.exec.proto.UserProtos.QueryResultsMode.STREAM_FULL;
      type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
      plan_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, resultsMode_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, type_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getPlanBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, resultsMode_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getPlanBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.RunQuery parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.RunQuery prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.RunQuery}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.RunQueryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RunQuery_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RunQuery_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.RunQuery.class, org.apache.drill.exec.proto.UserProtos.RunQuery.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.RunQuery.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        resultsMode_ = org.apache.drill.exec.proto.UserProtos.QueryResultsMode.STREAM_FULL;
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
        bitField0_ = (bitField0_ & ~0x00000002);
        plan_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_RunQuery_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.RunQuery getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.RunQuery.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.RunQuery build() {
        org.apache.drill.exec.proto.UserProtos.RunQuery result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.RunQuery buildPartial() {
        org.apache.drill.exec.proto.UserProtos.RunQuery result = new org.apache.drill.exec.proto.UserProtos.RunQuery(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.resultsMode_ = resultsMode_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.plan_ = plan_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.RunQuery) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.RunQuery)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.RunQuery other) {
        if (other == org.apache.drill.exec.proto.UserProtos.RunQuery.getDefaultInstance()) return this;
        if (other.hasResultsMode()) {
          setResultsMode(other.getResultsMode());
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasPlan()) {
          bitField0_ |= 0x00000004;
          plan_ = other.plan_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.RunQuery parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.RunQuery) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional .exec.user.QueryResultsMode results_mode = 1;
      private org.apache.drill.exec.proto.UserProtos.QueryResultsMode resultsMode_ = org.apache.drill.exec.proto.UserProtos.QueryResultsMode.STREAM_FULL;
      /**
       * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
       */
      public boolean hasResultsMode() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.QueryResultsMode getResultsMode() {
        return resultsMode_;
      }
      /**
       * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
       */
      public Builder setResultsMode(org.apache.drill.exec.proto.UserProtos.QueryResultsMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        resultsMode_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.QueryResultsMode results_mode = 1;</code>
       */
      public Builder clearResultsMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        resultsMode_ = org.apache.drill.exec.proto.UserProtos.QueryResultsMode.STREAM_FULL;
        onChanged();
        return this;
      }

      // optional .exec.shared.QueryType type = 2;
      private org.apache.drill.exec.proto.UserBitShared.QueryType type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public org.apache.drill.exec.proto.UserBitShared.QueryType getType() {
        return type_;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public Builder setType(org.apache.drill.exec.proto.UserBitShared.QueryType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.shared.QueryType type = 2;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = org.apache.drill.exec.proto.UserBitShared.QueryType.SQL;
        onChanged();
        return this;
      }

      // optional string plan = 3;
      private java.lang.Object plan_ = "";
      /**
       * <code>optional string plan = 3;</code>
       */
      public boolean hasPlan() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string plan = 3;</code>
       */
      public java.lang.String getPlan() {
        java.lang.Object ref = plan_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          plan_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string plan = 3;</code>
       */
      public com.google.protobuf.ByteString
          getPlanBytes() {
        java.lang.Object ref = plan_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          plan_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string plan = 3;</code>
       */
      public Builder setPlan(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        plan_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string plan = 3;</code>
       */
      public Builder clearPlan() {
        bitField0_ = (bitField0_ & ~0x00000004);
        plan_ = getDefaultInstance().getPlan();
        onChanged();
        return this;
      }
      /**
       * <code>optional string plan = 3;</code>
       */
      public Builder setPlanBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        plan_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.RunQuery)
    }

    static {
      defaultInstance = new RunQuery(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.RunQuery)
  }

  public interface BitToUserHandshakeOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // optional int32 rpc_version = 2;
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    boolean hasRpcVersion();
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    int getRpcVersion();

    // optional .exec.user.HandshakeStatus status = 3;
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus();

    // optional string errorId = 4;
    /**
     * <code>optional string errorId = 4;</code>
     */
    boolean hasErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     */
    java.lang.String getErrorId();
    /**
     * <code>optional string errorId = 4;</code>
     */
    com.google.protobuf.ByteString
        getErrorIdBytes();

    // optional string errorMessage = 5;
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    boolean hasErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    java.lang.String getErrorMessage();
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    com.google.protobuf.ByteString
        getErrorMessageBytes();
  }
  /**
   * Protobuf type {@code exec.user.BitToUserHandshake}
   */
  public static final class BitToUserHandshake extends
      com.google.protobuf.GeneratedMessage
      implements BitToUserHandshakeOrBuilder {
    // Use BitToUserHandshake.newBuilder() to construct.
    private BitToUserHandshake(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private BitToUserHandshake(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final BitToUserHandshake defaultInstance;
    public static BitToUserHandshake getDefaultInstance() {
      return defaultInstance;
    }

    public BitToUserHandshake getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private BitToUserHandshake(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000001;
              rpcVersion_ = input.readInt32();
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              org.apache.drill.exec.proto.UserProtos.HandshakeStatus value = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(3, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                status_ = value;
              }
              break;
            }
            case 34: {
              bitField0_ |= 0x00000004;
              errorId_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000008;
              errorMessage_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
    }

    public static com.google.protobuf.Parser<BitToUserHandshake> PARSER =
        new com.google.protobuf.AbstractParser<BitToUserHandshake>() {
      public BitToUserHandshake parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BitToUserHandshake(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<BitToUserHandshake> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // optional int32 rpc_version = 2;
    public static final int RPC_VERSION_FIELD_NUMBER = 2;
    private int rpcVersion_;
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    public boolean hasRpcVersion() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional int32 rpc_version = 2;</code>
     */
    public int getRpcVersion() {
      return rpcVersion_;
    }

    // optional .exec.user.HandshakeStatus status = 3;
    public static final int STATUS_FIELD_NUMBER = 3;
    private org.apache.drill.exec.proto.UserProtos.HandshakeStatus status_;
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .exec.user.HandshakeStatus status = 3;</code>
     */
    public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
      return status_;
    }

    // optional string errorId = 4;
    public static final int ERRORID_FIELD_NUMBER = 4;
    private java.lang.Object errorId_;
    /**
     * <code>optional string errorId = 4;</code>
     */
    public boolean hasErrorId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional string errorId = 4;</code>
     */
    public java.lang.String getErrorId() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorId = 4;</code>
     */
    public com.google.protobuf.ByteString
        getErrorIdBytes() {
      java.lang.Object ref = errorId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string errorMessage = 5;
    public static final int ERRORMESSAGE_FIELD_NUMBER = 5;
    private java.lang.Object errorMessage_;
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          errorMessage_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string errorMessage = 5;</code>
     */
    public com.google.protobuf.ByteString
        getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      rpcVersion_ = 0;
      status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
      errorId_ = "";
      errorMessage_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(3, status_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(4, getErrorIdBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(5, getErrorMessageBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, rpcVersion_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, status_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, getErrorIdBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, getErrorMessageBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code exec.user.BitToUserHandshake}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements org.apache.drill.exec.proto.UserProtos.BitToUserHandshakeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.class, org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.Builder.class);
      }

      // Construct using org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        rpcVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
        bitField0_ = (bitField0_ & ~0x00000002);
        errorId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        errorMessage_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.drill.exec.proto.UserProtos.internal_static_exec_user_BitToUserHandshake_descriptor;
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake getDefaultInstanceForType() {
        return org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance();
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake build() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.drill.exec.proto.UserProtos.BitToUserHandshake buildPartial() {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake result = new org.apache.drill.exec.proto.UserProtos.BitToUserHandshake(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.rpcVersion_ = rpcVersion_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.errorId_ = errorId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.errorMessage_ = errorMessage_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) {
          return mergeFrom((org.apache.drill.exec.proto.UserProtos.BitToUserHandshake)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.drill.exec.proto.UserProtos.BitToUserHandshake other) {
        if (other == org.apache.drill.exec.proto.UserProtos.BitToUserHandshake.getDefaultInstance()) return this;
        if (other.hasRpcVersion()) {
          setRpcVersion(other.getRpcVersion());
        }
        if (other.hasStatus()) {
          setStatus(other.getStatus());
        }
        if (other.hasErrorId()) {
          bitField0_ |= 0x00000004;
          errorId_ = other.errorId_;
          onChanged();
        }
        if (other.hasErrorMessage()) {
          bitField0_ |= 0x00000008;
          errorMessage_ = other.errorMessage_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.drill.exec.proto.UserProtos.BitToUserHandshake parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.drill.exec.proto.UserProtos.BitToUserHandshake) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // optional int32 rpc_version = 2;
      private int rpcVersion_ ;
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public boolean hasRpcVersion() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public int getRpcVersion() {
        return rpcVersion_;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public Builder setRpcVersion(int value) {
        bitField0_ |= 0x00000001;
        rpcVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int32 rpc_version = 2;</code>
       */
      public Builder clearRpcVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcVersion_ = 0;
        onChanged();
        return this;
      }

      // optional .exec.user.HandshakeStatus status = 3;
      private org.apache.drill.exec.proto.UserProtos.HandshakeStatus status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public org.apache.drill.exec.proto.UserProtos.HandshakeStatus getStatus() {
        return status_;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public Builder setStatus(org.apache.drill.exec.proto.UserProtos.HandshakeStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .exec.user.HandshakeStatus status = 3;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = org.apache.drill.exec.proto.UserProtos.HandshakeStatus.SUCCESS;
        onChanged();
        return this;
      }

      // optional string errorId = 4;
      private java.lang.Object errorId_ = "";
      /**
       * <code>optional string errorId = 4;</code>
       */
      public boolean hasErrorId() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public java.lang.String getErrorId() {
        java.lang.Object ref = errorId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          errorId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public com.google.protobuf.ByteString
          getErrorIdBytes() {
        java.lang.Object ref = errorId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder setErrorId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder clearErrorId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        errorId_ = getDefaultInstance().getErrorId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorId = 4;</code>
       */
      public Builder setErrorIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        errorId_ = value;
        onChanged();
        return this;
      }

      // optional string errorMessage = 5;
      private java.lang.Object errorMessage_ = "";
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public boolean hasErrorMessage() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public com.google.protobuf.ByteString
          getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder setErrorMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder clearErrorMessage() {
        bitField0_ = (bitField0_ & ~0x00000008);
        errorMessage_ = getDefaultInstance().getErrorMessage();
        onChanged();
        return this;
      }
      /**
       * <code>optional string errorMessage = 5;</code>
       */
      public Builder setErrorMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        errorMessage_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:exec.user.BitToUserHandshake)
    }

    static {
      defaultInstance = new BitToUserHandshake(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:exec.user.BitToUserHandshake)
  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_Property_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_Property_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_UserProperties_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_UserProperties_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_UserToBitHandshake_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_UserToBitHandshake_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_RequestResults_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_RequestResults_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_RunQuery_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_RunQuery_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_exec_user_BitToUserHandshake_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_exec_user_BitToUserHandshake_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\nUser.proto\022\texec.user\032\017SchemaDef.proto" +
      "\032\023UserBitShared.proto\"&\n\010Property\022\013\n\003key" +
      "\030\001 \002(\t\022\r\n\005value\030\002 \002(\t\"9\n\016UserProperties\022" +
      "\'\n\nproperties\030\001 \003(\0132\023.exec.user.Property" +
      "\"\234\002\n\022UserToBitHandshake\022.\n\007channel\030\001 \001(\016" +
      "2\027.exec.shared.RpcChannel:\004USER\022\031\n\021suppo" +
      "rt_listening\030\002 \001(\010\022\023\n\013rpc_version\030\003 \001(\005\022" +
      "1\n\013credentials\030\004 \001(\0132\034.exec.shared.UserC" +
      "redentials\022-\n\nproperties\030\005 \001(\0132\031.exec.us" +
      "er.UserProperties\022$\n\025support_complex_typ",
      "es\030\006 \001(\010:\005false\022\036\n\017support_timeout\030\007 \001(\010" +
      ":\005false\"S\n\016RequestResults\022&\n\010query_id\030\001 " +
      "\001(\0132\024.exec.shared.QueryId\022\031\n\021maximum_res" +
      "ponses\030\002 \001(\005\"q\n\010RunQuery\0221\n\014results_mode" +
      "\030\001 \001(\0162\033.exec.user.QueryResultsMode\022$\n\004t" +
      "ype\030\002 \001(\0162\026.exec.shared.QueryType\022\014\n\004pla" +
      "n\030\003 \001(\t\"|\n\022BitToUserHandshake\022\023\n\013rpc_ver" +
      "sion\030\002 \001(\005\022*\n\006status\030\003 \001(\0162\032.exec.user.H" +
      "andshakeStatus\022\017\n\007errorId\030\004 \001(\t\022\024\n\014error" +
      "Message\030\005 \001(\t*\341\001\n\007RpcType\022\r\n\tHANDSHAKE\020\000",
      "\022\007\n\003ACK\020\001\022\013\n\007GOODBYE\020\002\022\r\n\tRUN_QUERY\020\003\022\020\n" +
      "\014CANCEL_QUERY\020\004\022\023\n\017REQUEST_RESULTS\020\005\022\027\n\023" +
      "RESUME_PAUSED_QUERY\020\013\022\016\n\nQUERY_DATA\020\006\022\020\n" +
      "\014QUERY_HANDLE\020\007\022\026\n\022REQ_META_FUNCTIONS\020\010\022" +
      "\026\n\022RESP_FUNCTION_LIST\020\t\022\020\n\014QUERY_RESULT\020" +
      "\n*#\n\020QueryResultsMode\022\017\n\013STREAM_FULL\020\001*^" +
      "\n\017HandshakeStatus\022\013\n\007SUCCESS\020\001\022\030\n\024RPC_VE" +
      "RSION_MISMATCH\020\002\022\017\n\013AUTH_FAILED\020\003\022\023\n\017UNK" +
      "NOWN_FAILURE\020\004B+\n\033org.apache.drill.exec." +
      "protoB\nUserProtosH\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_exec_user_Property_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_exec_user_Property_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_Property_descriptor,
              new java.lang.String[] { "Key", "Value", });
          internal_static_exec_user_UserProperties_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_exec_user_UserProperties_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_UserProperties_descriptor,
              new java.lang.String[] { "Properties", });
          internal_static_exec_user_UserToBitHandshake_descriptor =
            getDescriptor().getMessageTypes().get(2);
          internal_static_exec_user_UserToBitHandshake_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_UserToBitHandshake_descriptor,
              new java.lang.String[] { "Channel", "SupportListening", "RpcVersion", "Credentials", "Properties", "SupportComplexTypes", "SupportTimeout", });
          internal_static_exec_user_RequestResults_descriptor =
            getDescriptor().getMessageTypes().get(3);
          internal_static_exec_user_RequestResults_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_RequestResults_descriptor,
              new java.lang.String[] { "QueryId", "MaximumResponses", });
          internal_static_exec_user_RunQuery_descriptor =
            getDescriptor().getMessageTypes().get(4);
          internal_static_exec_user_RunQuery_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_RunQuery_descriptor,
              new java.lang.String[] { "ResultsMode", "Type", "Plan", });
          internal_static_exec_user_BitToUserHandshake_descriptor =
            getDescriptor().getMessageTypes().get(5);
          internal_static_exec_user_BitToUserHandshake_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_exec_user_BitToUserHandshake_descriptor,
              new java.lang.String[] { "RpcVersion", "Status", "ErrorId", "ErrorMessage", });
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.drill.exec.proto.SchemaDefProtos.getDescriptor(),
          org.apache.drill.exec.proto.UserBitShared.getDescriptor(),
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
