/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by http://code.google.com/p/protostuff/ ... DO NOT EDIT!
// Generated from protobuf

package org.apache.drill.exec.proto.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;

public final class ExceptionWrapper implements Externalizable, Message<ExceptionWrapper>, Schema<ExceptionWrapper>
{

    public static Schema<ExceptionWrapper> getSchema()
    {
        return DEFAULT_INSTANCE;
    }

    public static ExceptionWrapper getDefaultInstance()
    {
        return DEFAULT_INSTANCE;
    }

    static final ExceptionWrapper DEFAULT_INSTANCE = new ExceptionWrapper();

    
    private String exceptionClass;
    private String message;
    private List<StackTraceElementWrapper> stackTrace;
    private ExceptionWrapper cause;

    public ExceptionWrapper()
    {
        
    }

    // getters and setters

    // exceptionClass

    public String getExceptionClass()
    {
        return exceptionClass;
    }

    public ExceptionWrapper setExceptionClass(String exceptionClass)
    {
        this.exceptionClass = exceptionClass;
        return this;
    }

    // message

    public String getMessage()
    {
        return message;
    }

    public ExceptionWrapper setMessage(String message)
    {
        this.message = message;
        return this;
    }

    // stackTrace

    public List<StackTraceElementWrapper> getStackTraceList()
    {
        return stackTrace;
    }

    public ExceptionWrapper setStackTraceList(List<StackTraceElementWrapper> stackTrace)
    {
        this.stackTrace = stackTrace;
        return this;
    }

    // cause

    public ExceptionWrapper getCause()
    {
        return cause;
    }

    public ExceptionWrapper setCause(ExceptionWrapper cause)
    {
        this.cause = cause;
        return this;
    }

    // java serialization

    public void readExternal(ObjectInput in) throws IOException
    {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException
    {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    // message method

    public Schema<ExceptionWrapper> cachedSchema()
    {
        return DEFAULT_INSTANCE;
    }

    // schema methods

    public ExceptionWrapper newMessage()
    {
        return new ExceptionWrapper();
    }

    public Class<ExceptionWrapper> typeClass()
    {
        return ExceptionWrapper.class;
    }

    public String messageName()
    {
        return ExceptionWrapper.class.getSimpleName();
    }

    public String messageFullName()
    {
        return ExceptionWrapper.class.getName();
    }

    public boolean isInitialized(ExceptionWrapper message)
    {
        return true;
    }

    public void mergeFrom(Input input, ExceptionWrapper message) throws IOException
    {
        for(int number = input.readFieldNumber(this);; number = input.readFieldNumber(this))
        {
            switch(number)
            {
                case 0:
                    return;
                case 1:
                    message.exceptionClass = input.readString();
                    break;
                case 2:
                    message.message = input.readString();
                    break;
                case 3:
                    if(message.stackTrace == null)
                        message.stackTrace = new ArrayList<StackTraceElementWrapper>();
                    message.stackTrace.add(input.mergeObject(null, StackTraceElementWrapper.getSchema()));
                    break;

                case 4:
                    message.cause = input.mergeObject(message.cause, ExceptionWrapper.getSchema());
                    break;

                default:
                    input.handleUnknownField(number, this);
            }   
        }
    }


    public void writeTo(Output output, ExceptionWrapper message) throws IOException
    {
        if(message.exceptionClass != null)
            output.writeString(1, message.exceptionClass, false);

        if(message.message != null)
            output.writeString(2, message.message, false);

        if(message.stackTrace != null)
        {
            for(StackTraceElementWrapper stackTrace : message.stackTrace)
            {
                if(stackTrace != null)
                    output.writeObject(3, stackTrace, StackTraceElementWrapper.getSchema(), true);
            }
        }


        if(message.cause != null)
             output.writeObject(4, message.cause, ExceptionWrapper.getSchema(), false);

    }

    public String getFieldName(int number)
    {
        switch(number)
        {
            case 1: return "exceptionClass";
            case 2: return "message";
            case 3: return "stackTrace";
            case 4: return "cause";
            default: return null;
        }
    }

    public int getFieldNumber(String name)
    {
        final Integer number = __fieldMap.get(name);
        return number == null ? 0 : number.intValue();
    }

    private static final java.util.HashMap<String,Integer> __fieldMap = new java.util.HashMap<String,Integer>();
    static
    {
        __fieldMap.put("exceptionClass", 1);
        __fieldMap.put("message", 2);
        __fieldMap.put("stackTrace", 3);
        __fieldMap.put("cause", 4);
    }
    
}
