/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RpcCheckedFuture;
import org.apache.drill.exec.rpc.RpcCommand;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FutureBitCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(FutureBitCommand.class);
    protected final SettableFuture<T> settableFuture = SettableFuture.create();
    private final RpcCheckedFuture<T> parentFuture = new RpcCheckedFuture<T>(this.settableFuture);

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    public DrillRpcFuture<T> getFuture() {
        return this.parentFuture;
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
        this.settableFuture.setException((Throwable)((Object)RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t)));
    }

    private class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            FutureBitCommand.this.settableFuture.setException((Throwable)((Object)ex));
        }

        @Override
        public void success(T value, ByteBuf buf) {
            FutureBitCommand.this.settableFuture.set(value);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while running the command", (Throwable)e);
            this.failed(new RpcException(e));
        }
    }
}

