/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.drill.common.SerializedExecutor;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.ChannelClosedException;
import org.apache.drill.exec.rpc.ChannelListenerWithCoordinationId;
import org.apache.drill.exec.rpc.CoordinationQueue;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.DrillRpcFutureImpl;
import org.apache.drill.exec.rpc.InboundRpcMessage;
import org.apache.drill.exec.rpc.OutboundRpcMessage;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.UserRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBus<T extends Internal.EnumLite, C extends RemoteConnection>
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final OutboundRpcMessage PONG = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PONG, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    private static final boolean ENABLE_SEPARATE_THREADS = "true".equals(System.getProperty("drill.enable_rpc_offload"));
    protected final CoordinationQueue queue = new CoordinationQueue(16, 16);
    protected final RpcConfig rpcConfig;
    protected volatile SocketAddress local;
    protected volatile SocketAddress remote;

    protected abstract MessageLite getResponseDefaultInstance(int var1) throws RpcException;

    protected void handle(C connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        sender.send(this.handle(connection, rpcType, pBody, dBody));
    }

    protected abstract Response handle(C var1, int var2, ByteBuf var3, ByteBuf var4) throws RpcException;

    public abstract boolean isClient();

    public RpcBus(RpcConfig rpcConfig) {
        this.rpcConfig = rpcConfig;
    }

    protected void setAddresses(SocketAddress remote, SocketAddress local) {
        this.remote = remote;
        this.local = local;
    }

    <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        DrillRpcFutureImpl rpcFuture = new DrillRpcFutureImpl();
        this.send(rpcFuture, connection, rpcType, protobufBody, clazz, dataBodies);
        return rpcFuture;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.send(listener, connection, rpcType, protobufBody, clazz, false, dataBodies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        block11: {
            Preconditions.checkArgument((allowInEventLoop || !((RemoteConnection)connection).inEventLoop() ? 1 : 0) != 0, (Object)"You attempted to send while inside the rpc event thread.  This isn't allowed because sending will block if the channel is backed up.");
            Object pBuffer = null;
            boolean completed = false;
            try {
                if (!allowInEventLoop && !((RemoteConnection)connection).blockOnNotWritable(listener)) {
                    return;
                }
                assert (!Arrays.asList(dataBodies).contains(null));
                assert (this.rpcConfig.checkSend((Internal.EnumLite)rpcType, protobufBody.getClass(), clazz));
                Preconditions.checkNotNull(protobufBody);
                ChannelListenerWithCoordinationId futureListener = this.queue.get(listener, clazz, (RemoteConnection)connection);
                OutboundRpcMessage m = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.REQUEST, (Internal.EnumLite)rpcType, futureListener.getCoordinationId(), (MessageLite)protobufBody, dataBodies);
                ChannelFuture channelFuture = ((RemoteConnection)connection).getChannel().writeAndFlush((Object)m);
                channelFuture.addListener((GenericFutureListener)futureListener);
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                completed = true;
            }
            catch (AssertionError | Exception e) {
                listener.failed(new RpcException("Failure sending message.", (Throwable)e));
            }
            finally {
                if (completed) break block11;
                if (pBuffer != null) {
                    pBuffer.release();
                }
                if (dataBodies == null) break block11;
                for (ByteBuf b : dataBodies) {
                    b.release();
                }
            }
        }
    }

    public abstract C initRemoteConnection(SocketChannel var1);

    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel channel, C clientConnection) {
        return new ChannelClosedHandler(this, clientConnection, (Channel)channel);
    }

    public static <T> T get(ByteBuf pBody, Parser<T> parser) throws RpcException {
        try {
            ByteBufInputStream is = new ByteBufInputStream(pBody);
            return (T)parser.parseFrom((InputStream)is);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    static /* synthetic */ OutboundRpcMessage access$200() {
        return PONG;
    }

    private class ResponseEvent
    implements Runnable {
        private final int rpcType;
        private final int coordinationId;
        private final ByteBuf pBody;
        private final ByteBuf dBody;

        public ResponseEvent(int rpcType, int coordinationId, ByteBuf pBody, ByteBuf dBody) {
            this.rpcType = rpcType;
            this.coordinationId = coordinationId;
            this.pBody = pBody;
            this.dBody = dBody;
            if (pBody != null) {
                pBody.retain();
            }
            if (dBody != null) {
                dBody.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessageLite m = RpcBus.this.getResponseDefaultInstance(this.rpcType);
                assert (RpcBus.this.rpcConfig.checkReceive(this.rpcType, m.getClass()));
                RpcOutcome<?> rpcFuture = RpcBus.this.queue.getFuture(this.rpcType, this.coordinationId, m.getClass());
                Parser parser = m.getParserForType();
                Object value = parser.parseFrom((InputStream)new ByteBufInputStream(this.pBody, this.pBody.readableBytes()));
                rpcFuture.set(value, this.dBody);
            }
            catch (Exception ex) {
                RpcBus.this.logger.error("Failure while handling response.", (Throwable)ex);
            }
            finally {
                if (this.pBody != null) {
                    this.pBody.release();
                }
                if (this.dBody != null) {
                    this.dBody.release();
                }
            }
        }
    }

    private static class RequestEvent
    implements Runnable {
        private final ResponseSenderImpl sender;
        private final C connection;
        private final int rpcType;
        private final ByteBuf pBody;
        private final ByteBuf dBody;
        final /* synthetic */ RpcBus this$0;

        RequestEvent(int coordinationId, C connection, int rpcType, ByteBuf pBody, ByteBuf dBody) {
            this.this$0 = var1_1;
            this.sender = var1_1.new ResponseSenderImpl();
            this.connection = connection;
            this.rpcType = rpcType;
            this.pBody = pBody;
            this.dBody = dBody;
            this.sender.set((RemoteConnection)connection, coordinationId);
            if (pBody != null) {
                pBody.retain();
            }
            if (dBody != null) {
                dBody.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.this$0.handle(this.connection, this.rpcType, this.pBody, this.dBody, this.sender);
            }
            catch (UserRpcException e) {
                this.sender.sendFailure(e);
            }
            catch (Exception e) {
                this.this$0.logger.error("Failure while handling message.", (Throwable)e);
            }
            finally {
                if (this.pBody != null) {
                    this.pBody.release();
                }
                if (this.dBody != null) {
                    this.dBody.release();
                }
            }
        }
    }

    class RpcEventHandler
    extends SerializedExecutor {
        public RpcEventHandler(Executor underlyingExecutor) {
            super(RpcBus.this.rpcConfig.getName() + "-rpc-event-queue", underlyingExecutor);
        }

        @Override
        protected void runException(Runnable command, Throwable t) {
            RpcBus.this.logger.error("Failure while running rpc command.", t);
        }
    }

    protected static class InboundHandler
    extends MessageToMessageDecoder<InboundRpcMessage> {
        private final Executor exec;
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public InboundHandler(C connection) {
            this.this$0 = var1_1;
            this.connection = connection;
            Executor underlyingExecutor = ENABLE_SEPARATE_THREADS ? var1_1.rpcConfig.getExecutor() : var1_1.new SameExecutor();
            this.exec = var1_1.new RpcEventHandler(underlyingExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> output) throws Exception {
            if (!ctx.channel().isOpen()) {
                return;
            }
            channel = this.connection.getChannel();
            watch = Stopwatch.createStarted();
            try {
                switch (1.$SwitchMap$org$apache$drill$exec$proto$GeneralRPCProtos$RpcMode[msg.mode.ordinal()]) {
                    case 1: {
                        reqEvent = new RequestEvent(this.this$0, msg.coordinationId, this.connection, msg.rpcType, msg.pBody, msg.dBody);
                        this.exec.execute(reqEvent);
                        ** break;
                    }
                    case 2: {
                        respEvent = this.this$0.new ResponseEvent(msg.rpcType, msg.coordinationId, msg.pBody, msg.dBody);
                        this.exec.execute(respEvent);
                        ** break;
                    }
                    case 3: {
                        failure = UserBitShared.DrillPBError.parseFrom((InputStream)new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                        this.this$0.queue.updateFailedFuture(msg.coordinationId, failure);
                        ** break;
                    }
                    case 4: {
                        channel.writeAndFlush((Object)RpcBus.access$200());
                        ** break;
                    }
                    case 5: {
                        ** break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
lbl27:
                        // 5 sources

                    }
                }
            }
            catch (Throwable var10_11) {
                time = watch.elapsed(TimeUnit.MILLISECONDS);
                delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
                if (time > delayThreshold) {
                    this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", new Object[]{msg.mode, msg.rpcType, delayThreshold, time}));
                }
                msg.release();
                throw var10_11;
            }
            time = watch.elapsed(TimeUnit.MILLISECONDS);
            delayThreshold = Integer.parseInt(System.getProperty("drill.exec.rpcDelayWarning", "500"));
            if (time > delayThreshold) {
                this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", new Object[]{msg.mode, msg.rpcType, delayThreshold, time}));
            }
            msg.release();
        }
    }

    private class SameExecutor
    implements Executor {
        private SameExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private class ResponseSenderImpl
    implements ResponseSender {
        private RemoteConnection connection;
        private int coordinationId;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        void set(RemoteConnection connection, int coordinationId) {
            this.connection = connection;
            this.coordinationId = coordinationId;
            this.sent.set(false);
        }

        @Override
        public void send(Response r) {
            assert (RpcBus.this.rpcConfig.checkResponseSend(r.rpcType, r.pBody.getClass()));
            this.sendOnce();
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, r.rpcType, this.coordinationId, r.pBody, r.dBodies);
            RpcBus.this.logger.debug("Sending response with Sender {}", (Object)System.identityHashCode(this));
            this.connection.getChannel().writeAndFlush((Object)outMessage);
        }

        private void sendOnce() {
            if (!this.sent.compareAndSet(false, true)) {
                throw new IllegalStateException("Attempted to utilize a sender multiple times.");
            }
        }

        void sendFailure(UserRpcException e) {
            this.sendOnce();
            UserException uex = UserException.systemError((Throwable)((Object)e)).addIdentity(e.getEndpoint()).build(RpcBus.this.logger);
            RpcBus.this.logger.error("Unexpected Error while handling request message", (Throwable)((Object)e));
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE_FAILURE, 0, this.coordinationId, (MessageLite)uex.getOrCreatePBError(false), new ByteBuf[0]);
            this.connection.getChannel().writeAndFlush((Object)outMessage);
        }
    }

    private static interface Recyclable {
        public void recycle();
    }

    public static class ChannelClosedHandler
    implements GenericFutureListener<ChannelFuture> {
        final C clientConnection;
        private final Channel channel;
        final /* synthetic */ RpcBus this$0;

        public ChannelClosedHandler(C clientConnection, Channel channel) {
            this.this$0 = var1_1;
            this.channel = channel;
            this.clientConnection = clientConnection;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            String msg = this.this$0.local != null ? String.format("Channel closed %s <--> %s.", this.this$0.local, this.this$0.remote) : String.format("Channel closed %s <--> %s.", future.channel().localAddress(), future.channel().remoteAddress());
            if (this.this$0.isClient()) {
                if (this.this$0.local != null) {
                    this.this$0.logger.info(String.format(msg, new Object[0]));
                }
            } else {
                this.this$0.queue.channelClosed((Throwable)((Object)new ChannelClosedException(msg)));
            }
            ((RemoteConnection)this.clientConnection).close();
        }
    }
}

