/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common;

import java.util.AbstractList;
import java.util.RandomAccess;

public class CircularArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private final E[] buf;
    private int head = 0;
    private int tail = 0;
    private boolean full = false;

    public CircularArrayList(E[] array) {
        this.buf = array;
        this.full = this.buf.length == 0;
    }

    public int capacity() {
        return this.buf.length;
    }

    public int head() {
        return this.head;
    }

    public int tail() {
        return this.tail;
    }

    public boolean isFull() {
        return this.full;
    }

    @Override
    public void clear() {
        this.head = 0;
        this.tail = 0;
        this.full = false;
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = null;
        }
    }

    private int wrapIndex(int i) {
        int m = i % this.buf.length;
        if (m < 0) {
            throw new IndexOutOfBoundsException();
        }
        return m;
    }

    private void shiftBlock(int startIndex, int endIndex) {
        assert (endIndex > startIndex);
        for (int i = endIndex - 1; i >= startIndex; --i) {
            this.set(i + 1, this.get(i));
        }
    }

    public int find(E e) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!e.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        if (this.full) {
            return this.buf.length;
        }
        return this.tail - this.head + (this.tail < this.head ? this.buf.length : 0);
    }

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[this.wrapIndex(this.head + i)];
    }

    @Override
    public E set(int i, E e) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        E e2 = e;
        this.buf[this.wrapIndex((int)(this.head + i))] = e2;
        return e2;
    }

    @Override
    public void add(int i, E e) {
        int s = this.size();
        if (s == this.buf.length) {
            throw new IllegalStateException("Cannot add element. CircularArrayList is filled to capacity.");
        }
        boolean bl = this.full = s + 1 == this.buf.length;
        if (i < 0 || i > s) {
            throw new IndexOutOfBoundsException();
        }
        this.tail = this.wrapIndex(this.tail + 1);
        if (i < s) {
            this.shiftBlock(i, s);
        }
        this.set(i, e);
    }

    @Override
    public E remove(int i) {
        int s = this.size();
        if (i < 0 || i >= s) {
            throw new IndexOutOfBoundsException();
        }
        E e = this.get(i);
        if (i > 0) {
            this.shiftBlock(0, i);
        }
        this.buf[this.head] = null;
        this.head = this.wrapIndex(this.head + 1);
        this.full = false;
        return e;
    }
}

