/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common;

import java.util.Collections;
import java.util.Comparator;
import org.apache.eagle.common.CircularArrayList;

public class CircularArrayListSortedSet<E> {
    private final CircularArrayList<E> list;
    private final Comparator<? super E> comparator;

    public CircularArrayListSortedSet(E[] array) {
        this.list = new CircularArrayList<E>(array);
        this.comparator = null;
    }

    public CircularArrayListSortedSet(E[] array, Comparator<? super E> comparator) {
        this.list = new CircularArrayList<E>(array);
        this.comparator = comparator;
    }

    public int capacity() {
        return this.list.capacity();
    }

    public int head() {
        return this.list.head();
    }

    public int tail() {
        return this.list.tail();
    }

    public boolean isFull() {
        return this.list.isFull();
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public E get(int i) {
        return this.list.get(i);
    }

    public int binarySearch(E e) {
        if (this.comparator != null) {
            return Collections.binarySearch(this.list, e, this.comparator);
        }
        return Collections.binarySearch(this.list, e);
    }

    public int replace(E e) {
        int index = this.binarySearch(e);
        if (index < 0) {
            return -1;
        }
        this.list.set(index, e);
        return index;
    }

    public int insert(E e) {
        int index = this.binarySearch(e);
        if (index > 0) {
            return -1;
        }
        index = 0 - index - 1;
        this.list.add(index, e);
        return index;
    }

    public E remove(int i) {
        return this.list.remove(i);
    }

    public int remove(E e) {
        int index = this.binarySearch(e);
        if (index > 0) {
            this.list.remove(index);
            return index;
        }
        return -1;
    }
}

