/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.eagle.common.config.EagleConfigFactory;

public class DateTimeUtil {
    public static final long ONESECOND = 1000L;
    public static final long ONEMINUTE = 60000L;
    public static final long ONEHOUR = 3600000L;
    public static final long ONEDAY = 86400000L;
    private static TimeZone CURRENT_TIME_ZONE = EagleConfigFactory.load().getTimeZone();

    public static Date humanDateToDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        return sdf.parse(date);
    }

    public static String secondsToHumanDate(long seconds) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date t = new Date();
        t.setTime(seconds * 1000L);
        return sdf.format(t);
    }

    public static String millisecondsToHumanDateWithMilliseconds(long milliseconds) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date t = new Date();
        t.setTime(milliseconds);
        return sdf.format(t);
    }

    public static String millisecondsToHumanDateWithSeconds(long milliseconds) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date t = new Date();
        t.setTime(milliseconds);
        return sdf.format(t);
    }

    public static long humanDateToSeconds(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date d = sdf.parse(date);
        return d.getTime() / 1000L;
    }

    public static long humanDateToMilliseconds(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date d = sdf.parse(date);
        return d.getTime();
    }

    public static long humanDateToMillisecondsWithoutException(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            sdf.setTimeZone(CURRENT_TIME_ZONE);
            Date d = sdf.parse(date);
            return d.getTime();
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static long humanDateToSecondsWithoutException(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(CURRENT_TIME_ZONE);
            Date d = sdf.parse(date);
            return d.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static long maprhumanDateToMilliseconds(String date) throws ParseException {
        date = date.replace('T', ' ');
        date = date.replace('Z', ' ');
        date = date.replace('.', ',');
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS ");
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date d = sdf.parse(date);
        return d.getTime();
    }

    public static long roundDown(int field, long timeInMillis) {
        switch (field) {
            case 5: 
            case 6: 
            case 7: {
                return timeInMillis - timeInMillis % 86400000L;
            }
            case 10: {
                return timeInMillis - timeInMillis % 3600000L;
            }
            case 12: {
                return timeInMillis - timeInMillis % 60000L;
            }
            case 13: {
                return timeInMillis - timeInMillis % 1000L;
            }
        }
        return 0L;
    }

    public static String format(long milliseconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(CURRENT_TIME_ZONE);
        Date t = new Date();
        t.setTime(milliseconds);
        return sdf.format(t);
    }
}

