/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eagle.common.config.EagleConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagleConfigFactory
implements EagleConfig {
    private static final Logger LOG = LoggerFactory.getLogger(EagleConfigFactory.class);
    private String env;
    private String zkQuorum;
    private String zkPort;
    private Configuration hbaseConf;
    private String eagleServiceHost;
    private int eagleServicePort;
    private String storageType;
    private Config config;
    private TimeZone timeZone;
    private boolean isCoprocessorEnabled;
    private boolean tableNamePrefixedWithEnv;
    private HTablePool pool;
    private int hbaseClientScanCacheSize = 1000;
    private ThreadPoolExecutor executor = null;
    private static EagleConfigFactory manager = new EagleConfigFactory();
    boolean isServiceAuditingEnabled;

    @Override
    public boolean isCoprocessorEnabled() {
        return this.isCoprocessorEnabled;
    }

    private EagleConfigFactory() {
        this.init();
        if (this.getStorageType() == null || this.getStorageType().equalsIgnoreCase("hbase")) {
            this.pool = new HTablePool(this.hbaseConf, 10);
        }
    }

    public static EagleConfig load() {
        return manager;
    }

    @Override
    public HTableInterface getHTable(String tableName) {
        return this.pool.getTable(tableName);
    }

    private String getString(Config config, String path, String defaultValue) {
        if (config.hasPath(path)) {
            return config.getString(path);
        }
        return defaultValue;
    }

    @Override
    public String getStorageType() {
        return this.storageType;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private void init() {
        this.config = ConfigFactory.load();
        this.timeZone = TimeZone.getTimeZone(this.config.hasPath("eagle.timezone") ? this.config.getString("eagle.timezone") : "UTC");
        this.env = this.config.hasPath("eagle.service.env") ? this.config.getString("eagle.service.env") : "dev";
        this.zkQuorum = this.config.hasPath("eagle.service.hbase-zookeeper-quorum") ? this.config.getString("eagle.service.hbase-zookeeper-quorum") : null;
        this.zkPort = this.config.hasPath("eagle.service.hbase-zookeeper-property-clientPort") ? this.config.getString("eagle.service.hbase-zookeeper-property-clientPort") : null;
        String zkZnodeParent = this.config.hasPath("eagle.service.zookeeper-znode-parent") ? this.config.getString("eagle.service.zookeeper-znode-parent") : "/hbase-unsecure";
        String clientIPCPoolSize = this.getString(this.config, "eagle.service.hbase-client-ipc-pool-size", "10");
        this.hbaseConf = HBaseConfiguration.create();
        if (this.zkQuorum != null) {
            this.hbaseConf.set("hbase.zookeeper.quorum", this.zkQuorum);
        }
        if (this.zkPort != null) {
            this.hbaseConf.set("hbase.zookeeper.property.clientPort", this.zkPort);
        }
        if (zkZnodeParent != null) {
            this.hbaseConf.set("zookeeper.znode.parent", zkZnodeParent);
        } else {
            this.hbaseConf.set("zookeeper.znode.parent", "/hbase-unsecure");
        }
        this.hbaseConf.set("hbase.client.ipc.pool.size", clientIPCPoolSize);
        this.eagleServiceHost = this.config.hasPath("eagle.service.host") ? this.config.getString("eagle.service.host") : "localhost";
        this.storageType = this.config.hasPath("eagle.service.storage-type") ? this.config.getString("eagle.service.storage-type") : "hbase";
        this.isCoprocessorEnabled = this.config.hasPath("eagle.service.coprocessor-enabled") && this.config.getBoolean("eagle.service.coprocessor-enabled");
        this.eagleServicePort = this.config.hasPath("eagle.service.port") ? this.config.getInt("eagle.service.port") : 8080;
        this.tableNamePrefixedWithEnv = this.config.hasPath("eagle.service.table-name-prefixed-with-environment") && this.config.getBoolean("eagle.service.table-name-prefixed-with-environment");
        this.hbaseClientScanCacheSize = this.config.hasPath("eagle.service.hbase-client-scan-cache-size") ? this.config.getInt("eagle.service.hbase-client-scan-cache-size") : this.hbaseClientScanCacheSize;
        int threadPoolCoreSize = this.config.hasPath("eagle.service.threadpool-core-size") ? this.config.getInt("eagle.service.threadpool-core-size") : 10;
        int threadPoolMaxSize = this.config.hasPath("eagle.service.threadpool-max-size") ? this.config.getInt("eagle.service.threadpool-max-size") : 20;
        long threadPoolShrinkTime = this.config.hasPath("eagle.service.threadpool-shrink-size") ? this.config.getLong("eagle.service.threadpool-shrink-size") : 60000L;
        this.isServiceAuditingEnabled = this.config.hasPath("eagle.service.audit-enabled") && this.config.getBoolean("eagle.service.audit-enabled");
        this.executor = new ThreadPoolExecutor(threadPoolCoreSize, threadPoolMaxSize, threadPoolShrinkTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        LOG.info("Successfully initialized config");
        if (LOG.isDebugEnabled()) {
            if (this.isCoprocessorEnabled) {
                LOG.debug("Eagle HBase Coprocessor is enabled");
            } else {
                LOG.debug("Eagle HBase Coprocessor is disabled");
            }
        }
    }

    @Override
    public Configuration getHbaseConf() {
        return this.hbaseConf;
    }

    @Override
    public String getZKQuorum() {
        return this.zkQuorum;
    }

    @Override
    public String getZKPort() {
        return this.zkPort;
    }

    @Override
    public String getServiceHost() {
        return this.eagleServiceHost;
    }

    @Override
    public int getServicePort() {
        return this.eagleServicePort;
    }

    @Override
    public String getEnv() {
        return this.env;
    }

    @Override
    public boolean isTableNamePrefixedWithEnvironment() {
        return this.tableNamePrefixedWithEnv;
    }

    @Override
    public int getHBaseClientScanCacheSize() {
        return this.hbaseClientScanCacheSize;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isServiceAuditingEnabled() {
        return this.isServiceAuditingEnabled;
    }
}

