/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common.email;

import com.netflix.config.ConcurrentMapConfiguration;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagleMailClient {
    private static final String BASE_PATH = "templates/";
    private static final String AUTH_CONFIG = "mail.smtp.auth";
    private static final String DEBUG_CONFIG = "mail.debug";
    private static final String USER_CONFIG = "mail.user";
    private static final String PASSWORD_CONFIG = "mail.password";
    private VelocityEngine velocityEngine;
    private Session session;
    private static final Logger LOG = LoggerFactory.getLogger(EagleMailClient.class);

    public EagleMailClient() {
        this((AbstractConfiguration)new ConcurrentMapConfiguration());
    }

    public EagleMailClient(AbstractConfiguration configuration) {
        try {
            ConcurrentMapConfiguration con = (ConcurrentMapConfiguration)configuration;
            this.velocityEngine = new VelocityEngine();
            this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
            this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            this.velocityEngine.init();
            con.setProperty("mail.transport.protocol", (Object)"smtp");
            final Properties config = con.getProperties();
            this.session = Boolean.parseBoolean(config.getProperty(AUTH_CONFIG)) ? Session.getDefaultInstance((Properties)config, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(config.getProperty(EagleMailClient.USER_CONFIG), config.getProperty(EagleMailClient.PASSWORD_CONFIG));
                }
            }) : Session.getDefaultInstance((Properties)config, (Authenticator)new Authenticator(){});
            String debugMode = config.getProperty(DEBUG_CONFIG, "false");
            boolean debug = Boolean.parseBoolean(debugMode);
            this.session.setDebug(debug);
        }
        catch (Exception e) {
            LOG.error("Failed connect to smtp server", (Throwable)e);
        }
    }

    private boolean _send(String from, String to, String cc, String title, String content) {
        MimeMessage msg = new MimeMessage(this.session);
        try {
            msg.setFrom((Address)new InternetAddress(from));
            msg.setSubject(title);
            if (to != null) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            }
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
            }
            msg.setContent((Object)content, "text/html;charset=utf-8");
            LOG.info(String.format("Going to send mail: from[%s], to[%s], cc[%s], title[%s]", from, to, cc, title));
            Transport.send((Message)msg);
            return true;
        }
        catch (AddressException e) {
            LOG.info("Send mail failed, got an AddressException: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (MessagingException e) {
            LOG.info("Send mail failed, got an AddressException: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean _send(String from, String to, String cc, String title, String content, List<MimeBodyPart> attachments) {
        MimeMessage mail = new MimeMessage(this.session);
        try {
            mail.setFrom((Address)new InternetAddress(from));
            mail.setSubject(title);
            if (to != null) {
                mail.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            }
            if (cc != null) {
                mail.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)content, "text/html;charset=utf-8");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            for (MimeBodyPart attachment : attachments) {
                multipart.addBodyPart((BodyPart)attachment);
            }
            mail.setContent((Multipart)multipart);
            LOG.info(String.format("Going to send mail: from[%s], to[%s], cc[%s], title[%s]", from, to, cc, title));
            Transport.send((Message)mail);
            return true;
        }
        catch (AddressException e) {
            LOG.info("Send mail failed, got an AddressException: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (MessagingException e) {
            LOG.info("Send mail failed, got an AddressException: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean send(String from, String to, String cc, String title, String content) {
        return this._send(from, to, cc, title, content);
    }

    public boolean send(String from, String to, String cc, String title, String templatePath, VelocityContext context) {
        Template t = null;
        try {
            t = this.velocityEngine.getTemplate(BASE_PATH + templatePath);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        if (t == null) {
            try {
                t = this.velocityEngine.getTemplate(templatePath);
            }
            catch (ResourceNotFoundException e) {
                t = this.velocityEngine.getTemplate("/" + templatePath);
            }
        }
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug(writer.toString());
        }
        return this.send(from, to, cc, title, writer.toString());
    }

    public boolean send(String from, String to, String cc, String title, String templatePath, VelocityContext context, Map<String, File> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return this.send(from, to, cc, title, templatePath, context);
        }
        Template t = null;
        ArrayList<MimeBodyPart> mimeBodyParts = new ArrayList<MimeBodyPart>();
        HashMap<String, String> cid = new HashMap<String, String>();
        for (Map.Entry<String, File> entry : attachments.entrySet()) {
            String attachment = entry.getKey();
            File attachmentFile = entry.getValue();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (attachmentFile != null && attachmentFile.exists()) {
                FileDataSource source = new FileDataSource(attachmentFile);
                try {
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    mimeBodyPart.setFileName(attachment);
                    mimeBodyPart.setDisposition("attachment");
                    mimeBodyPart.setContentID(attachment);
                    cid.put(attachment, mimeBodyPart.getContentID());
                    mimeBodyParts.add(mimeBodyPart);
                }
                catch (MessagingException e) {
                    LOG.error("Generate mail failed, got exception while attaching files: " + e.getMessage(), (Throwable)e);
                }
                continue;
            }
            LOG.error("Attachment: " + attachment + " is null or not exists");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cid maps: " + cid);
        }
        context.put("cid", cid);
        try {
            t = this.velocityEngine.getTemplate(BASE_PATH + templatePath);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        if (t == null) {
            try {
                t = this.velocityEngine.getTemplate(templatePath);
            }
            catch (ResourceNotFoundException e) {
                try {
                    t = this.velocityEngine.getTemplate("/" + templatePath);
                }
                catch (Exception ex) {
                    LOG.error("Template not found:/" + templatePath, (Throwable)ex);
                }
            }
        }
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        if (LOG.isDebugEnabled()) {
            LOG.debug(writer.toString());
        }
        return this._send(from, to, cc, title, writer.toString(), mimeBodyParts);
    }
}

