/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common.metric;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertContext
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AlertContext.class);
    private Map<String, String> properties = new HashMap<String, String>();

    public AlertContext() {
    }

    public AlertContext(AlertContext context) {
        this.properties = new HashMap<String, String>(context.properties);
    }

    public String removeProperty(String name) {
        return this.properties.remove(name);
    }

    public AlertContext addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public AlertContext addAll(Map<String, String> propHash) {
        this.properties.putAll(propHash);
        return this;
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(this.properties);
        }
        catch (Exception ex) {
            LOG.error("fail converting alertcontext into string", (Throwable)ex);
            return null;
        }
    }

    public static AlertContext fromJsonString(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map m = (Map)objectMapper.readValue(json, Map.class);
            AlertContext c = new AlertContext();
            c.addAll(m);
            return c;
        }
        catch (Exception ex) {
            LOG.error("fail converting string into alertcontext", (Throwable)ex);
            return null;
        }
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        return this.properties.toString();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

