/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eagle.common.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.eagle.common.config.EagleConfig;
import org.apache.eagle.common.config.EagleConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapService.class);
    private final List<String> ldapSrvs;
    private String ldapCerts;
    private final String securityPrincipal;
    private final String securityCredentials;
    public static final String SECURITY_PRINCIPAL_CONFIG_NAME = "eagle.ldap.security-principal";
    public static final String SECURITY_CREDENTIALS_CONFIG_NAME = "eagle.ldap.security-credentials";
    public static final String LDAP_SERVER_CONFIG_NAME = "eagle.ldap.server";
    public static final String LDAP_CERTS_CONFIG_NAME = "eagle.ldap.certs";
    public static final String DEFAULT_LDAP_CERTS_FILE_NAME = "jssecacerts";
    private static LdapService instance;
    public static final String CN = "cn";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String SAMACCOUNT_NAME = "sAMAccountName";
    public static final String TELEPHONE_NUMBER = "telephonenumber";
    public static final String GIVEN_NAME = "givenName";
    public static final String UID_NUMBER = "uidNumber";
    public static final String L = "l";
    public static final String ST = "st";
    public static final String CO = "co";
    public static final String MEMBER_OF = "memberof";
    public static final String SN = "sn";
    public static final String MAIL = "mail";
    public static final String DISTINGUISHED_NAME = "distinguishedName";

    private LdapService() {
        EagleConfig manager = EagleConfigFactory.load();
        this.securityPrincipal = manager.getConfig().getString(SECURITY_PRINCIPAL_CONFIG_NAME);
        this.securityCredentials = manager.getConfig().getString(SECURITY_CREDENTIALS_CONFIG_NAME);
        String ldapServer = manager.getConfig().getString(LDAP_SERVER_CONFIG_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("eagle.ldap.security-principal:" + this.securityPrincipal);
        }
        if (this.securityCredentials != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("eagle.ldap.security-credentials: (hidden for security, length: " + this.securityCredentials.length() + ")");
            }
        } else {
            LOG.warn("eagle.ldap.security-credentials:" + null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("eagle.ldap.server:" + ldapServer);
        }
        this.ldapSrvs = Arrays.asList(ldapServer.split(","));
        this.ldapCerts = manager.getConfig().getString(LDAP_CERTS_CONFIG_NAME);
        if (this.ldapCerts == null) {
            this.ldapCerts = LdapService.class.getClassLoader().getResource(DEFAULT_LDAP_CERTS_FILE_NAME).getPath();
        } else if (!this.ldapCerts.startsWith("/") && !this.ldapCerts.matches("[a-zA-Z]+:.*")) {
            this.ldapCerts = LdapService.class.getClassLoader().getResource(this.ldapCerts).getPath();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("eagle.ldap.security-principal: " + this.securityPrincipal);
            if (this.securityCredentials == null) {
                LOG.debug("eagle.ldap.security-credentials: null");
            } else {
                LOG.debug("eagle.ldap.security-credentials: (hidden, length: " + this.securityCredentials.length() + ")");
            }
            LOG.debug("eagle.ldap.server: " + this.ldapSrvs);
            LOG.debug("eagle.ldap.certs: " + this.ldapCerts);
        }
    }

    public static LdapService getInstance() {
        if (instance == null) {
            instance = new LdapService();
        }
        return instance;
    }

    protected DirContext getDirContext(int id) {
        if (this.ldapCerts != null) {
            System.setProperty("javax.net.ssl.keyStore", this.ldapCerts);
            System.setProperty("javax.net.ssl.trustStore", this.ldapCerts);
        }
        String host = this.ldapSrvs.get(id);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.protocol", "ssl");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", host);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.securityPrincipal);
        env.put("java.naming.security.credentials", this.securityCredentials);
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        env.put("java.naming.ldap.factory.socket", "hadoop.eagle.common.service.TrustAllSSLSocketFactory");
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (Exception e) {
            ctx = null;
            LOG.error("LDAP authentication failed with exception: " + e.getMessage(), (Throwable)e);
        }
        return ctx;
    }

    protected SearchControls getSearchControl() {
        SearchControls sc = new SearchControls();
        String[] attributeFilter = new String[15];
        attributeFilter[0] = CN;
        attributeFilter[1] = DISPLAY_NAME;
        attributeFilter[2] = DESCRIPTION;
        attributeFilter[3] = SAMACCOUNT_NAME;
        attributeFilter[4] = TELEPHONE_NUMBER;
        attributeFilter[5] = GIVEN_NAME;
        attributeFilter[6] = UID_NUMBER;
        attributeFilter[7] = L;
        attributeFilter[8] = ST;
        attributeFilter[9] = CO;
        attributeFilter[10] = MEMBER_OF;
        attributeFilter[11] = SN;
        attributeFilter[12] = MAIL;
        attributeFilter[13] = DISTINGUISHED_NAME;
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        return sc;
    }

    public Map<String, String> getUserInfo(String userName) {
        Map<String, String> infos = null;
        for (int i = 0; i < this.ldapSrvs.size(); ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using server: " + this.ldapSrvs.get(i));
            }
            if ((infos = this.getUserInfo(i, userName)).size() > 0) break;
        }
        return infos;
    }

    public Map<String, String> getUserInfo(int id, String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ldap get user information for id:" + id + ", username:" + userName);
        }
        DirContext ctx = this.getDirContext(id);
        HashMap<String, String> infos = new HashMap<String, String>();
        if (ctx != null) {
            try {
                SearchControls sc = this.getSearchControl();
                String filter = "(&(objectClass=user)(sAMAccountName=" + userName + "))";
                NamingEnumeration<SearchResult> results = ctx.search("OU=Accounts_User,DC=corp,DC=company1,DC=com", filter, sc);
                while (results.hasMore()) {
                    SearchResult sr = results.next();
                    Attributes attrs = sr.getAttributes();
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMoreElements()) {
                        Attribute attr = ae.next();
                        String attrId = attr.getID();
                        NamingEnumeration<?> vals = attr.getAll();
                        while (vals.hasMore()) {
                            String thing = vals.next().toString();
                            infos.put(attrId, thing);
                        }
                    }
                }
            }
            catch (NamingException e) {
                LOG.error("LDAP authentication failed with exception: " + e.getMessage(), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(((Object)infos).toString());
        }
        return infos;
    }

    public boolean authenticate(String userName, String password) {
        for (int i = 0; i < this.ldapSrvs.size(); ++i) {
            if (!this.authenticate(i, userName, password)) continue;
            return true;
        }
        return false;
    }

    public boolean authenticate(int id, String userName, String password) {
        boolean result = false;
        DirContext ctx = this.getDirContext(id);
        if (ctx != null) {
            try {
                SearchControls sc = this.getSearchControl();
                String filter = "(&(objectClass=user)(sAMAccountName=" + userName + "))";
                NamingEnumeration<SearchResult> results = ctx.search("OU=Accounts_User,DC=corp,DC=company1,DC=com", filter, sc);
                String userDN = null;
                if (results.hasMore()) {
                    while (results.hasMore()) {
                        SearchResult sr = results.next();
                        Attributes attrs = sr.getAttributes();
                        userDN = attrs.get(DISTINGUISHED_NAME).get().toString();
                    }
                }
                ctx.close();
                if (userDN != null) {
                    Hashtable<String, String> uenv = new Hashtable<String, String>();
                    uenv.put("java.naming.security.protocol", "ssl");
                    uenv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    uenv.put("java.naming.provider.url", this.ldapSrvs.get(id));
                    uenv.put("java.naming.security.authentication", "simple");
                    uenv.put("java.naming.security.principal", userDN);
                    uenv.put("java.naming.security.credentials", password);
                    uenv.put("java.naming.ldap.factory.socket", "hadoop.eagle.common.service.TrustAllSSLSocketFactory");
                    InitialDirContext uctx = new InitialDirContext(uenv);
                    uctx.close();
                    result = true;
                }
            }
            catch (NamingException e) {
                LOG.error("LDAP authentication failed with exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

