/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateForTask
implements Serializable {
    private static final long serialVersionUID = -2394696997971923995L;
    private static final Logger LOG = LoggerFactory.getLogger(StateForTask.class);
    private final SerializedValue<StateHandle<?>> state;
    private final JobVertexID operatorId;
    private final int subtask;

    public StateForTask(SerializedValue<StateHandle<?>> state, JobVertexID operatorId, int subtask) {
        this.state = Preconditions.checkNotNull(state, "State");
        this.operatorId = Preconditions.checkNotNull(operatorId, "Operator ID");
        Preconditions.checkArgument(subtask >= 0, "Negative subtask index");
        this.subtask = subtask;
    }

    public SerializedValue<StateHandle<?>> getState() {
        return this.state;
    }

    public JobVertexID getOperatorId() {
        return this.operatorId;
    }

    public int getSubtask() {
        return this.subtask;
    }

    public void discard(ClassLoader userClassLoader) {
        try {
            ((StateHandle)this.state.deserializeValue(userClassLoader)).discardState();
        }
        catch (Exception e) {
            LOG.warn("Failed to discard checkpoint state: " + this, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StateForTask) {
            StateForTask that = (StateForTask)o;
            return this.subtask == that.subtask && this.operatorId.equals((Object)that.operatorId) && this.state.equals(that.state);
        }
        return false;
    }

    public int hashCode() {
        return this.state.hashCode() + 31 * this.operatorId.hashCode() + 43 * this.subtask;
    }

    public String toString() {
        return String.format("StateForTask %s-%d : %s", new Object[]{this.operatorId, this.subtask, this.state});
    }
}

