/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;

public class ZooKeeperCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final CuratorFramework client;
    private final Configuration config;

    public ZooKeeperCheckpointRecoveryFactory(CuratorFramework client, Configuration config) {
        this.client = Preconditions.checkNotNull(client, "Curator client");
        this.config = Preconditions.checkNotNull(config, "Configuration");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.client.close();
    }

    @Override
    public CompletedCheckpointStore createCompletedCheckpoints(JobID jobId, ClassLoader userClassLoader) throws Exception {
        return ZooKeeperUtils.createCompletedCheckpoints(this.client, this.config, jobId, 1, userClassLoader);
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) throws Exception {
        return ZooKeeperUtils.createCheckpointIDCounter(this.client, this.config, jobID);
    }
}

