/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class ResultPartitionLocation
implements Serializable {
    private final LocationType locationType;
    private final ConnectionID connectionId;

    private ResultPartitionLocation(LocationType locationType, ConnectionID connectionId) {
        this.locationType = Preconditions.checkNotNull(locationType);
        this.connectionId = connectionId;
    }

    public static ResultPartitionLocation createRemote(ConnectionID connectionId) {
        return new ResultPartitionLocation(LocationType.REMOTE, Preconditions.checkNotNull(connectionId));
    }

    public static ResultPartitionLocation createLocal() {
        return new ResultPartitionLocation(LocationType.LOCAL, null);
    }

    public static ResultPartitionLocation createUnknown() {
        return new ResultPartitionLocation(LocationType.UNKNOWN, null);
    }

    public boolean isLocal() {
        return this.locationType == LocationType.LOCAL;
    }

    public boolean isRemote() {
        return this.locationType == LocationType.REMOTE;
    }

    public boolean isUnknown() {
        return this.locationType == LocationType.UNKNOWN;
    }

    public ConnectionID getConnectionId() {
        return this.connectionId;
    }

    public String toString() {
        return "ResultPartitionLocation [" + (Object)((Object)this.locationType) + (this.isRemote() ? " [" + this.connectionId + "]]" : "]");
    }

    private static enum LocationType {
        LOCAL,
        REMOTE,
        UNKNOWN;

    }
}

