/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.lang.reflect.Method;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001b\t)Bj\\2bY\u001ac\u0017N\\6NS:L7\t\\;ti\u0016\u0014(BA\u0002\u0005\u0003-i\u0017N\\5dYV\u001cH/\u001a:\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\tGY&t7.T5oS\u000ecWo\u001d;fe\"I1\u0003\u0001B\u0001B\u0003%ACG\u0001\u0012kN,'oQ8oM&<WO]1uS>t\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011\u0011D\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\n\u0005M\u0001\u0002\"\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f$\u0003E\u0019\u0018N\\4mK\u0006\u001bGo\u001c:TsN$X-\u001c\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b\u0005>|G.Z1o\u0013\t!\u0003#\u0001\u000bvg\u0016\u001c\u0016N\\4mK\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\nM\u0001\u0011\t\u0011)A\u0005O-\nQb\u001d;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001\u0015*\u001b\u0005!\u0011B\u0001\u0016\u0005\u00055\u0019FO]3b[&tw-T8eK&\u0011a\u0005\u0005\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\u0002\u0014G\r\t\u0003\u001f\u0001AQa\u0005\u0017A\u0002QAQ\u0001\b\u0017A\u0002uAQA\n\u0017A\u0002\u001dBQ!\f\u0001\u0005\u0002Q\"2aL\u001b7\u0011\u0015\u00192\u00071\u0001\u0015\u0011\u0015a2\u00071\u0001\u001e\u0011\u0015i\u0003\u0001\"\u00019)\ty\u0013\bC\u0003\u0014o\u0001\u0007A\u0003C\u0003<\u0001\u0011\u0005C(A\u000bhK:,'/\u0019;f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005Qi\u0004\"B\n;\u0001\u0004!\u0002\"B \u0001\t\u0003\u0002\u0015aD:uCJ$(j\u001c2NC:\fw-\u001a:\u0015\u0007\u0005Ke\n\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006)\u0011m\u0019;pe*\ta)\u0001\u0003bW.\f\u0017B\u0001%D\u0005!\t5\r^8s%\u00164\u0007\"\u0002&?\u0001\u0004Y\u0015!B5oI\u0016D\bC\u0001\u0010M\u0013\tiuDA\u0002J]RDQa\u0014 A\u0002A\u000baa]=ti\u0016l\u0007C\u0001\"R\u0013\t\u00116IA\u0006BGR|'oU=ti\u0016l\u0007\"\u0002+\u0001\t\u0003*\u0016\u0001E:uCJ$H+Y:l\u001b\u0006t\u0017mZ3s)\r\tek\u0016\u0005\u0006\u0015N\u0003\ra\u0013\u0005\u0006\u001fN\u0003\r\u0001\u0015\u0005\u00063\u0002!\tAW\u0001\u0011O\u0016$H*Z1eKJ\u0014\u0006k\u0011)peR,\u0012a\u0013\u0005\u00069\u0002!\t!X\u0001\u001aS:LG/[1mSj,\u0017j\u0014$pe6\fGo\u00117bgN,7\u000f\u0006\u0002_CB\u0011adX\u0005\u0003A~\u0011A!\u00168ji\")qc\u0017a\u0001)!)1\r\u0001C\u0001I\u0006I1/\u001a;NK6|'/\u001f\u000b\u0003=\u0016DQA\u001a2A\u0002Q\taaY8oM&<\u0007\"\u00025\u0001\t\u0003I\u0017\u0001E4fi\u0012+g-Y;mi\u000e{gNZ5h+\u0005!\u0002\"B6\u0001\t#a\u0017!E4fi*{'-T1oC\u001e,'OT1nKR\u0011Q\u000e\u001e\t\u0003]Ft!AH8\n\u0005A|\u0012A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001]\u0010\t\u000b)S\u0007\u0019A&\t\u000bY\u0004A\u0011C<\u0002\u001d\u001d,G/\u0011:dQ&4XMT1nKR\u0011Q\u000e\u001f\u0005\u0006\u0015V\u0004\ra\u0013")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        return var2_2;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system) {
        Tuple2<ActorRef, ActorRef> tuple2;
        Configuration config = this.configuration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger("jobmanager.rpc.port", 6123);
        if (jobManagerPort > 0) {
            config.setInteger("jobmanager.rpc.port", jobManagerPort + index);
        }
        if ((tuple2 = JobManager$.MODULE$.startJobManagerActors(config, system, (Option<String>)new Some((Object)jobManagerName), (Option<String>)new Some((Object)archiveName), super.streamingMode(), JobManager.class, MemoryArchivist.class)) != null) {
            ActorRef jobManager;
            ActorRef actorRef;
            ActorRef jobManager2 = actorRef = (jobManager = (ActorRef)tuple2._1());
            return jobManager2;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Configuration config = this.configuration().clone();
        int rpcPort = config.getInteger("taskmanager.rpc.port", 0);
        int dataPort = config.getInteger("taskmanager.data.port", 0);
        if (rpcPort > 0) {
            config.setInteger("taskmanager.rpc.port", rpcPort + index);
        }
        if (dataPort > 0) {
            config.setInteger("taskmanager.data.port", dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder().append((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : TaskManager$.MODULE$.TASK_MANAGER_NAME();
        return TaskManager$.MODULE$.startTaskManagerComponentsAndActor(config, system, this.hostname(), (Option<String>)new Some((Object)taskManagerActorName), (Option<LeaderRetrievalService>)new Some((Object)this.createLeaderRetrievalService()), localExecution, super.streamingMode(), TaskManager.class);
    }

    public int getLeaderRPCPort() {
        Option<Seq<ActorSystem>> option;
        block4: {
            Option option2;
            block7: {
                int n;
                block6: {
                    block5: {
                        int p;
                        int index = this.getLeaderIndex(this.timeout());
                        option = this.jobManagerActorSystems();
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Seq jmActorSystems = (Seq)some.x();
                        option2 = AkkaUtils$.MODULE$.getAddress((ActorSystem)jmActorSystems.apply(index)).port();
                        if (!(option2 instanceof Some)) break block5;
                        Some some2 = (Some)option2;
                        n = p = BoxesRunTime.unboxToInt((Object)some2.x());
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                    n = -1;
                }
                int n2 = n;
                return n2;
            }
            throw new MatchError((Object)option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Seq<ActorSystem>> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new Exception("The JobManager of the LocalFlinkMiniCluster has not been started properly.");
        }
        throw new MatchError(option);
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (config.getInteger("taskmanager.memory.size", -1) == -1) {
            int bufferSize = config.getInteger("taskmanager.memory.segment-size", 32768);
            long bufferMem = config.getLong("taskmanager.network.numberOfBuffers", 2048L) * (long)bufferSize;
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat("taskmanager.memory.fraction", 0.7f);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= bufferMem;
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setLong("taskmanager.memory.size", memorySize >>>= 20);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", this.hostname());
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.JOB_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.JOB_MANAGER_NAME();
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.ARCHIVE_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.ARCHIVE_NAME();
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem, StreamingMode streamingMode) {
        super(userConfiguration, singleActorSystem, streamingMode);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        this(userConfiguration, singleActorSystem, StreamingMode.BATCH_ONLY);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

