/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GenericCollectorMap;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorMapDriver<IT, OT>
implements Driver<GenericCollectorMap<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorMapDriver.class);
    private TaskContext<GenericCollectorMap<IT, OT>, OT> taskContext;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<GenericCollectorMap<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericCollectorMap<IT, OT>> getStubType() {
        Class<GenericCollectorMap> clazz = GenericCollectorMap.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() {
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CollectorMapDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        MutableObjectIterator input = this.taskContext.getInput(0);
        GenericCollectorMap<IT, OT> stub = this.taskContext.getStub();
        Collector<OT> output = this.taskContext.getOutputCollector();
        if (this.objectReuseEnabled) {
            Object record = this.taskContext.getInputSerializer(0).getSerializer().createInstance();
            while (this.running && (record = input.next(record)) != null) {
                stub.map(record, output);
            }
        } else {
            Object record;
            while (this.running && (record = input.next()) != null) {
                stub.map(record, output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

