/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.runtime.operators.AllGroupCombineDriver;
import org.apache.flink.runtime.operators.AllGroupReduceDriver;
import org.apache.flink.runtime.operators.AllReduceDriver;
import org.apache.flink.runtime.operators.BuildFirstCachedJoinDriver;
import org.apache.flink.runtime.operators.BuildSecondCachedJoinDriver;
import org.apache.flink.runtime.operators.CoGroupDriver;
import org.apache.flink.runtime.operators.CoGroupRawDriver;
import org.apache.flink.runtime.operators.CollectorMapDriver;
import org.apache.flink.runtime.operators.CrossDriver;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.FlatMapDriver;
import org.apache.flink.runtime.operators.FullOuterJoinDriver;
import org.apache.flink.runtime.operators.GroupReduceCombineDriver;
import org.apache.flink.runtime.operators.GroupReduceDriver;
import org.apache.flink.runtime.operators.JoinDriver;
import org.apache.flink.runtime.operators.LeftOuterJoinDriver;
import org.apache.flink.runtime.operators.MapDriver;
import org.apache.flink.runtime.operators.MapPartitionDriver;
import org.apache.flink.runtime.operators.NoOpDriver;
import org.apache.flink.runtime.operators.ReduceCombineDriver;
import org.apache.flink.runtime.operators.ReduceDriver;
import org.apache.flink.runtime.operators.RightOuterJoinDriver;
import org.apache.flink.runtime.operators.UnionWithTempOperator;
import org.apache.flink.runtime.operators.chaining.ChainedAllReduceDriver;
import org.apache.flink.runtime.operators.chaining.ChainedCollectorMapDriver;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.chaining.ChainedFlatMapDriver;
import org.apache.flink.runtime.operators.chaining.ChainedMapDriver;
import org.apache.flink.runtime.operators.chaining.SynchronousChainedCombineDriver;

public enum DriverStrategy {
    NONE(null, null, DamBehavior.PIPELINED, 0),
    UNARY_NO_OP(NoOpDriver.class, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, 0),
    BINARY_NO_OP(null, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, 0),
    COLLECTOR_MAP(CollectorMapDriver.class, ChainedCollectorMapDriver.class, DamBehavior.PIPELINED, 0),
    MAP(MapDriver.class, ChainedMapDriver.class, DamBehavior.PIPELINED, 0),
    MAP_PARTITION(MapPartitionDriver.class, null, DamBehavior.PIPELINED, 0),
    FLAT_MAP(FlatMapDriver.class, ChainedFlatMapDriver.class, DamBehavior.PIPELINED, 0),
    ALL_REDUCE(AllReduceDriver.class, ChainedAllReduceDriver.class, DamBehavior.PIPELINED, 0),
    ALL_GROUP_REDUCE(AllGroupReduceDriver.class, null, DamBehavior.PIPELINED, 0),
    ALL_GROUP_REDUCE_COMBINE(AllGroupReduceDriver.class, null, DamBehavior.PIPELINED, 0),
    SORTED_REDUCE(ReduceDriver.class, null, DamBehavior.PIPELINED, 1),
    SORTED_PARTIAL_REDUCE(ReduceCombineDriver.class, null, DamBehavior.MATERIALIZING, 1),
    SORTED_GROUP_REDUCE(GroupReduceDriver.class, null, DamBehavior.PIPELINED, 1),
    SORTED_GROUP_COMBINE(GroupReduceCombineDriver.class, SynchronousChainedCombineDriver.class, DamBehavior.MATERIALIZING, 2),
    ALL_GROUP_COMBINE(AllGroupCombineDriver.class, null, DamBehavior.PIPELINED, 0),
    INNER_MERGE(JoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, 2),
    LEFT_OUTER_MERGE(LeftOuterJoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, 2),
    RIGHT_OUTER_MERGE(RightOuterJoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, 2),
    FULL_OUTER_MERGE(FullOuterJoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, 2),
    CO_GROUP(CoGroupDriver.class, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, 2),
    CO_GROUP_RAW(CoGroupRawDriver.class, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, 0),
    HYBRIDHASH_BUILD_FIRST(JoinDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, 2),
    HYBRIDHASH_BUILD_SECOND(JoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, 2),
    HYBRIDHASH_BUILD_FIRST_CACHED(BuildFirstCachedJoinDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, 2),
    HYBRIDHASH_BUILD_SECOND_CACHED(BuildSecondCachedJoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, 2),
    RIGHT_HYBRIDHASH_BUILD_FIRST(RightOuterJoinDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, 2),
    LEFT_HYBRIDHASH_BUILD_SECOND(LeftOuterJoinDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, 2),
    NESTEDLOOP_BLOCKED_OUTER_FIRST(CrossDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, 0),
    NESTEDLOOP_BLOCKED_OUTER_SECOND(CrossDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, 0),
    NESTEDLOOP_STREAMED_OUTER_FIRST(CrossDriver.class, null, DamBehavior.PIPELINED, DamBehavior.FULL_DAM, 0),
    NESTEDLOOP_STREAMED_OUTER_SECOND(CrossDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.PIPELINED, 0),
    UNION(null, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, 0),
    UNION_WITH_CACHED(UnionWithTempOperator.class, null, DamBehavior.FULL_DAM, DamBehavior.PIPELINED, 0),
    SOURCE(null, null, DamBehavior.PIPELINED, 0),
    SINK(null, null, DamBehavior.PIPELINED, 0);

    private final Class<? extends Driver<?, ?>> driverClass;
    private final Class<? extends ChainedDriver<?, ?>> pushChainDriver;
    private final DamBehavior dam1;
    private final DamBehavior dam2;
    private final int numInputs;
    private final int numRequiredComparators;

    private DriverStrategy(Class<? extends Driver> driverClass, Class<? extends ChainedDriver> pushChainDriverClass, DamBehavior dam, int numComparator) {
        this.driverClass = driverClass;
        this.pushChainDriver = pushChainDriverClass;
        this.numInputs = 1;
        this.dam1 = dam;
        this.dam2 = null;
        this.numRequiredComparators = numComparator;
    }

    private DriverStrategy(Class<? extends Driver> driverClass, Class<? extends ChainedDriver> pushChainDriverClass, DamBehavior firstDam, DamBehavior secondDam, int numComparator) {
        this.driverClass = driverClass;
        this.pushChainDriver = pushChainDriverClass;
        this.numInputs = 2;
        this.dam1 = firstDam;
        this.dam2 = secondDam;
        this.numRequiredComparators = numComparator;
    }

    public Class<? extends Driver<?, ?>> getDriverClass() {
        return this.driverClass;
    }

    public Class<? extends ChainedDriver<?, ?>> getPushChainDriverClass() {
        return this.pushChainDriver;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public DamBehavior firstDam() {
        return this.dam1;
    }

    public DamBehavior secondDam() {
        if (this.numInputs == 2) {
            return this.dam2;
        }
        throw new IllegalArgumentException("The given strategy does not work on two inputs.");
    }

    public DamBehavior damOnInput(int num) {
        if (num < this.numInputs) {
            if (num == 0) {
                return this.dam1;
            }
            if (num == 1) {
                return this.dam2;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isMaterializing() {
        return this.dam1.isMaterializing() || this.dam2 != null && this.dam2.isMaterializing();
    }

    public int getNumRequiredComparators() {
        return this.numRequiredComparators;
    }
}

