/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.hash.HashJoinIteratorBase;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class ReusingBuildFirstHashJoinIterator<V1, V2, O>
extends HashJoinIteratorBase
implements JoinTaskIterator<V1, V2, O> {
    protected final MutableHashTable<V1, V2> hashJoin;
    private final V1 nextBuildSideObject;
    private final V1 tempBuildSideRecord;
    protected final TypeSerializer<V2> probeSideSerializer;
    private final MemoryManager memManager;
    private final MutableObjectIterator<V1> firstInput;
    private final MutableObjectIterator<V2> secondInput;
    private final boolean joinWithEmptyBuildSide;
    private volatile boolean running = true;

    public ReusingBuildFirstHashJoinIterator(MutableObjectIterator<V1> firstInput, MutableObjectIterator<V2> secondInput, TypeSerializer<V1> serializer1, TypeComparator<V1> comparator1, TypeSerializer<V2> serializer2, TypeComparator<V2> comparator2, TypePairComparator<V2, V1> pairComparator, MemoryManager memManager, IOManager ioManager, AbstractInvokable ownerTask, double memoryFraction, boolean joinWithEmptyBuildSide, boolean useBitmapFilters) throws MemoryAllocationException {
        this.memManager = memManager;
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.probeSideSerializer = serializer2;
        if (useBitmapFilters && joinWithEmptyBuildSide) {
            throw new IllegalArgumentException("Bitmap filter may not be activated for joining with empty build side");
        }
        this.joinWithEmptyBuildSide = joinWithEmptyBuildSide;
        this.nextBuildSideObject = serializer1.createInstance();
        this.tempBuildSideRecord = serializer1.createInstance();
        this.hashJoin = this.getHashJoin(serializer1, comparator1, serializer2, comparator2, pairComparator, memManager, ioManager, ownerTask, memoryFraction, useBitmapFilters);
    }

    @Override
    public void open() throws IOException, MemoryAllocationException, InterruptedException {
        this.hashJoin.open(this.firstInput, this.secondInput);
    }

    @Override
    public void close() {
        this.hashJoin.close();
        List<MemorySegment> segments = this.hashJoin.getFreedMemory();
        this.memManager.release(segments);
    }

    @Override
    public final boolean callWithNextKey(FlatJoinFunction<V1, V2, O> matchFunction, Collector<O> collector) throws Exception {
        if (this.hashJoin.nextRecord()) {
            MutableHashTable.HashBucketIterator<V1, V2> buildSideIterator = this.hashJoin.getBuildSideIterator();
            V1 nextBuildSideRecord = this.nextBuildSideObject;
            if ((nextBuildSideRecord = buildSideIterator.next(nextBuildSideRecord)) != null) {
                V1 tmpRec = this.tempBuildSideRecord;
                V2 probeRecord = this.hashJoin.getCurrentProbeRecord();
                if ((tmpRec = buildSideIterator.next(tmpRec)) != null) {
                    matchFunction.join(nextBuildSideRecord, probeRecord, collector);
                    matchFunction.join(tmpRec, probeRecord, collector);
                    while (this.running && (nextBuildSideRecord = buildSideIterator.next(nextBuildSideRecord)) != null) {
                        matchFunction.join(nextBuildSideRecord, probeRecord, collector);
                    }
                } else {
                    matchFunction.join(nextBuildSideRecord, probeRecord, collector);
                }
            } else if (this.joinWithEmptyBuildSide) {
                V2 probeRecord = this.hashJoin.getCurrentProbeRecord();
                matchFunction.join(null, probeRecord, collector);
            }
            return true;
        }
        return false;
    }

    @Override
    public void abort() {
        this.running = false;
        this.hashJoin.abort();
    }
}

