/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.StateBackend;

public abstract class AbstractHeapKvState<K, V, Backend extends StateBackend<Backend>>
implements KvState<K, V, Backend> {
    private final HashMap<K, V> state;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;
    private final V defaultValue;
    private K currentKey;

    protected AbstractHeapKvState(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, V defaultValue) {
        this(keySerializer, valueSerializer, defaultValue, new HashMap());
    }

    protected AbstractHeapKvState(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, V defaultValue, HashMap<K, V> state) {
        this.state = Objects.requireNonNull(state);
        this.keySerializer = Objects.requireNonNull(keySerializer);
        this.valueSerializer = Objects.requireNonNull(valueSerializer);
        this.defaultValue = defaultValue;
    }

    public V value() {
        V value = this.state.get(this.currentKey);
        return (V)(value != null ? value : (this.defaultValue == null ? null : this.valueSerializer.copy(this.defaultValue)));
    }

    public void update(V value) {
        if (value != null) {
            this.state.put(this.currentKey, value);
        } else {
            this.state.remove(this.currentKey);
        }
    }

    @Override
    public void setCurrentKey(K currentKey) {
        this.currentKey = currentKey;
    }

    @Override
    public int size() {
        return this.state.size();
    }

    @Override
    public void dispose() {
        this.state.clear();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    protected void writeStateToOutputView(DataOutputView out) throws IOException {
        for (Map.Entry<K, V> entry : this.state.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), out);
            this.valueSerializer.serialize(entry.getValue(), out);
        }
    }
}

